/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import workbench.interfaces.ResultLogger;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ExecutionStatus;
import workbench.sql.MessagePriority;
import workbench.storage.DataStore;
import workbench.util.DurationFormatter;
import workbench.util.MessageBuffer;

public class StatementRunnerResult {
    private List<ResultSet> results;
    private long totalUpdateCount;
    private long totalRowsProcessed;
    private MessageBuffer messages;
    private List<DataStore> datastores;
    private String sourceCommand;
    private ExecutionStatus status = ExecutionStatus.Success;
    private MessagePriority messagePrio = MessagePriority.normal;
    private boolean hasWarnings;
    private boolean wasCancelled;
    private boolean stopScriptExecution;
    private boolean showRowCount = true;
    private boolean ignoreUpdateCount;
    private boolean wasConsumed = false;
    private long executionTime = -1L;
    private static final DurationFormatter TIMING_FORMATTER = new DurationFormatter();
    private ErrorDescriptor errorDetails;
    private ResultLogger messageLogger;

    public StatementRunnerResult() {
        this.messages = new MessageBuffer();
    }

    public StatementRunnerResult(ResultLogger resultLogger) {
        if (resultLogger != null && resultLogger != ResultLogger.DEV_NULL_LOGGER) {
            this.messageLogger = resultLogger;
        } else {
            this.messages = new MessageBuffer();
        }
    }

    public StatementRunnerResult(String string) {
        this();
        this.sourceCommand = string;
    }

    public StatementRunnerResult(String string, ResultLogger resultLogger) {
        this(resultLogger);
        this.sourceCommand = string;
    }

    public MessagePriority getMessagePriority() {
        return this.messagePrio;
    }

    public void setMessagePriority(MessagePriority messagePriority) {
        this.messagePrio = messagePriority;
    }

    public boolean isIgnoreUpdateCount() {
        return this.ignoreUpdateCount;
    }

    public void ignoreUpdateCounts(boolean bl) {
        this.ignoreUpdateCount = bl;
    }

    public void setRowsProcessed(long l) {
        this.totalRowsProcessed = l;
    }

    public ExecutionStatus getStatus() {
        if (this.status == null) {
            return ExecutionStatus.Success;
        }
        return this.status;
    }

    public long getRowsProcessed() {
        return this.totalRowsProcessed;
    }

    public void addRowsProcessed(long l) {
        this.totalRowsProcessed += l;
    }

    public boolean stopScript() {
        return this.stopScriptExecution;
    }

    public void setStopScript(boolean bl) {
        this.stopScriptExecution = bl;
    }

    public boolean promptingWasCancelled() {
        return this.wasCancelled;
    }

    public void setPromptingWasCancelled() {
        this.wasCancelled = true;
    }

    public void setExecutionDuration(long l) {
        this.executionTime = l;
    }

    public long getExecutionDuration() {
        return this.executionTime;
    }

    public void setShowRowCount(boolean bl) {
        this.showRowCount = bl;
    }

    public void setConsumed(boolean bl) {
        this.wasConsumed = bl;
    }

    public boolean wasConsumed() {
        return this.wasConsumed;
    }

    public boolean getShowRowCount() {
        return this.showRowCount;
    }

    public String getFormattedDuration() {
        if (this.executionTime == -1L) {
            return null;
        }
        return TIMING_FORMATTER.formatDuration(this.executionTime, Settings.getInstance().getDurationFormat(), this.executionTime < 60000L);
    }

    public String getTimingMessage() {
        if (this.executionTime == -1L) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(ResourceMgr.getString("MsgExecTime"));
        stringBuilder.append(' ');
        stringBuilder.append(this.getFormattedDuration());
        return stringBuilder.toString();
    }

    public void appendMessages(ResultLogger resultLogger) {
        if (this.messages == null) {
            return;
        }
        if (this.messageLogger == resultLogger) {
            return;
        }
        this.messages.appendTo(resultLogger);
    }

    public void setSuccess() {
        this.status = ExecutionStatus.Success;
        this.errorDetails = null;
    }

    public void setFailure() {
        this.setFailure(null);
    }

    public void setFailure(ErrorDescriptor errorDescriptor) {
        this.status = ExecutionStatus.Error;
        this.errorDetails = errorDescriptor;
    }

    public void setWarning() {
        this.hasWarnings = true;
    }

    public boolean hasWarning() {
        return this.hasWarnings;
    }

    public ErrorDescriptor getErrorDescriptor() {
        return this.errorDetails;
    }

    public boolean isSuccess() {
        return this.status == ExecutionStatus.Success;
    }

    public void setSourceCommand(String string) {
        this.sourceCommand = string;
    }

    public String getSourceCommand() {
        return this.sourceCommand;
    }

    public int addDataStore(DataStore dataStore) {
        if (this.datastores == null) {
            this.datastores = new ArrayList<DataStore>();
        }
        if (dataStore != null) {
            dataStore.resetCancelStatus();
            this.datastores.add(dataStore);
        }
        return this.datastores.size();
    }

    public int addResultSet(ResultSet resultSet) {
        if (this.results == null) {
            this.results = new ArrayList<ResultSet>();
        }
        this.results.add(resultSet);
        return this.results.size();
    }

    public void addUpdateCountMsg(int n) {
        if (this.ignoreUpdateCount) {
            return;
        }
        this.totalUpdateCount += (long)n;
        this.addMessageByKey("MsgRowsAffected", n);
    }

    public void addErrorMessageByKey(String string) {
        String string2 = ResourceMgr.getString(string);
        this.addErrorMessage(string2);
    }

    public void addErrorMessageByKey(String string, String ... stringArray) {
        String string2 = null;
        string2 = stringArray != null ? ResourceMgr.getFormattedString(string, stringArray) : ResourceMgr.getString(string);
        this.addErrorMessage(string2);
    }

    public void addErrorMessage(String string) {
        this.addMessage(string);
        this.setFailure(new ErrorDescriptor(string));
    }

    public void addErrorMessage(Throwable throwable) {
        ErrorDescriptor errorDescriptor = new ErrorDescriptor(throwable);
        this.addMessage(errorDescriptor.getErrorMessage());
        this.setFailure(errorDescriptor);
    }

    public void addErrorMessage(ErrorDescriptor errorDescriptor, String string) {
        this.addMessage(string);
        this.setFailure(errorDescriptor);
    }

    public void addMessageByKey(String string) {
        this.addMessage(ResourceMgr.getString(string));
    }

    public void addMessageByKey(String string, Object ... objectArray) {
        this.addMessage(ResourceMgr.getFormattedString(string, objectArray));
    }

    public void addMessage(MessageBuffer messageBuffer) {
        if (messageBuffer == null) {
            return;
        }
        if (this.messageLogger != null) {
            this.messageLogger.appendToLog("\n");
            messageBuffer.appendTo(this.messageLogger);
        } else if (this.messages != null) {
            this.messages.append(messageBuffer);
        }
    }

    public void addMessageNewLine() {
        if (this.messageLogger != null) {
            this.messageLogger.appendToLog("\n");
        } else if (this.messages != null) {
            this.messages.appendNewLine();
        }
    }

    public void addWarning(CharSequence charSequence) {
        this.addMessage(charSequence);
        this.hasWarnings = true;
    }

    public void addWarning(MessageBuffer messageBuffer) {
        this.addMessage(messageBuffer);
        this.hasWarnings = true;
    }

    public void addWarningByKey(String string) {
        this.addMessageByKey(string);
        this.hasWarnings = true;
    }

    public void addMessage(CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        if (this.messageLogger != null) {
            this.messageLogger.appendToLog(charSequence.toString());
            this.messageLogger.appendToLog("\n");
            return;
        }
        if (this.messages == null) {
            return;
        }
        if (this.messages.getLength() > 0) {
            this.messages.appendNewLine();
        }
        this.messages.append(charSequence);
    }

    public boolean hasData() {
        return this.hasResultSets() || this.hasDataStores();
    }

    public boolean hasMessages() {
        if (this.messages == null) {
            return false;
        }
        return this.messages.getLength() > 0;
    }

    public boolean hasResultSets() {
        return this.results != null && this.results.size() > 0;
    }

    public boolean hasDataStores() {
        return this.datastores != null && this.datastores.size() > 0;
    }

    public List<DataStore> getDataStores() {
        return this.datastores;
    }

    public List<ResultSet> getResultSets() {
        return this.results;
    }

    public CharSequence getMessages() {
        if (this.messages == null) {
            return null;
        }
        return this.messages.getBuffer();
    }

    public MessageBuffer getMessageBuffer() {
        return this.messages;
    }

    public long getTotalUpdateCount() {
        return this.totalUpdateCount;
    }

    public void clearResultData() {
        if (this.datastores != null) {
            for (DataStore dataStore : this.datastores) {
                if (dataStore == null) continue;
                dataStore.reset();
            }
            this.datastores.clear();
        }
        this.clearResultSets();
    }

    public void clearResultSets() {
        if (this.results != null) {
            for (ResultSet resultSet : this.results) {
                if (resultSet == null) continue;
                try {
                    resultSet.clearWarnings();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            this.results.clear();
        }
    }

    public void clearMessageBuffer() {
        if (this.messages != null) {
            this.messages.clear();
        }
    }

    public void clear() {
        if (this.datastores != null) {
            this.datastores.clear();
        }
        this.clearResultSets();
        this.clearMessageBuffer();
        this.totalUpdateCount = 0L;
        this.sourceCommand = null;
        this.executionTime = -1L;
        this.errorDetails = null;
        this.status = ExecutionStatus.Success;
    }
}

