/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.annotations;

import java.util.ArrayList;
import java.util.List;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.gui.bookmarks.ProcedureBookmarks;
import workbench.resource.GuiSettings;
import workbench.sql.annotations.WbAnnotation;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.StringUtil;

public class BookmarkAnnotation
extends WbAnnotation {
    public static final String ANNOTATION = "WbTag";
    private List<String> validTags = new ArrayList<String>(3);

    public BookmarkAnnotation() {
        super(ANNOTATION);
        this.setUseResultTag(GuiSettings.getUseResultTagForBookmarks());
    }

    public void setUseResultTag(boolean bl) {
        this.validTags.clear();
        this.validTags.add(ANNOTATION.toLowerCase());
        if (bl) {
            this.validTags.add("@" + "WbResult".toLowerCase());
            this.validTags.add("@" + "WbUseTab".toLowerCase());
        }
    }

    public List<NamedScriptLocation> getBookmarks(String string, String string2, ParserType parserType) {
        ArrayList<NamedScriptLocation> arrayList = new ArrayList<NamedScriptLocation>();
        ProcedureBookmarks procedureBookmarks = null;
        if (GuiSettings.getParseProceduresForBookmarks()) {
            procedureBookmarks = new ProcedureBookmarks(string2);
        }
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(parserType, (CharSequence)string);
        SQLToken sQLToken = sQLLexer.getNextToken(true, false);
        while (sQLToken != null) {
            String string3;
            if (sQLToken.isComment() && (string3 = this.findTagValue(sQLToken)) != null) {
                NamedScriptLocation namedScriptLocation = new NamedScriptLocation(string3, sQLToken.getCharBegin(), string2);
                arrayList.add(namedScriptLocation);
            }
            if (procedureBookmarks != null) {
                procedureBookmarks.processToken(sQLToken);
            }
            sQLToken = sQLLexer.getNextToken(true, false);
        }
        if (procedureBookmarks != null) {
            arrayList.addAll(procedureBookmarks.getBookmarks());
        }
        return arrayList;
    }

    private String findTagValue(SQLToken sQLToken) {
        for (String string : this.validTags) {
            String string2 = StringUtil.trim(BookmarkAnnotation.extractAnnotationValue(sQLToken, string));
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }
}

