/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.sql.SQLException;
import workbench.db.CatalogChanger;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class UseCommand
extends SqlCommand {
    public static final String VERB = "USE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        try {
            String string2 = this.getCommandLine(string);
            CatalogChanger catalogChanger = new CatalogChanger();
            catalogChanger.setCurrentCatalog(this.currentConnection, string2);
            String string3 = this.currentConnection.getMetadata().getCurrentCatalog();
            String string4 = StringUtil.capitalize(this.currentConnection.getMetadata().getCatalogTerm());
            String string5 = ResourceMgr.getFormattedString("MsgCatalogChanged", string4, string3);
            statementRunnerResult.addMessage(string5);
            statementRunnerResult.setSuccess();
        }
        catch (Exception exception) {
            statementRunnerResult.addMessageByKey("MsgExecuteError");
            statementRunnerResult.addErrorMessage(ExceptionUtil.getAllExceptions(exception).toString());
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }
}

