/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.formatter;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.Settings;
import workbench.sql.CommandMapper;
import workbench.sql.SqlCommand;
import workbench.sql.formatter.JoinWrapStyle;
import workbench.sql.formatter.SqlFormatter;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.sql.wbcommands.CommandTester;
import workbench.util.ArgumentParser;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbSqlFormatter
implements SqlFormatter {
    private final Set<String> LINE_BREAK_BEFORE = CollectionUtil.unmodifiableSet("SELECT", "SET", "FROM", "WHERE", "ORDER BY", "GROUP BY", "HAVING", "VALUES", "UNION", "UNION ALL", "MINUS", "INTERSECT", "REFRESH", "AS", "FOR", "JOIN", "INNER JOIN", "RIGHT OUTER JOIN", "LEFT OUTER JOIN", "CROSS JOIN", "LEFT JOIN", "RIGHT JOIN", "START WITH", "CONNECT BY", "OUTER APPLY", "CROSS APPLY", "WINDOW", "LIMIT");
    private final Set<String> LINE_BREAK_AFTER = CollectionUtil.unmodifiableSet("UNION", "UNION ALL", "MINUS", "INTERSECT", "AS", "FOR");
    public static final Set<String> HAVING_TERMINAL = CollectionUtil.unmodifiableSet("ORDER BY", "GROUP BY", "UNION", "UNION ALL", "INTERSECT", "MINUS", "WINDOW", ";");
    public static final Set<String> WHERE_TERMINAL = CollectionUtil.unmodifiableSet(HAVING_TERMINAL, "HAVING", "WITH", "FETCH FIRST", "FETCH NEXT", "LIMIT", "OFFSET");
    public static final Set<String> FROM_TERMINAL = CollectionUtil.unmodifiableSet(WHERE_TERMINAL, "WHERE", "START WITH", "CONNECT BY");
    public static final Set<String> JOIN_TERMINAL = CollectionUtil.unmodifiableSet("WHERE", "ORDER BY", "GROUP BY", "UNION", "UNION ALL");
    private final Set<String> GROUP_BY_TERMINAL = CollectionUtil.caseInsensitiveSet(WHERE_TERMINAL, "SELECT", "UPDATE", "DELETE", "INSERT", "CREATE", "CREATE OR REPLACE");
    private final Set<String> CREATE_TABLE_TERMINAL = CollectionUtil.unmodifiableSet("UNIQUE", "CONSTRAINT", "FOREIGN KEY", "PRIMARY KEY");
    private final Set<String> DATE_LITERALS = CollectionUtil.unmodifiableSet("DATE", "TIME", "TIMESTAMP");
    private final Set<String> ORDER_BY_TERMINAL = CollectionUtil.unmodifiableSet(";");
    public static final Set<String> SELECT_TERMINAL = CollectionUtil.unmodifiableSet("FROM");
    public static final Set<String> SET_TERMINAL = CollectionUtil.unmodifiableSet("FROM", "WHERE");
    public static final Set<String> QUERY_START = CollectionUtil.unmodifiableSet("SELECT", "WITH");
    private static final Set<String> INDEX_OPTIONS = CollectionUtil.unmodifiableSet("UNIQUE", "BITMAP", "HASH", "CLUSTERED", "NONCLUSTERED", "FULLTEXT", "SPATIAL", "ONLINE", "OFFLINE");
    private CharSequence sql;
    private SQLLexer lexer;
    private StringBuilder result;
    private StringBuilder indent = null;
    private StringBuilder leadingWhiteSpace = null;
    private int realLength = 0;
    private int maxSubselectLength = 60;
    private Set<String> dbFunctions = CollectionUtil.caseInsensitiveSet();
    private Set<String> dataTypes = CollectionUtil.caseInsensitiveSet();
    private Set<String> keywords = CollectionUtil.caseInsensitiveSet();
    private Set<String> createTableTypes = CollectionUtil.caseInsensitiveSet();
    private Set<String> createViewTypes = CollectionUtil.caseInsensitiveSet();
    private String lineEnding = "\n";
    private boolean addColumnCommentForInsert;
    private boolean newLineForSubSelects;
    private GeneratedIdentifierCase keywordCase = GeneratedIdentifierCase.upper;
    private GeneratedIdentifierCase identifierCase = GeneratedIdentifierCase.asIs;
    private GeneratedIdentifierCase functionCase = GeneratedIdentifierCase.lower;
    private GeneratedIdentifierCase dataTypeCase = GeneratedIdentifierCase.upper;
    private boolean indentWhereConditions;
    private boolean addSpaceAfterComma;
    private boolean commaAfterLineBreak;
    private boolean addSpaceAfterLineBreakComma;
    private boolean indentInsert = true;
    private JoinWrapStyle joinWrapping = JoinWrapStyle.onlyMultiple;
    private String dbId;
    private char catalogSeparator = (char)46;
    private int colsPerInsert = -1;
    private int colsPerUpdate = -1;
    private int colsPerSelect = -1;
    private char schemaSeparator = (char)46;

    WbSqlFormatter(CharSequence charSequence) {
        this(charSequence, 0, Settings.getInstance().getFormatterMaxSubselectLength(), null);
    }

    public WbSqlFormatter(CharSequence charSequence, String string) {
        this(charSequence, 0, Settings.getInstance().getFormatterMaxSubselectLength(), string);
    }

    public WbSqlFormatter(CharSequence charSequence, int n, String string) {
        this(charSequence, 0, n, string);
    }

    public WbSqlFormatter(int n, String string) {
        this(null, 0, n, string);
    }

    WbSqlFormatter(CharSequence charSequence, int n) {
        this(charSequence, 0, n, null);
    }

    public void setCatalogSeparator(char c) {
        this.catalogSeparator = c;
    }

    public void setSchemaSeparator(char c) {
        this.schemaSeparator = c;
    }

    public void setLineEnding(String string) {
        if (string != null) {
            this.lineEnding = string;
        }
    }

    private WbSqlFormatter(CharSequence charSequence, int n, int n2, String string) {
        this.sql = charSequence;
        if (n > 0) {
            this.indent = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                this.indent.append(' ');
            }
        }
        this.maxSubselectLength = n2;
        this.dbFunctions = CollectionUtil.caseInsensitiveSet();
        this.functionCase = Settings.getInstance().getFormatterFunctionCase();
        this.dataTypeCase = Settings.getInstance().getFormatterDatatypeCase();
        this.newLineForSubSelects = Settings.getInstance().getFormatterSubselectInNewLine();
        this.addColumnCommentForInsert = Settings.getInstance().getFormatterAddColumnNameComment();
        this.keywordCase = Settings.getInstance().getFormatterKeywordsCase();
        this.addSpaceAfterComma = Settings.getInstance().getFormatterAddSpaceAfterComma();
        this.indentWhereConditions = Settings.getInstance().getFormatterIndentWhereConditions();
        this.commaAfterLineBreak = Settings.getInstance().getFormatterCommaAfterLineBreak();
        this.addSpaceAfterLineBreakComma = Settings.getInstance().getFormatterAddSpaceAfterLineBreakComma();
        this.joinWrapping = Settings.getInstance().getFormatterJoinWrapStyle();
        this.indentInsert = Settings.getInstance().getFormatterIndentInsert();
        this.identifierCase = Settings.getInstance().getAutoCompletionPasteCase();
        this.setDbId(string);
    }

    @Override
    public boolean supportsMultipleStatements() {
        return false;
    }

    public void setIdentifierCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.identifierCase = generatedIdentifierCase;
    }

    public void setIndentWhereCondition(boolean bl) {
        this.indentWhereConditions = bl;
    }

    public void setColumnsPerInsert(int n) {
        if (n > 0) {
            this.colsPerInsert = n;
        }
    }

    private int getColumnsPerInsert() {
        if (this.colsPerInsert < 0) {
            return Settings.getInstance().getFormatterMaxColumnsInInsert();
        }
        return this.colsPerInsert;
    }

    public void setColumnsPerUpdate(int n) {
        if (n > 0) {
            this.colsPerUpdate = n;
        }
    }

    private int getColumnsPerUpdate() {
        if (this.colsPerUpdate < 0) {
            return Settings.getInstance().getFormatterMaxColumnsInUpdate();
        }
        return this.colsPerUpdate;
    }

    public void setColumnsPerSelect(int n) {
        if (n > 0) {
            this.colsPerSelect = n;
        }
    }

    private int getColumnsPerSelect() {
        if (this.colsPerSelect < 0) {
            return Settings.getInstance().getFormatterMaxColumnsInSelect();
        }
        return this.colsPerSelect;
    }

    public void setJoinWrapping(JoinWrapStyle joinWrapStyle) {
        this.joinWrapping = joinWrapStyle;
    }

    public void setNewLineForSubselects(boolean bl) {
        this.newLineForSubSelects = bl;
    }

    public void setAddColumnNameComment(boolean bl) {
        this.addColumnCommentForInsert = bl;
    }

    public void setDataTypecase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.dataTypeCase = generatedIdentifierCase;
    }

    public void setKeywordCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.keywordCase = generatedIdentifierCase;
    }

    public void setFunctionCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.functionCase = generatedIdentifierCase;
    }

    public String getLineEnding() {
        return this.lineEnding;
    }

    private void setDbId(String string) {
        this.dbId = string;
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper(this.dbId);
        this.keywords.clear();
        this.dataTypes.clear();
        this.dbFunctions.clear();
        this.createTableTypes.clear();
        this.createViewTypes.clear();
        this.keywords.addAll(sqlKeywordHelper.getKeywords());
        this.dataTypes.addAll(sqlKeywordHelper.getDataTypes());
        this.dbFunctions.addAll(sqlKeywordHelper.getSqlFunctions());
        this.createTableTypes.addAll(sqlKeywordHelper.getCreateTableTypes());
        this.createViewTypes.addAll(sqlKeywordHelper.getCreateViewTypes());
        this.keywords.addAll(this.createTableTypes);
        this.keywords.addAll(this.createViewTypes);
    }

    private boolean isDbFunction(SQLToken sQLToken) {
        if (sQLToken == null) {
            return false;
        }
        return this.isDbFunction(sQLToken.getText());
    }

    private boolean isDbFunction(String string) {
        if (this.dbFunctions == null) {
            SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper();
            this.dbFunctions = sqlKeywordHelper.getSqlFunctions();
        }
        return this.dbFunctions.contains(string);
    }

    private boolean isDatatype(String string) {
        return this.dataTypes.contains(string);
    }

    private boolean isKeyword(String string) {
        return this.keywords.contains(string);
    }

    public void setAddSpaceAfterCommInList(boolean bl) {
        this.addSpaceAfterComma = bl;
    }

    public void setCommaAfterLineBreak(boolean bl) {
        this.commaAfterLineBreak = bl;
    }

    public void setAddSpaceAfterLineBreakComma(boolean bl) {
        this.addSpaceAfterLineBreakComma = bl;
    }

    void addDBFunctions(Set<String> set) {
        this.dbFunctions.addAll(set);
    }

    private void saveLeadingWhitespace() {
        if (this.sql.length() == 0) {
            return;
        }
        char c = this.sql.charAt(0);
        int n = 0;
        if (!Character.isWhitespace(c)) {
            return;
        }
        this.leadingWhiteSpace = new StringBuilder(50);
        while (Character.isWhitespace(c)) {
            this.leadingWhiteSpace.append(c);
            if (++n >= this.sql.length()) break;
            c = this.sql.charAt(n);
        }
        this.sql = this.sql.toString().trim();
    }

    @Override
    public String getFormattedSql(String string) {
        this.sql = string;
        return this.getFormattedSql();
    }

    public String getFormattedSql() {
        this.saveLeadingWhitespace();
        if (this.sql.length() == 0) {
            return "";
        }
        this.lexer = SQLLexerFactory.createLexerForDbId(this.dbId, this.sql);
        this.result = new StringBuilder(this.sql.length() + 100);
        this.formatSql();
        StringUtil.trimTrailingWhitespace(this.result);
        if (this.leadingWhiteSpace != null) {
            this.result.insert(0, this.leadingWhiteSpace);
        }
        return this.result.toString();
    }

    private int getRealLength() {
        return this.realLength;
    }

    public void setMaxSubSelectLength(int n) {
        this.maxSubselectLength = n;
    }

    private int getCurrentLineLength() {
        int n = 0;
        for (int i = this.result.length() - 1; this.result.charAt(i) != '\n' && i > 0; --i) {
            ++n;
        }
        return n;
    }

    private void appendNewline() {
        if (this.result.length() == 0) {
            return;
        }
        this.result.append(this.lineEnding);
        if (this.indent != null) {
            this.result.append((CharSequence)this.indent);
        }
    }

    private boolean lastCharIsWhitespace() {
        int n = this.result.length();
        if (n == 0) {
            return false;
        }
        char c = this.result.charAt(n - 1);
        return Character.isWhitespace(c);
    }

    private void appendText(char c) {
        ++this.realLength;
        this.result.append(c);
    }

    private void appendTokenText(SQLToken sQLToken) {
        if (sQLToken == null) {
            return;
        }
        this.appendText(this.getTokenText(sQLToken));
    }

    private void appendIdentifier(String string) {
        if (this.identifierCase == GeneratedIdentifierCase.asIs || this.isQuotedIdentifier(string)) {
            this.appendText(string);
        } else if (this.identifierCase == GeneratedIdentifierCase.lower) {
            this.appendText(string.toLowerCase());
        } else if (this.identifierCase == GeneratedIdentifierCase.upper) {
            this.appendText(string.toUpperCase());
        }
    }

    private String getTokenText(SQLToken sQLToken) {
        if (sQLToken == null) {
            return null;
        }
        String string = sQLToken.getText();
        if (this.isDbFunction(sQLToken)) {
            if (this.functionCase == GeneratedIdentifierCase.lower) {
                string = string.toLowerCase();
            } else if (this.functionCase == GeneratedIdentifierCase.upper) {
                string = string.toUpperCase();
            }
        } else if (this.isDatatype(string)) {
            if (this.dataTypeCase == GeneratedIdentifierCase.upper) {
                string = string.toUpperCase();
            } else if (this.dataTypeCase == GeneratedIdentifierCase.lower) {
                string = string.toLowerCase();
            }
        } else if (this.isKeyword(string)) {
            if (this.keywordCase == GeneratedIdentifierCase.upper) {
                string = string.toUpperCase();
            } else if (this.keywordCase == GeneratedIdentifierCase.lower) {
                string = string.toLowerCase();
            }
        } else if (sQLToken.isIdentifier() && !this.isQuotedIdentifier(string)) {
            if (this.identifierCase == GeneratedIdentifierCase.lower) {
                string = string.toLowerCase();
            } else if (this.identifierCase == GeneratedIdentifierCase.upper) {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    private void appendComment(String string) {
        this.appendComment(string, true);
    }

    private void appendComment(String string, boolean bl) {
        if (string.startsWith("--")) {
            if (bl && !this.isStartOfLine()) {
                this.appendNewline();
            }
        } else if (!this.lastCharIsWhitespace()) {
            this.appendText(' ');
        }
        this.appendText(string);
        if (string.startsWith("--")) {
            this.appendNewline();
        } else {
            this.appendText(' ');
        }
    }

    private void appendText(String string) {
        this.realLength += string.length();
        this.result.append(string);
    }

    private void appendText(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        this.realLength += stringBuilder.length();
        this.result.append((CharSequence)stringBuilder);
    }

    private void indent(String string) {
        this.result.append(string);
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.result.append(' ');
        }
    }

    private void indent(CharSequence charSequence) {
        this.result.append(charSequence);
    }

    private boolean needsWhitespace(SQLToken sQLToken, SQLToken sQLToken2) {
        return this.needsWhitespace(sQLToken, sQLToken2, false, false);
    }

    private boolean needsWhitespace(SQLToken sQLToken, SQLToken sQLToken2, boolean bl) {
        return this.needsWhitespace(sQLToken, sQLToken2, bl, false);
    }

    private boolean needsWhitespace(SQLToken sQLToken, SQLToken sQLToken2, boolean bl, boolean bl2) {
        if (sQLToken == null) {
            return false;
        }
        if (sQLToken2.isWhiteSpace()) {
            return false;
        }
        if (sQLToken.isWhiteSpace()) {
            return false;
        }
        String string = sQLToken.getContents();
        String string2 = sQLToken2.getContents();
        char c = string.charAt(string.length() - 1);
        char c2 = string2.charAt(0);
        if (this.isSchemaOrCatalogSeparator(c2)) {
            return false;
        }
        if (!bl && this.isStartOfLine()) {
            return false;
        }
        boolean bl3 = "(".equals(string2);
        boolean bl4 = "(".equals(string);
        boolean bl5 = ")".equals(string);
        if (string.equals("N") && c2 == '\'') {
            return false;
        }
        if (sQLToken.isComment() && string.startsWith("--")) {
            return false;
        }
        if (this.DATE_LITERALS.contains(string) && sQLToken2.isLiteral()) {
            return true;
        }
        if (string.endsWith("'") && string2.equals("''")) {
            return false;
        }
        if (string.endsWith("'") && string2.equals("}")) {
            return false;
        }
        if (string.equals("''") && string2.startsWith("'")) {
            return false;
        }
        if (c == '\'' && c2 == '\'') {
            return false;
        }
        if (string.endsWith("]") && (sQLToken2.isReservedWord() || sQLToken2.isIdentifier() || sQLToken2.isLiteral() || sQLToken2.isOperator())) {
            return true;
        }
        if (bl3 && this.isDbFunction(string)) {
            return false;
        }
        if (bl3 && this.isDatatype(string2)) {
            return false;
        }
        if (bl3 && this.isKeyword(string)) {
            return true;
        }
        if (bl2) {
            if (bl3 && sQLToken.isIdentifier()) {
                return false;
            }
        } else if (bl3 && sQLToken.isIdentifier()) {
            return true;
        }
        if (bl5 && c2 == ',') {
            return false;
        }
        if (bl5 && (sQLToken2.isIdentifier() || this.isKeyword(string2))) {
            return true;
        }
        if ((c == '-' || c == '+') && sQLToken2.isLiteral() && StringUtil.isNumber(string2)) {
            return true;
        }
        if (sQLToken.isLiteral() && (sQLToken2.isIdentifier() || this.isKeyword(string2) || sQLToken2.isOperator())) {
            return true;
        }
        if (c2 == '?') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (c == '=') {
            return true;
        }
        if (c == '[' && !sQLToken.isIdentifier()) {
            return false;
        }
        if (this.isSchemaOrCatalogSeparator(c) && sQLToken2.isIdentifier()) {
            return false;
        }
        if (this.isSchemaOrCatalogSeparator(c) && c2 == '*') {
            return false;
        }
        if (this.isSchemaOrCatalogSeparator(c) && c2 == '[') {
            return false;
        }
        if (sQLToken.isLiteral() && bl3) {
            return true;
        }
        if (bl4 && this.isKeyword(string2)) {
            return false;
        }
        if (bl5 && !sQLToken2.isSeparator()) {
            return true;
        }
        if ((sQLToken.isIdentifier() || sQLToken.isLiteral()) && sQLToken2.isOperator()) {
            return true;
        }
        if ((sQLToken2.isIdentifier() || sQLToken2.isLiteral()) && sQLToken.isOperator()) {
            return true;
        }
        if (sQLToken2.isSeparator() || sQLToken2.isOperator()) {
            return false;
        }
        if (sQLToken.isOperator() && (this.isKeyword(string2) || sQLToken2.isIdentifier() || sQLToken2.isLiteral())) {
            return true;
        }
        return !sQLToken.isSeparator() && !sQLToken.isOperator();
    }

    private boolean isSchemaOrCatalogSeparator(char c) {
        return c == this.schemaSeparator || c == this.catalogSeparator;
    }

    private SQLToken processHaving(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        SQLToken sQLToken3 = sQLToken;
        Set<String> set = CollectionUtil.caseInsensitiveSet("AND", "OR");
        int n = 0;
        while (sQLToken2 != null) {
            String string = sQLToken2.getContents();
            if (string.equals("(")) {
                ++n;
            }
            if (string.equals(")")) {
                --n;
            }
            if (string.equals("(") && this.isDbFunction(sQLToken3)) {
                if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                    this.appendText(' ');
                }
                this.appendText('(');
                sQLToken2 = this.processFunctionCall(sQLToken2);
                n = 0;
            } else {
                if (string.equalsIgnoreCase("SELECT") && "(".equalsIgnoreCase(sQLToken3.getText())) {
                    if ((sQLToken2 = this.processSubSelect(sQLToken2, 1, false)) != null) continue;
                    return sQLToken2;
                }
                if (set.contains(string) && n == 0) {
                    this.appendNewline();
                    this.indent(3);
                    this.appendTokenText(sQLToken2);
                } else {
                    if (HAVING_TERMINAL.contains(sQLToken2.getText())) {
                        return sQLToken2;
                    }
                    if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                }
            }
            sQLToken3 = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return sQLToken2;
    }

    private SQLToken processFrom(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        SQLToken sQLToken3 = sQLToken;
        int n = 0;
        boolean bl = false;
        Set<String> set = SqlUtil.getJoinKeyWords();
        while (sQLToken2 != null) {
            String string = sQLToken2.getContents();
            if (!bl) {
                bl = set.contains(string);
            }
            if (FROM_TERMINAL.contains(string.toUpperCase())) {
                return sQLToken2;
            }
            if (sQLToken3.getContents().equals("(") && string.equalsIgnoreCase("SELECT")) {
                sQLToken2 = this.processSubSelect(sQLToken2, n, true);
                continue;
            }
            if (sQLToken2.isComment()) {
                this.appendComment(string);
            } else if (string.equals("(")) {
                if (!(sQLToken3.isSeparator() && sQLToken3 != sQLToken2 || this.lastCharIsWhitespace() || this.isDbFunction(sQLToken3))) {
                    this.appendText(' ');
                }
                this.appendText(string);
                ++n;
            } else if (string.equals(")")) {
                this.appendText(string);
                --n;
            } else {
                if (bl) {
                    this.appendNewline();
                    this.indent(2);
                    this.appendTokenText(sQLToken2);
                    sQLToken2 = this.processJoin(sQLToken2);
                    continue;
                }
                if (sQLToken2.isSeparator() && string.equals(",")) {
                    if (!this.commaAfterLineBreak) {
                        this.appendText(',');
                    }
                    if (!bl && n == 0) {
                        this.appendNewline();
                        this.indent(5);
                        if (this.commaAfterLineBreak) {
                            this.appendText(',');
                            if (this.addSpaceAfterLineBreakComma) {
                                this.appendText(' ');
                            }
                        }
                    } else if (n > 0 && this.addSpaceAfterComma) {
                        this.appendText(' ');
                    }
                } else {
                    if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                        this.appendText(' ');
                    }
                    if (this.LINE_BREAK_BEFORE.contains(string) && !string.equalsIgnoreCase("AS")) {
                        this.appendNewline();
                        if (set.contains(string)) {
                            this.indent(2);
                        } else {
                            this.indent(5);
                        }
                    }
                    this.appendTokenText(sQLToken2);
                    if (this.LINE_BREAK_AFTER.contains(string) && !string.equalsIgnoreCase("AS")) {
                        this.appendNewline();
                        this.indent(5);
                    }
                }
            }
            sQLToken3 = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return null;
    }

    private SQLToken processWindowDef(SQLToken sQLToken) {
        int n = 0;
        boolean bl = false;
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        while (sQLToken2 != null) {
            if ("(".equals(sQLToken2.getText())) {
                ++n;
            } else if (")".equals(sQLToken2.getText()) && n > 0 && --n == 0) {
                bl = true;
            }
            if (",".equals(sQLToken2.getText()) && n == 0 && this.commaAfterLineBreak) {
                this.appendNewline();
                this.indent(7);
            }
            if (this.needsWhitespace(sQLToken, sQLToken2)) {
                this.appendText(' ');
            }
            this.appendTokenText(sQLToken2);
            if (",".equals(sQLToken2.getText()) && n == 0 && !this.commaAfterLineBreak) {
                this.appendNewline();
                this.indent(7);
            }
            sQLToken = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
            if (sQLToken2 == null || !bl) continue;
            if (sQLToken2.isReservedWord()) {
                return sQLToken2;
            }
            if (!",".equals(sQLToken2.getText())) continue;
            bl = false;
        }
        return null;
    }

    private SQLToken processJoin(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        int n = sQLToken.getText().length() + 2;
        int n2 = 0;
        int n3 = 0;
        while (sQLToken2 != null) {
            String string = sQLToken2.getContents();
            if (JOIN_TERMINAL.contains(string) || SqlUtil.getJoinKeyWords().contains(string)) {
                return sQLToken2;
            }
            if (sQLToken2.isComment()) {
                this.appendComment(sQLToken2.getText());
            } else if ("(".equals(string)) {
                this.appendText(' ');
                ++n3;
                this.appendTokenText(sQLToken2);
                if (sQLToken.getContents().equals("IN")) {
                    sQLToken2 = this.lexer.getNextToken(true, false);
                    if (sQLToken2 != null && QUERY_START.contains(sQLToken2.getContents())) {
                        this.appendTokenText(sQLToken2);
                        this.appendText(' ');
                        sQLToken2 = this.processSubSelect(null, n3, false);
                    } else {
                        sQLToken2 = this.processInList(sQLToken2);
                    }
                    this.appendTokenText(sQLToken2);
                }
            } else {
                CharSequence charSequence;
                if (sQLToken.getContents().equals("(") && QUERY_START.contains(string)) {
                    charSequence = this.indent;
                    this.indent = new StringBuilder(2);
                    if (charSequence != null) {
                        this.indent.append(charSequence);
                    }
                    this.indent.append("  ");
                    sQLToken2 = this.processSubSelect(sQLToken2, n3, true);
                    this.indent = charSequence;
                    continue;
                }
                if (")".equals(string)) {
                    --n3;
                    this.appendText(')');
                } else if ("AND".equals(string) || "OR".equals(string)) {
                    if (this.joinWrapping != JoinWrapStyle.none) {
                        if (n2 > 0) {
                            charSequence = this.lineEnding + StringUtil.padRight(" ", n - 3, ' ') + (this.indent == null ? "" : this.indent);
                            this.result.insert(n2, (String)charSequence);
                            this.realLength += ((String)charSequence).length();
                            n2 = -1;
                        }
                        this.appendNewline();
                        this.indent(n - string.length());
                    } else {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                } else {
                    if ("ON".equals(string)) {
                        if (this.joinWrapping == JoinWrapStyle.onlyMultiple) {
                            n2 = this.result.length();
                        } else if (this.joinWrapping == JoinWrapStyle.always) {
                            this.appendNewline();
                            this.indent(n - string.length());
                        }
                    }
                    if (this.needsWhitespace(sQLToken, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                }
            }
            sQLToken = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return sQLToken2;
    }

    private SQLToken processList(SQLToken sQLToken, int n, Set<String> set) {
        String string = StringUtil.padRight(" ", n);
        int n2 = 0;
        boolean bl = sQLToken.getContents().equals("SELECT");
        int n3 = -1;
        n3 = bl ? this.getColumnsPerSelect() : this.getColumnsPerUpdate();
        SQLToken sQLToken2 = this.lexer.getNextToken(true, true);
        SQLToken sQLToken3 = sQLToken;
        SQLToken sQLToken4 = null;
        while (sQLToken2 != null) {
            int n4;
            if (sQLToken2.isWhiteSpace()) {
                sQLToken4 = sQLToken2;
                sQLToken2 = this.lexer.getNextToken(true, true);
                continue;
            }
            String string2 = sQLToken2.getContents();
            if (sQLToken2.isComment()) {
                n4 = 0;
                if (sQLToken4 != null) {
                    n4 = sQLToken4.getText().contains("\n") || sQLToken4.getText().contains("\r") ? 1 : 0;
                }
                boolean bl2 = string2.startsWith("--");
                boolean bl3 = this.isStartOfLine();
                if (bl2 && n4 != 0 && !bl3) {
                    this.appendNewline();
                } else if (!bl3) {
                    this.appendText(' ');
                }
                this.appendText(string2);
                if (bl2) {
                    this.appendNewline();
                    this.indent(string);
                }
            } else {
                if (bl && "DECODE".equalsIgnoreCase(string2)) {
                    if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendText(string2);
                    sQLToken2 = this.processDecode(n);
                    continue;
                }
                if ("CASE".equals(string2)) {
                    if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                    n4 = n;
                    if (!bl) {
                        n4 = this.getCurrentLineLength() - 4;
                    }
                    sQLToken2 = this.processCase(n4);
                    continue;
                }
                if (set.contains(string2)) {
                    return sQLToken2;
                }
                if (string2.equals("(")) {
                    if ("=".equals(sQLToken3.getContents()) || ",".equals(sQLToken3.getContents()) || sQLToken3.isLiteral()) {
                        if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                            this.appendText(' ');
                        }
                        this.appendText("(");
                        sQLToken2 = this.processBracketExpression();
                        this.appendTokenText(sQLToken2);
                    } else {
                        if (this.needsWhitespace(sQLToken3, sQLToken2, false, true)) {
                            this.appendText(' ');
                        }
                        this.appendText("(");
                        sQLToken2 = this.processFunctionCall(sQLToken2);
                        if (sQLToken2 == null) {
                            return null;
                        }
                        if (set.contains(sQLToken2.getText())) {
                            return sQLToken2;
                        }
                        if (sQLToken2.isIdentifier() || sQLToken2.isOperator()) {
                            this.appendText(' ');
                            this.appendTokenText(sQLToken2);
                        } else if (this.isKeyword(sQLToken2.getText())) {
                            if (this.LINE_BREAK_BEFORE.contains(sQLToken2.getText())) {
                                this.appendNewline();
                            }
                            this.appendTokenText(sQLToken2);
                        } else if (!")".equals(sQLToken2.getText())) {
                            this.appendTokenText(sQLToken2);
                        }
                    }
                } else if (string2.equals(",")) {
                    if (!this.commaAfterLineBreak || !this.needLineBreak(n3, ++n2)) {
                        this.appendText(',');
                    }
                    if (this.needLineBreak(n3, n2)) {
                        n2 = 0;
                        this.appendNewline();
                        this.indent(string);
                        if (this.commaAfterLineBreak) {
                            this.appendText(',');
                            if (this.addSpaceAfterLineBreakComma) {
                                this.appendText(' ');
                            }
                        }
                    } else {
                        this.appendText(' ');
                    }
                } else if (string2.equals("*") && !sQLToken3.isSeparator() && !sQLToken3.isIdentifier()) {
                    this.appendText(" *");
                } else if (this.isLobParameter(string2)) {
                    this.appendText(' ');
                    this.appendText(string2);
                    sQLToken2 = this.processLobParameter();
                } else {
                    if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                }
            }
            sQLToken3 = sQLToken2;
            sQLToken4 = null;
            sQLToken2 = this.lexer.getNextToken(true, true);
        }
        return null;
    }

    private SQLToken processBracketExpression() {
        SQLToken sQLToken = this.skipComments();
        if (QUERY_START.contains(sQLToken.getContents())) {
            return this.processSubSelect(sQLToken, 1, false);
        }
        return sQLToken;
    }

    private SQLToken processLobParameter() {
        SQLToken sQLToken = this.lexer.getNextToken(false, true);
        while (sQLToken != null) {
            String string = sQLToken.getText();
            if (string.equals("}")) {
                this.appendText(string);
                return sQLToken;
            }
            this.appendText(string);
            sQLToken = this.lexer.getNextToken(false, true);
        }
        return null;
    }

    private boolean needLineBreak(int n, int n2) {
        return n > -1 && n2 >= n;
    }

    private SQLToken processSubSelect(SQLToken sQLToken) {
        return this.processSubSelect(sQLToken, 1, true);
    }

    private SQLToken processSubSelect(SQLToken sQLToken, int n, boolean bl) {
        return this.processSubSelect(sQLToken, n, bl, this.maxSubselectLength);
    }

    private SQLToken processSubSelect(SQLToken sQLToken, int n, boolean bl, int n2) {
        return this.processSubSelect(sQLToken, n, bl, n2, this.newLineForSubSelects);
    }

    private SQLToken processSubSelect(SQLToken sQLToken, int n, boolean bl, int n2, boolean bl2) {
        SQLToken sQLToken2 = this.skipComments();
        int n3 = n;
        StringBuilder stringBuilder = new StringBuilder(250);
        if (bl && !"SELECT".equalsIgnoreCase(sQLToken2.getContents()) && sQLToken == null) {
            return this.processInList(sQLToken2);
        }
        if (sQLToken != null) {
            stringBuilder.append(this.getTokenText(sQLToken));
            stringBuilder.append(' ');
        }
        int n4 = 0;
        n4 = bl2 ? (this.indent == null ? 2 : this.indent.length() + 2) : this.getCurrentLineLength();
        while (sQLToken2 != null) {
            String string = sQLToken2.getContents();
            if (string.equals(")")) {
                if (--n3 == 0) {
                    this.appendSubSelect(stringBuilder, n4, n2, bl2);
                    return sQLToken2;
                }
            } else if (sQLToken2.isSeparator() && string.equals("(")) {
                ++n3;
            }
            stringBuilder.append(string);
            sQLToken2 = this.lexer.getNextToken(true, true);
        }
        this.appendText(stringBuilder);
        return sQLToken2;
    }

    private void appendSubSelect(StringBuilder stringBuilder, int n, int n2) {
        this.appendSubSelect(stringBuilder, n, n2, this.newLineForSubSelects);
    }

    private void appendSubSelect(StringBuilder stringBuilder, int n, int n2, boolean bl) {
        boolean bl2;
        WbSqlFormatter wbSqlFormatter = new WbSqlFormatter(stringBuilder.toString(), n, n2, this.dbId);
        wbSqlFormatter.setNewLineForSubselects(bl);
        wbSqlFormatter.setFunctionCase(this.functionCase);
        wbSqlFormatter.setIdentifierCase(this.identifierCase);
        wbSqlFormatter.setKeywordCase(this.keywordCase);
        wbSqlFormatter.setAddColumnNameComment(this.addColumnCommentForInsert);
        wbSqlFormatter.setAddSpaceAfterCommInList(this.addSpaceAfterComma);
        wbSqlFormatter.setAddSpaceAfterLineBreakComma(this.addSpaceAfterLineBreakComma);
        wbSqlFormatter.setIndentWhereCondition(this.indentWhereConditions);
        wbSqlFormatter.setCommaAfterLineBreak(this.commaAfterLineBreak);
        wbSqlFormatter.setJoinWrapping(this.joinWrapping);
        wbSqlFormatter.setColumnsPerInsert(this.colsPerInsert);
        wbSqlFormatter.setColumnsPerUpdate(this.colsPerUpdate);
        String string = wbSqlFormatter.getFormattedSql();
        boolean bl3 = bl2 = wbSqlFormatter.getRealLength() > n2;
        if (!bl2) {
            string = string.replaceAll(" *" + this.lineEnding + " *", " ").trim();
        }
        if (bl && bl2) {
            this.result.append(this.lineEnding);
            this.appendText(StringUtil.padRight(" ", n));
        }
        this.appendText(string);
        if (bl && bl2) {
            this.appendNewline();
        }
    }

    private SQLToken processDecode(int n) {
        String string = StringUtil.padRight(" ", n);
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("      ");
        SQLToken sQLToken = this.lexer.getNextToken(true, true);
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (sQLToken != null) {
            String string2;
            switch (string2 = sQLToken.getContents()) {
                case "'": {
                    bl = !bl;
                    break;
                }
                case ")": {
                    --n3;
                    break;
                }
                case "(": {
                    ++n3;
                    break;
                }
            }
            if (",".equals(string2) && !bl && n3 == 1) {
                this.appendText(string2);
                if (++n2 % 2 == 1) {
                    this.appendNewline();
                    this.indent(stringBuilder);
                }
            } else {
                if (")".equalsIgnoreCase(string2) && !bl && n3 == 0) {
                    this.appendNewline();
                    this.indent(string);
                    this.appendText(") ");
                    sQLToken = this.lexer.getNextToken(true, false);
                    return sQLToken;
                }
                if (string2.indexOf(10) == -1 && string2.indexOf(13) == -1) {
                    this.appendTokenText(sQLToken);
                }
            }
            sQLToken = this.lexer.getNextToken(true, true);
        }
        return null;
    }

    private SQLToken processCase(int n) {
        return this.processCase(n, true);
    }

    private SQLToken processCase(int n, boolean bl) {
        String string = StringUtil.padRight(" ", n);
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("  ");
        SQLToken sQLToken = null;
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        while (sQLToken2 != null) {
            String string2 = sQLToken2.getContents();
            if ("SELECT".equals(string2) && sQLToken != null && sQLToken.getContents().equals("(")) {
                if ((sQLToken2 = this.processSubSelect(sQLToken2)) == null) {
                    return null;
                }
                if (sQLToken2.getContents().equals(")")) {
                    this.appendText(")");
                }
            } else if ("WHEN".equals(string2) || "ELSE".equals(string2)) {
                this.appendNewline();
                this.indent(stringBuilder);
                this.appendTokenText(sQLToken2);
            } else if ("THEN".equals(string2)) {
                if (sQLToken != null && this.needsWhitespace(sQLToken, sQLToken2)) {
                    this.appendText(' ');
                }
                this.appendTokenText(sQLToken2);
            } else {
                if ("CASE".equals(string2)) {
                    this.appendNewline();
                    this.indent(string.length() + 4);
                    this.appendTokenText(sQLToken2);
                    sQLToken = sQLToken2;
                    sQLToken2 = this.processCase(string.length() + 4, false);
                    continue;
                }
                if ("END".equals(string2) || "END CASE".equals(string2)) {
                    this.appendNewline();
                    this.indent(string);
                    this.appendTokenText(sQLToken2);
                    this.appendText(' ');
                    sQLToken2 = this.skipComments();
                    if (sQLToken2 != null && (sQLToken2.isIdentifier() || sQLToken2.getContents().equals("AS"))) {
                        boolean bl2 = sQLToken2.getContents().equals("AS");
                        this.appendTokenText(sQLToken2);
                        sQLToken2 = this.skipComments();
                        if (bl2 && sQLToken2 != null) {
                            this.appendText(' ');
                            this.appendTokenText(sQLToken2);
                            sQLToken2 = this.lexer.getNextToken(true, false);
                        }
                    } else if (bl) {
                        this.appendNewline();
                    }
                    return sQLToken2;
                }
                if (sQLToken2.isComment()) {
                    this.appendComment(string2);
                } else {
                    if (sQLToken == null || this.needsWhitespace(sQLToken, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                }
            }
            sQLToken = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return null;
    }

    private SQLToken processWbCommand(String string) {
        int n = string.length() + 1;
        String string2 = StringUtil.padRight(" ", n);
        this.appendText(' ');
        CommandMapper commandMapper = new CommandMapper();
        SQLToken sQLToken = this.lexer.getNextToken(true, false);
        SqlCommand sqlCommand = commandMapper.getCommandToUse(string);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        while (sQLToken != null) {
            ArgumentParser argumentParser;
            String string3;
            String string4 = string3 = bl3 ? sQLToken.getText() : sQLToken.getContents();
            if (string3.equals("'") || string3.equals("\"")) {
                boolean bl4 = bl3 = !bl3;
            }
            if (bl2 && (argumentParser = sqlCommand.getArgumentParser()) != null) {
                List<String> list = argumentParser.getRegisteredArguments();
                for (String string5 : list) {
                    if (!string5.equalsIgnoreCase(string3)) continue;
                    string3 = string5;
                    break;
                }
            }
            if (string3.equals("-") && !bl3) {
                if (!bl) {
                    this.appendNewline();
                    this.indent(string2);
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (string3.equalsIgnoreCase("true")) {
                string3 = "true";
            }
            if (string3.equalsIgnoreCase("false")) {
                string3 = "false";
            }
            this.appendText(string3);
            sQLToken = this.lexer.getNextToken(true, bl3);
            bl = false;
        }
        return null;
    }

    private SQLToken processBracketList(int n, int n2, List<String> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        this.appendNewline();
        if (n2 == 1) {
            this.appendText('(');
            this.appendNewline();
            this.appendText(stringBuilder);
        } else {
            this.appendText(stringBuilder);
            stringBuilder.append(' ');
            this.appendText("(");
        }
        SQLToken sQLToken = this.lexer.getNextToken(true, false);
        SQLToken sQLToken2 = null;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (sQLToken != null) {
            String string = sQLToken.getContents();
            if (string.equals(")")) {
                if (n2 == 1) {
                    this.appendNewline();
                }
                this.appendText(")");
                SQLToken sQLToken3 = this.skipComments();
                if (sQLToken3 == null || !sQLToken3.getText().equals(",")) {
                    return sQLToken3;
                }
                this.appendText(sQLToken3.getText());
                this.appendNewline();
                n3 = 0;
                --n4;
            } else if (string.equals("(")) {
                if (n4 == 0) {
                    if (n2 > 1) {
                        this.appendText("  ");
                    }
                    this.appendText('(');
                    if (n2 == 1) {
                        this.appendNewline();
                        this.indent(stringBuilder);
                    }
                    ++n4;
                } else {
                    this.appendText("(");
                    sQLToken = this.processFunctionCall(sQLToken);
                    if (!sQLToken.getContents().equals(")")) {
                        continue;
                    }
                }
            } else if (string.equals(",")) {
                if (this.commaAfterLineBreak && (n3 == 0 || n3 >= n2)) {
                    this.appendNewline();
                    this.indent(stringBuilder);
                    n3 = 0;
                }
                this.appendText(",");
                if (!this.commaAfterLineBreak && ++n3 >= n2) {
                    this.appendNewline();
                    this.indent(stringBuilder);
                    n3 = 0;
                } else if (!this.commaAfterLineBreak || this.commaAfterLineBreak && this.addSpaceAfterLineBreakComma) {
                    this.appendText(' ');
                }
                ++n5;
            } else if (this.isLobParameter(string)) {
                this.appendText(string);
                sQLToken = this.processLobParameter();
            } else if (sQLToken.isComment()) {
                int n6 = this.getCurrentLineLength();
                this.appendComment(string, false);
                if (string.startsWith("--") && n6 > 0) {
                    this.indent(StringUtil.padRight("", n6));
                }
            } else if (!sQLToken.isWhiteSpace()) {
                if (this.needsWhitespace(sQLToken2, sQLToken)) {
                    this.appendText(' ');
                }
                if (!bl && n5 < list.size()) {
                    if (this.commaAfterLineBreak && n5 == 0) {
                        this.appendText(' ');
                        if (this.addSpaceAfterLineBreakComma) {
                            this.appendText(' ');
                        }
                    }
                    this.appendText("/* " + list.get(n5) + " */ ");
                }
                this.appendTokenText(sQLToken);
                if (bl) {
                    list.add(sQLToken.getText());
                }
                if (sQLToken.isComment()) {
                    this.appendText(' ');
                }
            }
            sQLToken2 = sQLToken;
            sQLToken = this.lexer.getNextToken(true, false);
        }
        return null;
    }

    private boolean isLobParameter(String string) {
        return string.equalsIgnoreCase("{$blobfile") || string.equalsIgnoreCase("{$clobfile") || string.equalsIgnoreCase("$clobfile") || string.equalsIgnoreCase("$blobfile");
    }

    private SQLToken processInList(SQLToken sQLToken) {
        if (sQLToken == null) {
            return null;
        }
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(25);
        arrayList.add(new StringBuilder(""));
        SQLToken sQLToken2 = sQLToken;
        int n = 0;
        int n2 = 0;
        while (sQLToken2 != null) {
            StringBuilder stringBuilder;
            String string = sQLToken2.getContents();
            if (sQLToken2.isSeparator() && string.equals(")")) {
                if (n == 0) {
                    this.appendCommaList(arrayList);
                    return this.lexer.getNextToken(true, true);
                }
                stringBuilder = (StringBuilder)arrayList.get(n2);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                    if (n2 < arrayList.size()) {
                        arrayList.set(n2, stringBuilder);
                    }
                } else {
                    stringBuilder.append(string);
                }
            } else if (sQLToken2.isSeparator() && string.equals("(")) {
                ++n;
            } else if (sQLToken2.isSeparator() && string.equals(",")) {
                if (n == 0) {
                    arrayList.add(new StringBuilder(""));
                    n2 = arrayList.size() - 1;
                }
            } else if (!sQLToken2.isWhiteSpace()) {
                stringBuilder = (StringBuilder)arrayList.get(n2);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string);
                    if (sQLToken2.isComment()) {
                        stringBuilder.append(' ');
                    }
                    arrayList.set(n2, stringBuilder);
                } else {
                    stringBuilder.append(string);
                    if (sQLToken2.isComment()) {
                        stringBuilder.append(' ');
                    }
                }
            }
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return null;
    }

    private void appendCommaList(List<StringBuilder> list) {
        int n = this.getCurrentLineLength();
        String string = StringUtil.padRight(" ", n);
        boolean bl = list.size() > 10;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            this.appendText(list.get(i));
            if (i < n2 - 1) {
                this.appendText(", ");
            }
            if (!bl) continue;
            this.appendNewline();
            this.indent(string);
        }
        this.appendText(")");
    }

    private boolean isStartOfLine() {
        int n = this.result.length();
        if (n == 0) {
            return true;
        }
        int n2 = this.result.lastIndexOf(this.lineEnding);
        if (n2 == n - this.lineEnding.length()) {
            return true;
        }
        String string = this.result.substring(n2 + this.lineEnding.length());
        return string.isEmpty() || StringUtil.isWhitespace(string);
    }

    private void formatSql() {
        SQLToken sQLToken;
        SQLToken sQLToken2 = sQLToken = this.lexer.getNextToken(true, false);
        CommandTester commandTester = new CommandTester();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        while (sQLToken != null) {
            String string = sQLToken.getContents().toUpperCase();
            if (sQLToken.isComment()) {
                String string2 = sQLToken.getContents();
                this.appendComment(string2);
            } else if (this.isKeyword(string) || commandTester.isWbCommand(string)) {
                if (sQLToken2.isComment() && !this.isStartOfLine()) {
                    this.appendNewline();
                }
                if (this.LINE_BREAK_BEFORE.contains(string) && !sQLToken2.getContents().equals("(")) {
                    if (!this.isStartOfLine()) {
                        this.appendNewline();
                    }
                    if ("SET".equals(string)) {
                        this.indent("   ");
                    }
                } else if (this.needsWhitespace(sQLToken2, sQLToken)) {
                    this.appendText(' ');
                }
                if (commandTester.isWbCommand(string)) {
                    this.appendText(commandTester.formatVerb(string));
                } else {
                    this.appendTokenText(sQLToken);
                }
                if (this.LINE_BREAK_AFTER.contains(string)) {
                    this.appendNewline();
                }
                if (string.equals("WITH") && bl) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processCTE(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("MERGE")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processMerge(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("SELECT")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processList(sQLToken, "SELECT".length() + 1, SELECT_TERMINAL)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("INSERT")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processInsert(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("SET")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processList(sQLToken, "SET".length() + 4, SET_TERMINAL)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("CREATE") || string.equals("CREATE OR REPLACE")) {
                    sQLToken2 = sQLToken;
                    sQLToken = this.processCreate();
                    if (sQLToken == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("GRANT") || string.equals("REVOKE")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processGrantRevoke(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("FROM")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processFrom(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("WINDOW")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processWindowDef(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("GROUP BY")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processList(sQLToken2, (string + " ").length(), this.GROUP_BY_TERMINAL)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("HAVING")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processHaving(sQLToken2)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equals("ORDER BY") && (sQLToken = this.processList(sQLToken2 = sQLToken, (string + " ").length(), this.ORDER_BY_TERMINAL)) == null) {
                    return;
                }
                if (string.equalsIgnoreCase("WHERE")) {
                    sQLToken2 = sQLToken;
                    if ((sQLToken = this.processWhere(sQLToken)) == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (string.equalsIgnoreCase("INTO")) {
                    sQLToken2 = sQLToken;
                    sQLToken = this.processIntoKeyword(arrayList);
                    bl = false;
                    continue;
                }
                if (string.equalsIgnoreCase("VALUES")) {
                    sQLToken = this.skipComments();
                    if (sQLToken != null && sQLToken.getContents().equals("(")) {
                        sQLToken = this.processBracketList(this.indentInsert ? 2 : 0, this.getColumnsPerInsert(), arrayList, false);
                    }
                    if (sQLToken == null) {
                        return;
                    }
                    bl = false;
                    continue;
                }
                if (commandTester.isWbCommand(string)) {
                    sQLToken = this.processWbCommand(string);
                }
            } else {
                if (this.LINE_BREAK_BEFORE.contains(string) && !this.isStartOfLine()) {
                    this.appendNewline();
                }
                if (string.equals("(") && this.isDbFunction(sQLToken2)) {
                    if (this.needsWhitespace(sQLToken2, sQLToken)) {
                        this.appendText(' ');
                    }
                    this.appendText('(');
                    sQLToken = this.processFunctionCall(sQLToken);
                } else if (string.equals(";")) {
                    this.appendText(string);
                    this.appendNewline();
                    this.appendNewline();
                } else {
                    if (this.needsWhitespace(sQLToken2, sQLToken)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken);
                }
            }
            sQLToken2 = sQLToken;
            sQLToken = this.lexer.getNextToken(true, false);
            bl = false;
        }
    }

    private SQLToken processInsert(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.skipComments();
        if (sQLToken2 == null) {
            return sQLToken2;
        }
        if (!sQLToken2.getContents().equals("INTO")) {
            return sQLToken2;
        }
        this.appendText(' ');
        this.appendTokenText(sQLToken2);
        ArrayList<String> arrayList = new ArrayList<String>();
        sQLToken2 = this.processIntoKeyword(arrayList);
        if (sQLToken2.getContents().equals("SELECT")) {
            return sQLToken2;
        }
        if (sQLToken2.getContents().equals("VALUES")) {
            this.appendNewline();
            this.appendTokenText(sQLToken2);
            sQLToken2 = this.skipComments();
            if (sQLToken2 != null && sQLToken2.getContents().equals("(")) {
                sQLToken2 = this.processBracketList(this.indentInsert ? 2 : 0, this.getColumnsPerInsert(), arrayList, false);
            }
            return sQLToken2;
        }
        this.appendNewline();
        return sQLToken2;
    }

    private SQLToken processMerge(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.skipComments();
        if (sQLToken2 == null) {
            return sQLToken2;
        }
        String string = sQLToken2.getContents();
        if (!string.equals("INTO")) {
            return sQLToken2;
        }
        this.appendText(' ');
        this.appendTokenText(sQLToken2);
        boolean bl = true;
        boolean bl2 = false;
        sQLToken2 = this.skipComments();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (sQLToken2 != null) {
            String string2 = sQLToken2.getContents();
            if (string2.equals("(") && bl) {
                this.appendNewline();
                this.appendText('(');
                this.appendNewline();
                this.indent("  ");
                sQLToken2 = this.processSubSelect(null, 1, false, 0);
                bl = false;
                if (sQLToken2 == null) {
                    return null;
                }
                if (")".equals(sQLToken2.getText())) {
                    this.appendNewline();
                }
            }
            if ("SET".equals(string2)) {
                this.appendTokenText(sQLToken2);
                Set<String> set = CollectionUtil.caseInsensitiveSet();
                set.addAll(SET_TERMINAL);
                set.add("WHEN");
                sQLToken2 = this.processList(sQLToken2, "SET".length() + 3, set);
                continue;
            }
            if (string2.equalsIgnoreCase("VALUES") || string2.equalsIgnoreCase("INSERT")) {
                boolean bl3;
                bl2 = false;
                this.indent = new StringBuilder("  ");
                this.appendNewline();
                this.appendTokenText(sQLToken2);
                sQLToken2 = this.skipComments();
                boolean bl4 = bl3 = string2.equalsIgnoreCase("INSERT") && this.addColumnCommentForInsert;
                if (sQLToken2 != null && sQLToken2.getContents().equals("(")) {
                    sQLToken2 = this.processBracketList(2, this.getColumnsPerInsert(), arrayList, bl3);
                }
                this.indent = null;
                if (sQLToken2 != null) continue;
                return null;
            }
            if ("WHEN".equals(string2) || "USING".equals(string2)) {
                this.appendNewline();
            }
            if ("THEN".equals(string2)) {
                bl2 = true;
            }
            if (this.needsWhitespace(sQLToken, sQLToken2)) {
                this.appendText(' ');
            }
            this.appendTokenText(sQLToken2);
            if (bl2 && "UPDATE".equals(string2)) {
                this.appendNewline();
                this.indent("  ");
                bl2 = false;
            }
            sQLToken = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return sQLToken2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLToken processCTE(SQLToken sQLToken) {
        if (sQLToken == null) {
            return null;
        }
        SQLToken sQLToken2 = null;
        this.appendText(' ');
        SQLToken sQLToken3 = this.skipComments();
        int n = 0;
        boolean bl = false;
        while (sQLToken3 != null) {
            String string = sQLToken3.getContents();
            if (string.equals("(")) {
                ++n;
                if (!bl) {
                    this.appendText(' ');
                }
                this.appendText('(');
                if (n == 1) {
                    if (bl) {
                        StringBuilder stringBuilder = this.indent;
                        this.indent = new StringBuilder(this.indent == null ? "" : this.indent).append("  ");
                        this.appendNewline();
                        sQLToken3 = this.processSubSelect(null, 1, false, this.maxSubselectLength, false);
                        this.indent = stringBuilder;
                        this.appendNewline();
                        if (sQLToken3 == null) {
                            return sQLToken3;
                        }
                        this.appendText(sQLToken3.getContents());
                        sQLToken3 = this.skipComments();
                        if (sQLToken3 == null) {
                            return sQLToken3;
                        }
                        if (!sQLToken3.getText().equals(",")) {
                            return sQLToken3;
                        }
                        this.appendText(sQLToken3.getContents());
                        this.appendNewline();
                        --n;
                        bl = false;
                    } else {
                        sQLToken3 = this.skipComments();
                        sQLToken3 = this.processInList(sQLToken3);
                        --n;
                        continue;
                    }
                }
            } else if (string.equals("AS")) {
                if (this.needsWhitespace(sQLToken2, sQLToken3)) {
                    this.appendText(' ');
                }
                this.appendText(string);
                this.appendNewline();
                bl = true;
            } else if (string.equals(")")) {
                --n;
                this.appendText(")");
            } else if (sQLToken3.isComment()) {
                this.appendComment(string);
            } else {
                if (this.needsWhitespace(sQLToken2, sQLToken3)) {
                    this.appendText(' ');
                }
                this.appendText(string);
            }
            sQLToken2 = sQLToken3;
            sQLToken3 = this.skipComments();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLToken processWhere(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        SQLToken sQLToken3 = sQLToken;
        int n = 0;
        boolean bl = false;
        while (true) {
            block27: {
                String string;
                block29: {
                    block28: {
                        block26: {
                            if (sQLToken2 == null) {
                                return null;
                            }
                            string = sQLToken2.getContents();
                            if (WHERE_TERMINAL.contains(string)) {
                                if ("WITH".equals(string)) {
                                    this.appendNewline();
                                }
                                return sQLToken2;
                            }
                            if (string.equals(";")) {
                                return sQLToken2;
                            }
                            if (string.equals("BETWEEN")) {
                                bl = true;
                            }
                            if (!string.equals(")")) break block26;
                            --n;
                            this.appendText(")");
                            break block27;
                        }
                        if (!sQLToken2.isComment()) break block28;
                        this.appendComment(string);
                        break block27;
                    }
                    if (!string.equals("(")) break block29;
                    if (this.needsWhitespace(sQLToken3, sQLToken2, false, true)) {
                        this.appendText(' ');
                    }
                    this.appendText(sQLToken2.getContents());
                    SQLToken sQLToken4 = this.skipComments();
                    if (sQLToken4 == null) {
                        return null;
                    }
                    if (QUERY_START.contains(sQLToken4.getContents())) {
                        sQLToken2 = this.processSubSelect(sQLToken4);
                        if (sQLToken2 == null) {
                            return null;
                        }
                        if (sQLToken2.getContents().equals(")")) {
                            this.appendText(")");
                        }
                        break block27;
                    } else {
                        ++n;
                        sQLToken3 = sQLToken2;
                        sQLToken2 = sQLToken4;
                        continue;
                    }
                }
                if (n == 0 && (string.equalsIgnoreCase("AND") || string.equalsIgnoreCase("OR"))) {
                    if (bl) {
                        this.appendText(' ');
                    } else if (!this.isStartOfLine()) {
                        this.appendNewline();
                    }
                    if (this.indentWhereConditions) {
                        if (string.equals("OR")) {
                            this.appendText("   ");
                        }
                        if (string.equals("AND")) {
                            this.appendText("  ");
                        }
                    }
                    this.appendTokenText(sQLToken2);
                    if (!bl && !this.indentWhereConditions) {
                        this.appendText("  ");
                        if (string.equals("OR")) {
                            this.appendText(' ');
                        }
                    }
                    bl = false;
                } else if (string.equals(",")) {
                    this.appendText(',');
                    if (this.addSpaceAfterComma) {
                        this.appendText(' ');
                    }
                } else {
                    if (this.needsWhitespace(sQLToken3, sQLToken2)) {
                        this.appendText(' ');
                    }
                    this.appendTokenText(sQLToken2);
                }
            }
            sQLToken3 = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
    }

    private SQLToken skipComments() {
        SQLToken sQLToken = this.lexer.getNextToken(true, false);
        if (sQLToken == null) {
            return null;
        }
        if (!sQLToken.isComment()) {
            return sQLToken;
        }
        while (sQLToken != null) {
            if (!sQLToken.isComment()) {
                return sQLToken;
            }
            this.appendComment(sQLToken.getContents());
            sQLToken = this.lexer.getNextToken(true, false);
        }
        return null;
    }

    private SQLToken processIntoKeyword(List<String> list) {
        SQLToken sQLToken = this.skipComments();
        if (sQLToken.isIdentifier()) {
            this.appendText(' ');
            this.appendTokenText(sQLToken);
            sQLToken = this.lexer.getNextToken(false, false);
            if (sQLToken.getContents().equalsIgnoreCase("VALUES")) {
                return sQLToken;
            }
            if (sQLToken.isSeparator() && sQLToken.getContents().equals("(")) {
                list.clear();
                return this.processBracketList(this.indentInsert ? 2 : 0, this.getColumnsPerInsert(), list, this.addColumnCommentForInsert);
            }
        }
        return sQLToken;
    }

    private SQLToken processFunctionCall(SQLToken sQLToken) {
        int n = 1;
        SQLToken sQLToken2 = this.lexer.getNextToken(true, false);
        if (sQLToken2 != null && QUERY_START.contains(sQLToken2.getContents())) {
            if ((sQLToken2 = this.processSubSelect(sQLToken2)) == null) {
                return null;
            }
            if (sQLToken2.getContents().equals(")")) {
                this.appendText(')');
                sQLToken2 = this.lexer.getNextToken(true, false);
            }
            return sQLToken2;
        }
        SQLToken sQLToken3 = sQLToken;
        while (sQLToken2 != null) {
            String string = sQLToken2.getContents();
            if (string.equals(")")) {
                --n;
            }
            if (string.equals("(")) {
                ++n;
            }
            if (this.needsWhitespace(sQLToken3, sQLToken2) || this.addSpaceAfterComma && ",".equals(sQLToken3.getContents())) {
                this.appendText(' ');
            }
            this.appendTokenText(sQLToken2);
            if (n == 0) {
                return sQLToken2;
            }
            sQLToken3 = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(true, false);
        }
        return null;
    }

    private SQLToken processGrantRevoke(SQLToken sQLToken) {
        SQLToken sQLToken2 = sQLToken;
        SQLToken sQLToken3 = this.lexer.getNextToken(true, false);
        boolean bl = false;
        while (sQLToken3 != null) {
            String string = sQLToken3.getContents();
            if (string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TO") || string.equalsIgnoreCase("FROM")) {
                this.appendNewline();
                this.indent(2);
                this.appendTokenText(sQLToken3);
                bl = true;
            } else {
                if (this.needsWhitespace(sQLToken2, sQLToken3)) {
                    this.appendText(' ');
                }
                if (bl) {
                    this.appendText(sQLToken3.getText());
                } else {
                    this.appendText(string);
                }
                bl = false;
            }
            sQLToken3 = this.lexer.getNextToken(true, false);
        }
        return sQLToken3;
    }

    private SQLToken processCreate() {
        SQLToken sQLToken = this.skipComments();
        String string = sQLToken.getContents();
        while (this.createTableTypes.contains(string) || this.createViewTypes.contains(string)) {
            this.appendText(' ');
            this.appendTokenText(sQLToken);
            sQLToken = this.skipComments();
            if (sQLToken == null) continue;
            string = sQLToken.getContents();
        }
        if (string.equals("TABLE")) {
            this.appendText(' ');
            this.appendTokenText(sQLToken);
            this.appendText(' ');
            sQLToken = this.processCreateTable();
            return sQLToken;
        }
        if (string.equals("VIEW") || string.equals("SNAPSHOT")) {
            this.appendText(' ');
            this.appendText(string);
            this.appendText(' ');
            return this.processCreateView(sQLToken);
        }
        if (INDEX_OPTIONS.contains(string)) {
            SQLToken sQLToken2 = sQLToken;
            String string2 = string;
            this.appendText(' ');
            while (INDEX_OPTIONS.contains(string2)) {
                this.appendTokenText(sQLToken2);
                this.appendText(' ');
                sQLToken2 = this.skipComments();
                if (sQLToken2 == null) {
                    return null;
                }
                string2 = sQLToken2.getContents();
            }
            if ("INDEX".equals(string2)) {
                this.appendTokenText(sQLToken2);
                this.appendText(' ');
                return this.processCreateIndex();
            }
        } else {
            if (string.equals("INDEX")) {
                this.appendText(' ');
                this.appendTokenText(sQLToken);
                this.appendText(' ');
                return this.processCreateIndex();
            }
            if (string.equals("OR")) {
                this.appendText(' ');
                this.appendText(string);
                sQLToken = this.lexer.getNextToken(true, false);
                if (sQLToken == null) {
                    return sQLToken;
                }
                string = sQLToken.getContents();
                if (string.equals("REPLACE")) {
                    this.appendText(' ');
                    this.appendText(string);
                    this.appendText(' ');
                    return this.processCreateView(sQLToken);
                }
            }
        }
        return sQLToken;
    }

    private SQLToken processTableDefinition() {
        Object object;
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        SQLToken sQLToken = this.lexer.getNextToken(true, false);
        StringBuilder stringBuilder = new StringBuilder(50);
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        SQLToken sQLToken2 = null;
        while (sQLToken != null) {
            object = sQLToken.getContents();
            if (sQLToken2 != null && sQLToken2.getText().equals(",") && this.CREATE_TABLE_TERMINAL.contains(object)) break;
            if ("(".equals(object)) {
                ++n3;
            } else if (")".equals(object)) {
                --n3;
            } else if (!sQLToken.isComment()) {
                ++n2;
            }
            boolean bl3 = bl2 = n3 == 1 && n2 == 2;
            if (n3 < 0) {
                arrayList.add(stringBuilder);
                break;
            }
            if (bl || this.needsWhitespace(sQLToken2, sQLToken, true) && !bl2) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.getTokenText(sQLToken));
            if (bl) {
                if (((String)object).length() > n) {
                    n = ((String)object).length();
                }
                bl = false;
            }
            if (((String)object).equals(",") && n3 == 0) {
                arrayList.add(stringBuilder);
                stringBuilder = new StringBuilder(50);
                bl = true;
                n2 = 0;
            }
            sQLToken2 = sQLToken;
            sQLToken = this.lexer.getNextToken(true, false);
        }
        for (StringBuilder stringBuilder2 : arrayList) {
            SQLLexer sQLLexer = SQLLexerFactory.createLexerForDbId(this.dbId, stringBuilder2.toString());
            SQLToken sQLToken3 = sQLLexer.getNextToken(false, false);
            if (sQLToken3 == null) continue;
            String string = sQLToken3.getText();
            String string2 = stringBuilder2.substring(sQLToken3.getCharEnd()).trim();
            this.appendText("  ");
            this.appendText(string);
            if (this.isKeyword(string)) {
                this.appendText(" ");
            } else {
                for (int i = string.length(); i < n; ++i) {
                    this.appendText(' ');
                }
                this.appendText("   ");
            }
            this.appendText(string2);
            this.appendNewline();
        }
        if (sQLToken == null) {
            return sQLToken;
        }
        if (!sQLToken.getContents().equals(")")) {
            this.appendText("  ");
            n3 = 0;
            sQLToken2 = null;
            while (sQLToken != null) {
                object = sQLToken.getContents();
                if ("(".equals(object)) {
                    ++n3;
                }
                if (")".equals(object)) {
                    if (n3 == 0) break;
                    --n3;
                }
                if (sQLToken2 != null && this.needsWhitespace(sQLToken2, sQLToken, true)) {
                    this.appendText(' ');
                }
                this.appendTokenText(sQLToken);
                if (",".equals(object) && n3 == 0) {
                    this.appendNewline();
                    this.appendText("  ");
                }
                sQLToken2 = sQLToken;
                sQLToken = this.lexer.getNextToken(true, false);
            }
            this.appendNewline();
        }
        this.appendText(')');
        this.appendNewline();
        sQLToken = this.lexer.getNextToken(false, false);
        return sQLToken;
    }

    private boolean isQuotedIdentifier(String string) {
        return SqlUtil.isQuotedIdentifier(string);
    }

    private boolean isEndOfIdentifier(SQLToken sQLToken, Set<String> set) {
        if (sQLToken == null) {
            return true;
        }
        boolean bl = set != null ? set.contains(sQLToken.getContents()) : sQLToken.isReservedWord() || sQLToken.isOperator() || sQLToken.isSeparator() || sQLToken.isLiteral() || sQLToken.isNumberLiteral();
        return bl;
    }

    private SQLToken appendMultipartIdentifier(SQLToken sQLToken, Set<String> set) {
        if (sQLToken == null) {
            return null;
        }
        String string = sQLToken.getContents();
        this.appendIdentifier(string);
        sQLToken = this.collapseWhiteSpace();
        if (sQLToken == null) {
            return null;
        }
        while (!this.isEndOfIdentifier(sQLToken, set)) {
            if (sQLToken.isIdentifier()) {
                this.appendIdentifier(sQLToken.getContents());
            } else {
                this.appendText(sQLToken.getContents());
            }
            sQLToken = this.collapseWhiteSpace();
        }
        return sQLToken;
    }

    private SQLToken collapseWhiteSpace() {
        SQLToken sQLToken = this.lexer.getNextToken(true, true);
        if (sQLToken == null) {
            return sQLToken;
        }
        boolean bl = false;
        while (sQLToken.isWhiteSpace()) {
            bl = true;
            sQLToken = this.lexer.getNextToken(false, true);
        }
        if (bl) {
            this.appendText(' ');
        }
        return sQLToken;
    }

    private SQLToken processCreateTable() {
        SQLToken sQLToken = this.lexer.getNextToken(false, false);
        if (sQLToken == null) {
            return sQLToken;
        }
        String string = sQLToken.getContents();
        if (string.equalsIgnoreCase("IF NOT EXISTS")) {
            this.appendText(string);
            this.appendText(" ");
            sQLToken = this.lexer.getNextToken(false, false);
            if (sQLToken == null) {
                return null;
            }
            string = sQLToken.getContents();
        }
        if ((sQLToken = this.appendMultipartIdentifier(sQLToken, CollectionUtil.caseInsensitiveSet("(", "AS"))) == null) {
            return sQLToken;
        }
        if (sQLToken.getContents().equals("AS")) {
            this.appendNewline();
            this.appendText("AS");
            this.appendNewline();
            sQLToken = this.skipComments();
            if (sQLToken == null) {
                return sQLToken;
            }
            if (sQLToken.getContents().equals("SELECT")) {
                CharSequence charSequence = this.sql.subSequence(sQLToken.getCharBegin(), this.sql.length());
                WbSqlFormatter wbSqlFormatter = new WbSqlFormatter(charSequence, this.dbId);
                String string2 = wbSqlFormatter.getFormattedSql();
                this.appendText(string2);
                return null;
            }
        } else if (sQLToken.getContents().equals("(")) {
            this.appendNewline();
            this.appendText('(');
            this.appendNewline();
            sQLToken = this.processTableDefinition();
        }
        return sQLToken;
    }

    private SQLToken processCreateView(SQLToken sQLToken) {
        SQLToken sQLToken2 = this.lexer.getNextToken(false, false);
        SQLToken sQLToken3 = sQLToken;
        int n = 0;
        while (sQLToken2 != null) {
            if (sQLToken2.getContents().equals("(")) {
                if (n == 0) {
                    this.appendNewline();
                    this.appendText('(');
                    sQLToken2 = this.processCommaList(1, 2);
                    if (sQLToken2 == null) {
                        return sQLToken2;
                    }
                } else {
                    ++n;
                }
            }
            if ("SELECT".equals(sQLToken2.getContents())) {
                return sQLToken2;
            }
            if ("AS".equals(sQLToken2.getContents())) {
                this.appendNewline();
                this.appendTokenText(sQLToken2);
                this.appendNewline();
            } else {
                this.appendTokenText(sQLToken2);
                if (this.needsWhitespace(sQLToken3, sQLToken2, true)) {
                    this.appendText(' ');
                }
            }
            sQLToken3 = sQLToken2;
            sQLToken2 = this.lexer.getNextToken(false, false);
        }
        return sQLToken2;
    }

    private SQLToken processCreateIndex() {
        SQLToken sQLToken = this.skipComments();
        if (sQLToken == null) {
            return null;
        }
        SQLToken sQLToken2 = sQLToken;
        if (sQLToken.getContents().equalsIgnoreCase("CONCURRENTLY")) {
            this.appendText(' ');
            this.appendTokenText(sQLToken);
            sQLToken = this.skipComments();
            if (sQLToken == null) {
                return null;
            }
        }
        if ((sQLToken = this.appendMultipartIdentifier(sQLToken, null)) == null) {
            return sQLToken;
        }
        this.appendNewline();
        this.indent("  ");
        this.appendTokenText(sQLToken);
        this.appendText(' ');
        sQLToken = this.skipComments();
        sQLToken = this.appendMultipartIdentifier(sQLToken, null);
        while (sQLToken != null) {
            if (sQLToken.getContents().equals("(")) {
                this.appendText('(');
                sQLToken = this.processCommaList(10, 4);
                this.appendTokenText(sQLToken);
            } else {
                if (this.needsWhitespace(sQLToken2, sQLToken)) {
                    this.appendText(' ');
                }
                this.appendTokenText(sQLToken);
            }
            sQLToken = this.lexer.getNextToken(true, false);
        }
        return sQLToken;
    }

    private SQLToken processCommaList(int n, int n2) {
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        StringBuilder stringBuilder = new StringBuilder(30);
        int n3 = 0;
        SQLToken sQLToken = this.lexer.getNextToken(true, true);
        while (sQLToken != null) {
            String string = sQLToken.getText();
            if ("(".equals(string)) {
                ++n3;
            } else if (")".equals(string)) {
                if (n3 == 0) {
                    arrayList.add(stringBuilder);
                    break;
                }
                --n3;
            }
            if (",".equals(string) && n3 == 0) {
                arrayList.add(stringBuilder);
                stringBuilder = new StringBuilder(30);
            } else if (sQLToken.isWhiteSpace() && (string.indexOf(10) > -1 || string.indexOf(13) > -1)) {
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(this.getTokenText(sQLToken));
            }
            sQLToken = this.lexer.getNextToken(true, true);
        }
        this.outputCommaElements(arrayList, n, n2);
        return sQLToken;
    }

    private void outputCommaElements(List<StringBuilder> list, int n, int n2) {
        String string = StringUtil.padRight(" ", n2);
        int n3 = list.size();
        if (n3 > n) {
            this.appendNewline();
        }
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            String string2 = list.get(i).toString().trim();
            boolean bl2 = i == 0;
            boolean bl3 = bl = i == n3 - 1;
            if (n3 > n) {
                this.appendCommaElementWithNewline(string2, string, bl2, bl);
                continue;
            }
            this.appendText(string2);
            if (bl) continue;
            this.appendText(", ");
        }
        if (n3 > n) {
            this.appendNewline();
        }
    }

    private void appendCommaElementWithNewline(String string, String string2, boolean bl, boolean bl2) {
        if (this.commaAfterLineBreak) {
            if (bl) {
                this.indent(string2);
            } else {
                this.appendNewline();
                this.indent(string2);
                this.appendText(',');
                if (this.addSpaceAfterLineBreakComma) {
                    this.appendText(' ');
                }
            }
            this.appendText(string);
        } else {
            this.appendText(string2);
            this.appendText(string);
            if (!bl2) {
                this.appendText(',');
                this.appendNewline();
            }
        }
    }
}

