/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.lexer;

import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class SQLToken {
    public static final int UNDEFINED_STATE = -1;
    public static final int INITIAL_STATE = 0;
    public static final int RESERVED_WORD = 256;
    public static final int IDENTIFIER = 512;
    public static final int LITERAL_STRING = 768;
    public static final int LITERAL_BIT_STRING = 784;
    public static final int LITERAL_INTEGER = 800;
    public static final int LITERAL_FLOAT = 816;
    public static final int SEPARATOR = 1024;
    public static final int OPERATOR = 1280;
    public static final int WB_VAR = 1536;
    public static final int COMMENT_TRADITIONAL = 3328;
    public static final int COMMENT_END_OF_LINE = 3344;
    public static final int WHITE_SPACE = 3584;
    public static final int ERROR = 3840;
    public static final int ERROR_UNCLOSED_COMMENT = 3842;
    public static final int ERROR_UNCLOSED_STRING = 3843;
    public static final int ERROR_UNCLOSED_BIT_STRING = 3844;
    public static final int ERROR_BAD_BIT_STRING = 3845;
    private final int ID;
    private String contents;
    private int charBegin;
    private int charEnd;
    private int state;
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");

    public SQLToken(int n, String string, int n2, int n3) {
        this(n, string, n2, n3, -1);
    }

    public SQLToken(int n, String string, int n2, int n3, int n4) {
        if (string.length() == 0 && n != 3584) {
            LogMgr.logDebug(new CallerInfo(){}, "SQLToken with ID=" + Integer.toHexString(n) + " but with length zero ");
            this.ID = 3584;
        } else {
            this.ID = n;
        }
        this.contents = string;
        this.charBegin = n2;
        this.charEnd = n3;
        this.state = n4;
    }

    public int getState() {
        return this.state;
    }

    public int getID() {
        return this.ID;
    }

    public String getText() {
        return this.contents;
    }

    public String getContents() {
        if (this.isReservedWord()) {
            return WHITESPACE.matcher(this.contents).replaceAll(" ").toUpperCase();
        }
        return this.contents;
    }

    public int getCharBegin() {
        return this.charBegin;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isReservedWord() {
        return this.ID >> 8 == 1;
    }

    public boolean isIntegerLiteral() {
        return this.ID == 800;
    }

    public boolean isNumberLiteral() {
        return this.ID == 800 || this.ID == 816;
    }

    public boolean isIdentifier() {
        return this.ID >> 8 == 2;
    }

    public boolean isLiteral() {
        return this.ID >> 8 == 3;
    }

    public boolean isSeparator() {
        return this.ID >> 8 == 4;
    }

    public boolean isOperator() {
        return this.ID >> 8 == 5;
    }

    public boolean isWbVar() {
        return this.ID >> 8 == 6;
    }

    public boolean isComment() {
        return this.ID >> 8 == 13;
    }

    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    public boolean isError() {
        return this.ID >> 8 == 15;
    }

    public String getDescription() {
        if (this.isReservedWord()) {
            return "reservedWord";
        }
        if (this.isWbVar()) {
            return "variable";
        }
        if (this.isIdentifier()) {
            return "identifier";
        }
        if (this.isLiteral()) {
            return "literal";
        }
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isOperator()) {
            return "operator";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    public boolean isUnclosedString() {
        return this.ID == 3843;
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

