/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.macros;

import workbench.resource.GuiSettings;
import workbench.resource.StoreableKeyStroke;
import workbench.sql.macros.Sortable;
import workbench.util.HtmlUtil;
import workbench.util.StringUtil;

public class MacroDefinition
implements Sortable {
    private String name;
    private String text;
    private String tooltip;
    private int sortOrder;
    private boolean modified;
    private StoreableKeyStroke shortcut;
    private boolean showInMenu = true;
    private boolean showInPopup = true;
    private boolean expandWhileTyping;
    private boolean appendResult;
    private boolean shortcutChanged;

    public MacroDefinition() {
    }

    public MacroDefinition(String string, String string2) {
        this.name = string;
        this.text = string2;
    }

    public String getDisplayTooltip() {
        if (this.tooltip == null && GuiSettings.useMacroSourceForMenuTooltip()) {
            int n = GuiSettings.getMacroSourceTooltipLength();
            return "<html><pre>" + HtmlUtil.escapeXML(StringUtil.getMaxSubstring(this.getText(), n), false) + "</pre></html>";
        }
        return this.tooltip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.modified = this.modified || StringUtil.stringsAreNotEqual(this.tooltip, string);
        this.tooltip = StringUtil.trimToNull(string);
    }

    public void setExpandWhileTyping(boolean bl) {
        this.modified = this.modified || this.expandWhileTyping != bl;
        this.expandWhileTyping = bl;
    }

    public boolean getExpandWhileTyping() {
        return this.expandWhileTyping;
    }

    public boolean isVisibleInMenu() {
        return this.showInMenu;
    }

    public void setVisibleInMenu(boolean bl) {
        this.modified = this.modified || this.showInMenu != bl;
        this.showInMenu = bl;
    }

    public boolean isVisibleInPopup() {
        return this.showInPopup;
    }

    public void setVisibleInPopup(boolean bl) {
        this.modified = this.modified || this.showInPopup != bl;
        this.showInPopup = bl;
    }

    public boolean isAppendResult() {
        return this.appendResult;
    }

    public void setAppendResult(boolean bl) {
        this.modified = this.modified || this.appendResult != bl;
        this.appendResult = bl;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(int n) {
        this.modified = this.modified || n != this.sortOrder;
        this.sortOrder = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.modified = this.modified || StringUtil.stringsAreNotEqual(this.name, string);
        this.name = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.modified = this.modified || StringUtil.stringsAreNotEqual(this.text, string);
        this.text = string;
    }

    public void copyTo(MacroDefinition macroDefinition) {
        macroDefinition.setName(this.name);
        macroDefinition.setTooltip(this.tooltip);
        macroDefinition.setText(this.text);
        macroDefinition.setSortOrder(this.sortOrder);
        macroDefinition.setVisibleInMenu(this.showInMenu);
        macroDefinition.setVisibleInPopup(this.showInPopup);
        macroDefinition.setShortcut(this.shortcut);
        macroDefinition.setExpandWhileTyping(this.expandWhileTyping);
        macroDefinition.setAppendResult(this.appendResult);
    }

    public MacroDefinition createCopy() {
        MacroDefinition macroDefinition = new MacroDefinition();
        this.copyTo(macroDefinition);
        macroDefinition.modified = false;
        return macroDefinition;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MacroDefinition macroDefinition = (MacroDefinition)object;
        return !(this.name == null ? macroDefinition.name != null : !this.name.equalsIgnoreCase(macroDefinition.name));
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.name != null ? this.name.toLowerCase().hashCode() : 0);
        return n;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void resetModified() {
        this.modified = false;
        this.shortcutChanged = true;
    }

    public boolean isShortcutChanged() {
        return this.shortcutChanged;
    }

    public String toString() {
        return this.name;
    }

    public StoreableKeyStroke getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(StoreableKeyStroke storeableKeyStroke) {
        if (storeableKeyStroke != null && this.shortcut == null) {
            this.modified = true;
            this.shortcutChanged = true;
        } else if (storeableKeyStroke == null && this.shortcut != null) {
            this.modified = true;
            this.shortcutChanged = true;
        } else if (storeableKeyStroke != null && this.shortcut != null) {
            this.modified = !storeableKeyStroke.equals(this.shortcut);
            this.shortcutChanged = true;
        }
        this.shortcut = storeableKeyStroke;
    }
}

