/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.preparedstatement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.ValueConverter;

public class ParameterDefinition {
    private final ValueConverter converter = new ValueConverter();
    private int dataType;
    private int parameterIndex;
    private String parameterName;
    private int parameterMode = 0;
    private boolean valueValid = false;
    private Object value = null;

    public ParameterDefinition(int n, int n2) {
        this.parameterIndex = n;
        this.dataType = n2;
    }

    public int getIndex() {
        return this.parameterIndex;
    }

    public int getType() {
        return this.dataType;
    }

    public boolean isValueValid(String string) {
        try {
            this.converter.convertValue(string, this.dataType);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setParameterName(String string) {
        this.parameterName = string;
    }

    public String getParameterName() {
        if (this.parameterName == null) {
            return NumberStringCache.getNumberString(this.parameterIndex);
        }
        return this.parameterName;
    }

    public boolean setValue(String string) {
        try {
            this.value = this.converter.convertValue(string, this.dataType);
            this.valueValid = true;
        }
        catch (Exception exception) {
            this.valueValid = false;
            LogMgr.logError(new CallerInfo(){}, "Error applying value " + string + " for type " + SqlUtil.getTypeName(this.dataType), exception);
        }
        return this.valueValid;
    }

    public Object getValue() {
        return this.value;
    }

    public void setStatementValue(PreparedStatement preparedStatement) throws IllegalStateException, SQLException {
        if (!this.valueValid) {
            throw new IllegalStateException("No valid value defined for parameter #" + this.parameterIndex);
        }
        preparedStatement.setObject(this.parameterIndex, this.value);
    }

    public static void sortByIndex(List<ParameterDefinition> list) {
        Comparator comparator = (parameterDefinition, parameterDefinition2) -> parameterDefinition.parameterIndex - parameterDefinition2.parameterIndex;
        Collections.sort(list, comparator);
    }

    public String toString() {
        return this.parameterName + "=" + this.value + " (" + this.parameterIndex + ")";
    }

    public String getModeString() {
        switch (this.parameterMode) {
            case 4: {
                return "OUT";
            }
            case 1: {
                return "IN";
            }
            case 2: {
                return "INOUT";
            }
        }
        return "N/A (" + this.parameterMode + ")";
    }

    public boolean isOutParameter() {
        return this.parameterMode == 4 || this.parameterMode == 2;
    }

    public int getParameterMode() {
        return this.parameterMode;
    }

    public void setParameterMode(int n) {
        if (n != 4 && n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("Incorrect parameter mode specified!");
        }
        this.parameterMode = n;
    }
}

