/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.storage.DataStore;

public class MySQLShow
extends SqlCommand {
    public static final String VERB = "SHOW";

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = super.execute(string);
        if (!this.isInnoDBStatus(string)) {
            return statementRunnerResult;
        }
        List<DataStore> list = statementRunnerResult.getDataStores();
        if (list != null && list.size() == 1) {
            DataStore dataStore = list.get(0);
            StringBuilder stringBuilder = new StringBuilder(500);
            int n = dataStore.getColumnIndex("Status");
            if (n > -1) {
                for (int i = 0; i < dataStore.getRowCount(); ++i) {
                    String string2 = dataStore.getValueAsString(i, n);
                    stringBuilder.append(string2);
                    stringBuilder.append('\n');
                }
            }
            statementRunnerResult.clearResultData();
            statementRunnerResult.addMessage(stringBuilder);
        }
        return statementRunnerResult;
    }

    boolean isInnoDBStatus(String string) {
        String[] stringArray = new String[]{"show", "engine", "innodb", "status"};
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(ParserType.MySQL, (CharSequence)string);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        int n = 0;
        while (sQLToken != null) {
            if (!sQLToken.getText().equalsIgnoreCase(stringArray[n])) {
                return false;
            }
            ++n;
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        return n == 4;
    }

    @Override
    public String getVerb() {
        return VERB;
    }
}

