/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;

public class ObjectLister {
    private String schemaUsed = null;
    private String catalogUsed = null;

    public DataStore getSelectableObjects(ArgumentParser argumentParser, String string, WbConnection wbConnection) throws SQLException {
        String[] stringArray = wbConnection.getMetadata().getSelectableTypes();
        return this.getObjects(argumentParser, string, wbConnection, stringArray);
    }

    public DataStore getObjects(ArgumentParser argumentParser, String string, WbConnection wbConnection) throws SQLException {
        String[] stringArray = wbConnection.getMetadata().getSelectableTypes();
        return this.getObjects(argumentParser, string, wbConnection, stringArray);
    }

    private DataStore getObjects(ArgumentParser argumentParser, String string, WbConnection wbConnection, String[] stringArray) throws SQLException {
        Collection<String> collection;
        List<String> list;
        String string2 = string;
        String string3 = null;
        String string4 = null;
        argumentParser.parse(string);
        if (argumentParser.hasArguments()) {
            string2 = argumentParser.getValue("objects");
            list = argumentParser.getListValue("types");
            if (list.size() == 1 && (list.get(0).equals("*") || list.get(0).equals("%"))) {
                collection = wbConnection.getMetadata().getObjectTypes();
                stringArray = StringUtil.toArray(collection, true, true);
            } else if (list.size() > 0) {
                stringArray = StringUtil.toArray(list, true, true);
            }
            string3 = argumentParser.getValue("schema");
            string4 = argumentParser.getValue("catalog");
        } else {
            string2 = string;
            if (stringArray == null) {
                stringArray = wbConnection.getMetadata().getSelectableTypes();
            }
        }
        if (StringUtil.isBlank(string3)) {
            string3 = wbConnection.getMetadata().getCurrentSchema();
        }
        if (StringUtil.isBlank(string4)) {
            string4 = wbConnection.getMetadata().getCurrentCatalog();
        }
        list = null;
        if (StringUtil.isBlank(string2)) {
            string2 = "%";
        }
        collection = StringUtil.stringToList(string2, ",", true, true, false, true);
        this.schemaUsed = string3;
        this.catalogUsed = string4;
        for (String string5 : collection) {
            TableIdentifier tableIdentifier = new TableIdentifier(wbConnection.getMetadata().adjustObjectnameCase(string5), wbConnection);
            String string6 = tableIdentifier.getSchema();
            if (StringUtil.isBlank(string6)) {
                string6 = string3;
            }
            string6 = wbConnection.getMetadata().adjustSchemaNameCase(string6);
            String string7 = tableIdentifier.getCatalog();
            if (StringUtil.isBlank(string7)) {
                string7 = string4;
            }
            string7 = wbConnection.getMetadata().adjustObjectnameCase(string7);
            if (this.schemaUsed != null && StringUtil.stringsAreNotEqual(this.schemaUsed, string6)) {
                this.schemaUsed = null;
            }
            if (this.catalogUsed != null && StringUtil.stringsAreNotEqual(this.catalogUsed, string7)) {
                this.catalogUsed = null;
            }
            String string8 = tableIdentifier.getTableName();
            DataStore dataStore = wbConnection.getMetadata().getObjects(string7, string6, string8, stringArray);
            if (list == null) {
                list = dataStore;
                continue;
            }
            ((DataStore)((Object)list)).copyFrom(dataStore);
        }
        return list;
    }

    public String getSchemaUsed() {
        return this.schemaUsed;
    }

    public String getCatalogUsed() {
        return this.catalogUsed;
    }
}

