/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.DbObjectFinder;
import workbench.db.DropType;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.compare.TableDeleteSync;
import workbench.db.compare.TableDiffStatus;
import workbench.db.datacopy.DataCopier;
import workbench.db.importer.DataReceiver;
import workbench.db.importer.TableDependencySorter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.CopyTask;
import workbench.sql.wbcommands.WbCopy;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.ExceptionUtil;
import workbench.util.MessageBuffer;
import workbench.util.StringUtil;

class SchemaCopy
implements CopyTask {
    private WbConnection sourceConnection;
    private WbConnection targetConnection;
    private MessageBuffer messages = new MessageBuffer();
    private DataCopier copier;
    private boolean success;
    private String createTableType;
    private DropType dropTable;
    private boolean ignoreDropError;
    private boolean checkDependencies;
    private boolean skipTargetCheck;
    private Boolean adjustNames = null;
    private List<TableIdentifier> sourceTables;
    private Map<TableIdentifier, TableIdentifier> targetToSourceMap;
    private TableDependencySorter sorter;
    private RowActionMonitor rowMonitor;
    private boolean cancel;
    private boolean doSyncDelete;
    private String cmdLineMode;
    private String targetSchema;
    private String targetCatalog;

    SchemaCopy(List<TableIdentifier> list) {
        this.sourceTables = list;
    }

    public void setAdjustNameCase(boolean bl) {
        this.adjustNames = bl;
    }

    @Override
    public void setAdjustSequences(boolean bl) {
        if (this.copier != null) {
            this.copier.setAdjustSequences(bl);
        }
    }

    @Override
    public void setTargetSchemaAndCatalog(String string, String string2) {
        this.targetSchema = string;
        this.targetCatalog = string2;
    }

    @Override
    public long copyData() throws SQLException, Exception {
        long l = 0L;
        this.cancel = false;
        Collection<TableIdentifier> collection = null;
        collection = this.checkDependencies ? this.sortTablesForInsert() : this.targetToSourceMap.keySet();
        int n = 0;
        int n2 = collection.size();
        DataReceiver dataReceiver = this.copier.getReceiver();
        dataReceiver.setTableCount(n2);
        Savepoint savepoint = null;
        try {
            savepoint = DataCopier.setSourceSavepoint(this.sourceConnection);
            this.copier.beginMultiTableCopy(this.targetConnection);
            for (TableIdentifier tableIdentifier : collection) {
                if (this.cancel) break;
                this.copier.reset();
                this.copier.setMode(this.cmdLineMode);
                dataReceiver.setCurrentTable(++n);
                TableIdentifier tableIdentifier2 = this.getSourceTable(tableIdentifier);
                if (tableIdentifier2 == null) continue;
                if (this.messages.getLength() > 0) {
                    this.messages.appendNewLine();
                }
                this.messages.append(ResourceMgr.getFormattedString("MsgCopyTable", tableIdentifier2.getTableName()));
                this.messages.appendNewLine();
                try {
                    this.copier.copyFromTable(this.sourceConnection, this.targetConnection, tableIdentifier2, tableIdentifier, null, null, this.createTableType, this.dropTable, this.ignoreDropError, this.skipTargetCheck);
                    l += this.copier.startCopy();
                    this.messages.append(this.copier.getMessageBuffer());
                }
                catch (Exception exception) {
                    this.messages.append(this.copier.getMessageBuffer());
                    this.messages.appendNewLine();
                    if (this.copier.getContinueOnError()) {
                        this.messages.appendMessageKey("MsgSkipTbl");
                        this.messages.appendNewLine();
                        LogMgr.logWarning(new CallerInfo(){}, "Skipping table " + tableIdentifier2 + " due to previous error");
                        continue;
                    }
                    throw exception;
                }
            }
            this.success = this.copier.isSuccess();
        }
        catch (Exception exception) {
            this.success = false;
            this.messages.append(this.copier.getMessageBuffer());
            throw exception;
        }
        finally {
            this.copier.endMultiTableCopy();
            this.sourceConnection.rollback(savepoint);
        }
        if (this.doSyncDelete) {
            try {
                this.messages.appendNewLine();
                this.deleteRows();
            }
            catch (SQLException sQLException) {
                this.success = false;
                this.messages.append(ExceptionUtil.getDisplay(sQLException));
                this.messages.appendNewLine();
                throw sQLException;
            }
        }
        return l;
    }

    private boolean adjustTargetName(TableIdentifier tableIdentifier) {
        if (this.adjustNames != null) {
            return this.adjustNames;
        }
        String string = tableIdentifier.getRawTableName();
        boolean bl = string.toLowerCase().equals(string);
        if (bl && this.sourceConnection.getMetadata().storesLowerCaseIdentifiers()) {
            return !this.targetConnection.getMetadata().storesLowerCaseIdentifiers();
        }
        boolean bl2 = string.toUpperCase().equals(string);
        if (bl2 && this.sourceConnection.getMetadata().storesUpperCaseIdentifiers()) {
            return !this.targetConnection.getMetadata().storesUpperCaseIdentifiers();
        }
        boolean bl3 = StringUtil.isMixedCase(string);
        if (bl3 && this.sourceConnection.getMetadata().storesMixedCaseIdentifiers()) {
            return !this.targetConnection.getMetadata().storesMixedCaseIdentifiers();
        }
        return !tableIdentifier.wasQuoted();
    }

    private void mapTables() {
        this.targetToSourceMap = new HashMap<TableIdentifier, TableIdentifier>(this.sourceTables.size());
        String string = this.targetConnection.getMetadata().getCurrentSchema();
        String string2 = this.targetConnection.getMetadata().getCurrentCatalog();
        String string3 = this.targetSchema != null ? this.targetConnection.getMetadata().adjustSchemaNameCase(this.targetSchema) : string;
        String string4 = this.targetCatalog != null ? this.targetConnection.getMetadata().adjustObjectnameCase(this.targetCatalog) : string2;
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.targetConnection);
        String[] stringArray = this.targetConnection.getMetadata().getTablesAndViewTypes();
        for (TableIdentifier tableIdentifier : this.sourceTables) {
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.setNeverAdjustCase(false);
            if (this.targetSchema != null || this.targetCatalog != null) {
                tableIdentifier2.setSchema(string3);
                tableIdentifier2.setCatalog(string4);
            }
            if (this.adjustTargetName(tableIdentifier)) {
                tableIdentifier2.adjustCase(this.targetConnection);
            } else {
                tableIdentifier2.setNeverAdjustCase(true);
            }
            if (this.createTargetTable()) {
                tableIdentifier2.setCatalog(string2);
            } else {
                if ((tableIdentifier2 = dbObjectFinder.findTable(tableIdentifier2, stringArray)) == null && this.targetSchema == null && this.targetCatalog == null) {
                    tableIdentifier2 = new TableIdentifier(tableIdentifier.getTableName(), this.sourceConnection);
                    if (tableIdentifier.getSchema() == null) {
                        tableIdentifier2.setSchema(string);
                    }
                    if (tableIdentifier.getCatalog() == null) {
                        tableIdentifier2.setCatalog(string2);
                    }
                    tableIdentifier2 = dbObjectFinder.findTable(tableIdentifier2, stringArray);
                }
                if (tableIdentifier2 == null) {
                    if (this.skipTargetCheck) {
                        tableIdentifier2 = tableIdentifier.createCopy();
                        LogMgr.logWarning(new CallerInfo(){}, "Table " + tableIdentifier.getFullyQualifiedName(this.sourceConnection) + " not found in target. Assuming same structure and name");
                    } else {
                        this.messages.append(ResourceMgr.getFormattedString("MsgCopyTableIgnored", tableIdentifier.getTableName()));
                        this.messages.appendNewLine();
                        continue;
                    }
                }
            }
            LogMgr.logTrace(new CallerInfo(){}, "Copying " + tableIdentifier.getFullyQualifiedName(this.sourceConnection) + " to " + tableIdentifier2.getFullyQualifiedName(this.targetConnection));
            this.targetToSourceMap.put(tableIdentifier2, tableIdentifier);
            if (!this.cancel) continue;
            break;
        }
    }

    private void deleteRows() throws SQLException, IOException {
        Collection<TableIdentifier> collection = null;
        collection = this.checkDependencies ? this.sortTablesForDelete() : this.targetToSourceMap.keySet();
        for (TableIdentifier tableIdentifier : collection) {
            if (this.cancel) break;
            TableIdentifier tableIdentifier2 = this.getSourceTable(tableIdentifier);
            if (tableIdentifier2 == null) continue;
            TableDeleteSync tableDeleteSync = new TableDeleteSync(this.targetConnection, this.sourceConnection);
            TableDiffStatus tableDiffStatus = tableDeleteSync.setTableName(tableIdentifier2, tableIdentifier);
            if (tableDiffStatus == TableDiffStatus.OK) {
                tableDeleteSync.setBatchSize(this.copier.getBatchSize());
                tableDeleteSync.doSync();
                long l = tableDeleteSync.getDeletedRows();
                String string = ResourceMgr.getFormattedString("MsgCopyNumRowsDeleted", l, tableIdentifier.getTableName());
                this.messages.append(string);
                this.messages.appendNewLine();
                continue;
            }
            this.messages.append(ResourceMgr.getFormattedString("ErrDataDiffNoPK", tableIdentifier.getTableName()));
            this.messages.appendNewLine();
            if (this.copier.getContinueOnError()) continue;
            break;
        }
    }

    private TableIdentifier getSourceTable(TableIdentifier tableIdentifier) {
        return this.targetToSourceMap.get(tableIdentifier);
    }

    private List<TableIdentifier> sortTablesForDelete() {
        return this.sortTables(false);
    }

    private List<TableIdentifier> sortTablesForInsert() {
        return this.sortTables(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableIdentifier> sortTables(boolean bl) {
        try {
            if (this.rowMonitor != null) {
                this.rowMonitor.setMonitorType(7);
                this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgFkDeps"), -1L, -1L);
            }
            ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(this.targetToSourceMap.keySet());
            this.sorter = new TableDependencySorter(this.targetConnection);
            List<TableIdentifier> list = null;
            list = bl ? this.sorter.sortForInsert(arrayList) : this.sorter.sortForDelete(arrayList, false);
            List<TableIdentifier> list2 = list;
            return list2;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when checking FK dependencies", exception);
        }
        finally {
            this.sorter = null;
        }
        return null;
    }

    @Override
    public boolean init(WbConnection wbConnection, WbConnection wbConnection2, StatementRunnerResult statementRunnerResult, ArgumentParser argumentParser, RowActionMonitor rowActionMonitor) throws SQLException {
        this.sourceConnection = wbConnection;
        this.targetConnection = wbConnection2;
        boolean bl = argumentParser.getBoolean("createTarget", false);
        this.createTableType = bl ? argumentParser.getValue("tableType", "default") : null;
        this.dropTable = CommonArgs.getDropType(argumentParser);
        this.ignoreDropError = argumentParser.getBoolean("ignoreDropErrors", false);
        this.skipTargetCheck = argumentParser.getBoolean("skipTargetCheck", false);
        this.rowMonitor = rowActionMonitor;
        this.copier = WbCopy.createDataCopier(argumentParser, wbConnection2.getDbSettings());
        this.cmdLineMode = argumentParser.getValue("mode");
        if (!this.copier.setMode(this.cmdLineMode)) {
            statementRunnerResult.addErrorMessageByKey("ErrImpInvalidMode", this.cmdLineMode);
            return false;
        }
        this.checkDependencies = argumentParser.getBoolean("checkDependencies");
        this.copier.setRowActionMonitor(this.rowMonitor);
        this.doSyncDelete = argumentParser.getBoolean("syncDelete", false) && !this.createTargetTable();
        this.mapTables();
        if (this.cancel) {
            return false;
        }
        if (this.checkDependencies && !this.doSyncDelete) {
            ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(this.targetToSourceMap.keySet());
            this.copier.setTableList(arrayList);
        }
        return this.targetToSourceMap.size() > 0;
    }

    private boolean createTargetTable() {
        return this.createTableType != null;
    }

    @Override
    public boolean hasWarnings() {
        if (this.copier == null) {
            return false;
        }
        return this.copier.hasWarnings();
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public CharSequence getMessages() {
        return this.messages.getBuffer();
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.messages.appendMessageKey("MsgCopyCancelled");
        if (this.copier != null) {
            this.copier.cancel();
        }
        if (this.sorter != null) {
            this.sorter.cancel();
        }
    }
}

