/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbObjectFinder;
import workbench.db.DbSearchPath;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class SourceTableArgument {
    private List<String> missingTables = new ArrayList<String>();
    private List<TableIdentifier> tables = new ArrayList<TableIdentifier>();
    private boolean wildcardsPresent;
    private boolean schemaAsCatalog;

    public SourceTableArgument(String string, WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return;
        }
        this.schemaAsCatalog = !wbConnection.getDbSettings().supportsSchemas();
        this.initTableList(string, null, null, wbConnection.getMetadata().getTableTypesArray(), wbConnection);
    }

    public SourceTableArgument(String string, String string2, String string3, WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return;
        }
        String[] stringArray = wbConnection.getMetadata().getTablesAndViewTypes();
        this.schemaAsCatalog = !wbConnection.getDbSettings().supportsSchemas();
        this.initTableList(string, string2, string3, stringArray, wbConnection);
    }

    public SourceTableArgument(String string, String string2, String string3, String[] stringArray, WbConnection wbConnection) throws SQLException {
        if (StringUtil.isEmptyString(string) && StringUtil.isEmptyString(string3)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        this.schemaAsCatalog = !wbConnection.getDbSettings().supportsSchemas();
        this.initTableList(string, string2, string3, stringArray, wbConnection);
    }

    private void initTableList(String string, String string2, String string3, String[] stringArray, WbConnection wbConnection) throws SQLException {
        this.missingTables.clear();
        List<TableIdentifier> list = this.retrieveObjects(string, string3, true, stringArray, wbConnection);
        this.tables.addAll(list);
        if (StringUtil.isNonBlank(string2)) {
            List<TableIdentifier> list2 = this.retrieveObjects(string2, string3, false, null, wbConnection);
            this.tables.removeAll(list2);
        }
    }

    public static String[] parseTypes(String string, WbConnection wbConnection) {
        if (StringUtil.isBlank(string)) {
            return wbConnection.getMetadata().getSelectableTypes();
        }
        if ("%".equals(string) || "*".equals(string)) {
            return null;
        }
        List<String> list = StringUtil.stringToList(string.toUpperCase());
        if (list.isEmpty()) {
            return wbConnection.getMetadata().getSelectableTypes();
        }
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    private List<TableIdentifier> retrieveObjects(String string, String string2, boolean bl, String[] stringArray, WbConnection wbConnection) throws SQLException {
        String string3;
        boolean bl2;
        List<String> list = this.getObjectNames(string);
        List<TableIdentifier> list2 = CollectionUtil.arrayList();
        if (list.size() <= 0 && StringUtil.isBlank(string2)) {
            return list2;
        }
        boolean bl3 = bl2 = DbSearchPath.Factory.getSearchPathHandler(wbConnection).isRealSearchPath() && StringUtil.isBlank(string2);
        if (bl2) {
            string3 = null;
        } else if (StringUtil.isBlank(string2)) {
            string3 = this.schemaAsCatalog ? wbConnection.getMetadata().getCurrentCatalog() : wbConnection.getMetadata().getCurrentSchema();
        } else if (string2.equals("*") || string2.equals("%")) {
            string3 = null;
            list = CollectionUtil.arrayList("*");
        } else {
            string3 = wbConnection.getMetadata().adjustSchemaNameCase(string2);
        }
        if (list.isEmpty() && string3 != null) {
            List<TableIdentifier> list3 = null;
            list3 = this.schemaAsCatalog ? wbConnection.getMetadata().getObjectList(null, string3, null, stringArray) : wbConnection.getMetadata().getObjectList(null, null, string3, stringArray);
            list2.addAll(list3);
        } else {
            for (String string4 : list) {
                List<TableIdentifier> list4;
                TableIdentifier tableIdentifier;
                if (string4.indexOf(42) > -1 || string4.indexOf(37) > -1) {
                    if (bl) {
                        this.wildcardsPresent = true;
                    }
                    tableIdentifier = new TableIdentifier(string4);
                    this.adjustTableSchema(tableIdentifier, string3);
                    tableIdentifier.adjustCase(wbConnection);
                    list4 = null;
                    list4 = this.schemaAsCatalog ? wbConnection.getMetadata().getObjectList(tableIdentifier.getTableName(), tableIdentifier.getSchema(), null, stringArray) : wbConnection.getMetadata().getObjectList(tableIdentifier.getTableName(), null, tableIdentifier.getSchema(), stringArray);
                    list2.addAll(list4);
                    continue;
                }
                tableIdentifier = new TableIdentifier(string4, wbConnection);
                this.adjustTableSchema(tableIdentifier, string3);
                list4 = new DbObjectFinder(wbConnection).searchObjectOnPath(tableIdentifier, stringArray);
                if (list4 != null) {
                    list2.add((TableIdentifier)((Object)list4));
                    continue;
                }
                this.missingTables.add(string4);
                LogMgr.logDebug(new CallerInfo(){}, "Table " + string4 + " not found!");
            }
        }
        return list2;
    }

    private void adjustTableSchema(TableIdentifier tableIdentifier, String string) {
        if (tableIdentifier.getSchema() == null && StringUtil.isNonEmpty(string)) {
            if (this.schemaAsCatalog) {
                tableIdentifier.setCatalog(string);
            } else {
                tableIdentifier.setSchema(string);
            }
        }
    }

    public List<String> getMissingTables() {
        return this.missingTables;
    }

    List<String> getObjectNames(String string) {
        if (StringUtil.isEmptyString(string)) {
            return Collections.emptyList();
        }
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(string, ",");
        wbStringTokenizer.setDelimiterNeedsWhitspace(false);
        wbStringTokenizer.setCheckBrackets(false);
        wbStringTokenizer.setKeepQuotes(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (wbStringTokenizer.hasMoreTokens()) {
            String string2 = wbStringTokenizer.nextToken();
            if (string2 == null || (string2 = string2.trim()).length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public List<TableIdentifier> getTables() {
        return this.tables;
    }

    public boolean wasWildcardArgument() {
        return this.wildcardsPresent;
    }
}

