/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.DropType;
import workbench.db.TableIdentifier;
import workbench.db.TableNotFoundException;
import workbench.db.WbConnection;
import workbench.db.datacopy.DataCopier;
import workbench.db.objectcache.Namespace;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.CopyTask;
import workbench.sql.wbcommands.WbCopy;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

class TableCopy
implements CopyTask {
    private DataCopier copier;

    TableCopy() {
    }

    @Override
    public long copyData() throws SQLException, Exception {
        return this.copier.startCopy();
    }

    @Override
    public void setAdjustSequences(boolean bl) {
        this.copier.setAdjustSequences(bl);
    }

    @Override
    public boolean init(WbConnection wbConnection, WbConnection wbConnection2, StatementRunnerResult statementRunnerResult, ArgumentParser argumentParser, RowActionMonitor rowActionMonitor) throws SQLException {
        Object object;
        String string = argumentParser.getValue("sourceTable");
        String string2 = SqlUtil.trimSemicolon(argumentParser.getValue("sourceQuery"));
        String string3 = argumentParser.getValue("targetTable");
        String string4 = argumentParser.getValue("targetSchema");
        if (string3 == null) {
            string3 = string;
        }
        boolean bl = argumentParser.getBoolean("createTarget");
        DropType dropType = CommonArgs.getDropType(argumentParser);
        boolean bl2 = argumentParser.getBoolean("ignoreDropErrors", false);
        boolean bl3 = argumentParser.getBoolean("skipTargetCheck", false);
        this.copier = WbCopy.createDataCopier(argumentParser, wbConnection2.getDbSettings());
        String string5 = argumentParser.getValue("keyColumns");
        this.copier.setKeyColumns(string5);
        String string6 = argumentParser.getValue("mode");
        if (!this.copier.setMode(string6, wbConnection2)) {
            statementRunnerResult.addErrorMessageByKey("ErrImpInvalidMode", string6);
            return false;
        }
        this.copier.setRowActionMonitor(rowActionMonitor);
        String string7 = null;
        TableIdentifier tableIdentifier = new TableIdentifier(string3, wbConnection2);
        Namespace namespace = Namespace.fromExpression(wbConnection2, string4);
        namespace.setNamespace(tableIdentifier);
        if (bl) {
            tableIdentifier.setNewTable(true);
            string7 = argumentParser.getValue("tableType", "default");
        } else {
            object = wbConnection2.getMetadata().getTablesAndViewTypes();
            tableIdentifier = new DbObjectFinder(wbConnection2).findTable(tableIdentifier, (String[])object);
        }
        if (tableIdentifier == null) {
            if (bl3) {
                tableIdentifier = new TableIdentifier(string3, wbConnection2);
            } else {
                throw new TableNotFoundException(string3);
            }
        }
        if (string != null) {
            object = new TableIdentifier(string, wbConnection);
            String string8 = argumentParser.getValue("sourceWhere");
            Map<String, String> map = this.parseMapping(argumentParser);
            this.copier.copyFromTable(wbConnection, wbConnection2, (TableIdentifier)object, tableIdentifier, map, string8, string7, dropType, bl2, bl3);
        } else {
            object = this.parseColumns(argumentParser);
            List<ColumnIdentifier> list = SqlUtil.getResultSetColumns(string2, wbConnection);
            if (object != null) {
                if (list.size() != object.size()) {
                    statementRunnerResult.addErrorMessage("Columns in query does not match number of columns in -columns parameter");
                    return false;
                }
                for (int i = 0; i < object.size(); ++i) {
                    list.get(i).setColumnName(((ColumnIdentifier)object.get(i)).getColumnName());
                    list.get(i).setColumnAlias(null);
                }
            }
            this.copier.copyFromQuery(wbConnection, wbConnection2, string2, tableIdentifier, list, string7, dropType, bl2, bl3);
        }
        boolean bl4 = argumentParser.getBoolean("syncDelete", false) && !bl;
        this.copier.setDoDeleteSync(bl4);
        return true;
    }

    @Override
    public void setTargetSchemaAndCatalog(String string, String string2) {
    }

    @Override
    public boolean isSuccess() {
        if (this.copier == null) {
            return true;
        }
        return this.copier.isSuccess();
    }

    @Override
    public boolean hasWarnings() {
        if (this.copier == null) {
            return false;
        }
        return this.copier.hasWarnings();
    }

    @Override
    public CharSequence getMessages() {
        if (this.copier == null) {
            return null;
        }
        return this.copier.getAllMessages();
    }

    @Override
    public void cancel() {
        if (this.copier != null) {
            this.copier.cancel();
        }
    }

    protected List<ColumnIdentifier> parseColumns(ArgumentParser argumentParser) {
        String string = argumentParser.getValue("columns");
        if (StringUtil.isBlank(string)) {
            return null;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, true);
        int n = list.size();
        List<ColumnIdentifier> list2 = CollectionUtil.sizedArrayList(n);
        for (String string2 : list) {
            if (string2.indexOf(47) > -1) {
                this.copier.addError(ResourceMgr.getString("MsgCopyErrIllegalMapping"));
                return null;
            }
            list2.add(new ColumnIdentifier(string2));
        }
        return list2;
    }

    protected Map<String, String> parseMapping(ArgumentParser argumentParser) {
        String string = argumentParser.getValue("columns");
        if (string == null || string.length() == 0) {
            return null;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true, false, true);
        int n = list.size();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            int n2 = string2.indexOf(47);
            if (n2 == -1) {
                linkedHashMap.put(string2, null);
                continue;
            }
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            linkedHashMap.put(string3, string4);
        }
        return linkedHashMap;
    }
}

