/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.WbManager;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.DbSettings;
import workbench.db.TableIdentifier;
import workbench.db.TableNotFoundException;
import workbench.db.WbConnection;
import workbench.db.datacopy.DataCopier;
import workbench.db.importer.TableStatements;
import workbench.gui.profiles.ProfileKey;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommandLineConnectionHandler;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.sql.wbcommands.CopyTask;
import workbench.sql.wbcommands.SchemaCopy;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.sql.wbcommands.TableCopy;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class WbCopy
extends SqlCommand {
    public static final String VERB = "WbCopy";
    public static final String PARAM_SOURCETABLE = "sourceTable";
    public static final String PARAM_SOURCESCHEMA = "sourceSchema";
    public static final String PARAM_TARGETSCHEMA = "targetSchema";
    public static final String PARAM_SOURCEQUERY = "sourceQuery";
    public static final String PARAM_TARGETTABLE = "targetTable";
    public static final String PARAM_SOURCEPROFILE = "sourceProfile";
    public static final String PARAM_SOURCEPROFILE_GROUP = "sourceGroup";
    public static final String PARAM_TARGETPROFILE = "targetProfile";
    public static final String PARAM_TARGETPROFILE_GROUP = "targetGroup";
    public static final String PARAM_COLUMNS = "columns";
    public static final String PARAM_SOURCEWHERE = "sourceWhere";
    public static final String PARAM_KEYS = "keyColumns";
    public static final String PARAM_DROPTARGET = "dropTarget";
    public static final String PARAM_CREATETARGET = "createTarget";
    public static final String PARAM_REMOVE_DEFAULTS = "removeDefaults";
    public static final String PARAM_SOURCE_CONN = "sourceConnection";
    public static final String PARAM_TARGET_CONN = "targetConnection";
    public static final String PARAM_ADJUST_NAMES = "fixTableNameCase";
    public static final String PARAM_INCLUDE_VIEWS = "includeViews";
    public static final String PARAM_MAX_ROWS = "maxRows";
    public static final String PARAM_TABLE_TYPE = "tableType";
    public static final String PARAM_SKIP_TARGET_CHECK = "skipTargetCheck";
    public static final String PARAM_DELETE_SYNC = "syncDelete";
    private static final String ID_PREFIX = "$Wb-Copy$";
    private static int runCount;
    private int runId;
    private CopyTask copier;
    private long lastCopyCount;

    public WbCopy() {
        this.isUpdatingCommand = true;
        this.cmdLine = new ArgumentParser();
        CommonArgs.addCommitParameter(this.cmdLine);
        CommonArgs.addImportModeParameter(this.cmdLine);
        CommonArgs.addContinueParameter(this.cmdLine);
        CommonArgs.addProgressParameter(this.cmdLine);
        CommonArgs.addCommitAndBatchParams(this.cmdLine);
        CommonArgs.addCheckDepsParameter(this.cmdLine);
        CommonArgs.addTableStatements(this.cmdLine);
        CommonArgs.addTransactionControL(this.cmdLine);
        ConditionCheck.addParameters(this.cmdLine);
        this.cmdLine.addArgument(PARAM_SOURCETABLE);
        this.cmdLine.addArgument("ignoreDropErrors", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("ignoreIdentityColumns", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_SOURCEQUERY);
        this.cmdLine.addArgument(PARAM_SOURCESCHEMA);
        this.cmdLine.addArgument(PARAM_TARGETTABLE);
        this.cmdLine.addArgument(PARAM_TARGETSCHEMA);
        this.cmdLine.addArgument(PARAM_SOURCE_CONN);
        this.cmdLine.addArgument(PARAM_TARGET_CONN);
        this.cmdLine.addArgument(PARAM_SOURCEPROFILE, ArgumentType.ProfileArgument);
        this.cmdLine.addArgument(PARAM_TARGETPROFILE, ArgumentType.ProfileArgument);
        this.cmdLine.addArgument(PARAM_SOURCEPROFILE_GROUP);
        this.cmdLine.addArgument(PARAM_TARGETPROFILE_GROUP);
        this.cmdLine.addArgument(PARAM_COLUMNS);
        this.cmdLine.addArgument(PARAM_SOURCEWHERE);
        this.cmdLine.addArgument(PARAM_INCLUDE_VIEWS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_MAX_ROWS);
        this.cmdLine.addArgument(PARAM_ADJUST_NAMES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("deleteTarget", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("truncateTable", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("excludeTables", ArgumentType.TableArgument);
        this.cmdLine.addArgument(PARAM_KEYS);
        this.cmdLine.addArgument(PARAM_DROPTARGET, CollectionUtil.arrayList("false", "true", "cascade"));
        this.cmdLine.addArgument(PARAM_SKIP_TARGET_CHECK, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(PARAM_CREATETARGET, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_REMOVE_DEFAULTS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_DELETE_SYNC, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("useSavepoint", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("trimCharData", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("adjustSequences", ArgumentType.BoolSwitch);
        this.cmdLine.addArgumentWithValues(PARAM_TABLE_TYPE, DbSettings.getCreateTableTypes());
    }

    long getAffectedRows() {
        return this.lastCopyCount;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    private void addWrongParams(StatementRunnerResult statementRunnerResult) {
        if (!WbManager.getInstance().isBatchMode()) {
            statementRunnerResult.addMessageNewLine();
            statementRunnerResult.addMessageByKey("ErrCopyWrongParameters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrCopyWrongParameters"));
            return statementRunnerResult;
        }
        if (!this.checkConditions(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string2 = VERB;
        synchronized (VERB) {
            Object object;
            Object object2;
            this.runId = ++runCount;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            string2 = this.cmdLine.getValue(PARAM_SOURCETABLE);
            String string3 = this.cmdLine.getValue(PARAM_SOURCESCHEMA);
            String string4 = this.cmdLine.getValue(PARAM_SOURCEQUERY);
            boolean bl = this.cmdLine.getBoolean(PARAM_DELETE_SYNC, false);
            if (bl && StringUtil.isNonBlank(string4)) {
                statementRunnerResult.addErrorMessageByKey("ErrCopySyncNoQuery");
                return statementRunnerResult;
            }
            if (StringUtil.isBlank(string2) && StringUtil.isBlank(string4) && StringUtil.isBlank(string3)) {
                statementRunnerResult.addErrorMessageByKey("ErrCopyNoSourceSpecified");
                this.addWrongParams(statementRunnerResult);
                return statementRunnerResult;
            }
            if (StringUtil.isNonBlank(string2) && StringUtil.isNonBlank(string4)) {
                statementRunnerResult.addErrorMessageByKey("ErrCopyTargetAndQuery");
                return statementRunnerResult;
            }
            CommandLineConnectionHandler commandLineConnectionHandler = new CommandLineConnectionHandler(this.cmdLine, PARAM_TARGETPROFILE, PARAM_TARGETPROFILE_GROUP, PARAM_TARGET_CONN);
            WbConnection wbConnection = commandLineConnectionHandler.getConnection(statementRunnerResult, this.currentConnection, this.getBaseDir(), "$Wb-Copy$-Target-" + this.runId + "$");
            if (wbConnection == null || !statementRunnerResult.isSuccess()) {
                LogMgr.logError(new CallerInfo(){}, "Could not create target connection!", null);
                return statementRunnerResult;
            }
            CommandLineConnectionHandler commandLineConnectionHandler2 = new CommandLineConnectionHandler(this.cmdLine, PARAM_SOURCEPROFILE, PARAM_SOURCEPROFILE_GROUP, PARAM_SOURCE_CONN);
            WbConnection wbConnection2 = commandLineConnectionHandler2.getConnection(statementRunnerResult, this.currentConnection, this.getBaseDir(), "$Wb-Copy$-Source-" + this.runId + "$");
            if (wbConnection2 == null || !statementRunnerResult.isSuccess()) {
                LogMgr.logError(new CallerInfo(){}, "Could not create source connection!", null);
                return statementRunnerResult;
            }
            boolean bl2 = this.cmdLine.getBoolean(PARAM_INCLUDE_VIEWS, false);
            List<TableIdentifier> list = null;
            SourceTableArgument sourceTableArgument = null;
            try {
                object2 = this.cmdLine.getValue("excludeTables");
                object = bl2 ? wbConnection2.getMetadata().getTablesAndViewTypes() : wbConnection2.getMetadata().getTableTypesArray();
                sourceTableArgument = new SourceTableArgument(string2, (String)object2, string3, (String[])object, wbConnection2);
                list = sourceTableArgument.getTables();
                if (list.isEmpty() && sourceTableArgument.wasWildcardArgument()) {
                    statementRunnerResult.addErrorMessageByKey("ErrExportNoTablesFound", string2);
                    return statementRunnerResult;
                }
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve table list", sQLException);
                statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(sQLException));
                return statementRunnerResult;
            }
            if (list.size() > 1 || sourceTableArgument.wasWildcardArgument()) {
                object2 = this.cmdLine.getValue(PARAM_TARGETTABLE);
                if (StringUtil.isNonBlank((CharSequence)object2)) {
                    statementRunnerResult.addErrorMessageByKey("ErrCopyMultiSrcNoTarget");
                    return statementRunnerResult;
                }
                object = new SchemaCopy(list);
                if (this.cmdLine.isArgPresent(PARAM_ADJUST_NAMES)) {
                    ((SchemaCopy)object).setAdjustNameCase(this.cmdLine.getBoolean(PARAM_ADJUST_NAMES, true));
                }
                this.copier = object;
                this.copier.setTargetSchemaAndCatalog(this.cmdLine.getValue(PARAM_TARGETSCHEMA), null);
            } else {
                this.copier = new TableCopy();
            }
            try {
                if (!this.copier.init(wbConnection2, wbConnection, statementRunnerResult, this.cmdLine, this.rowMonitor)) {
                    statementRunnerResult.addMessage(this.copier.getMessages());
                    object2 = statementRunnerResult;
                    return object2;
                }
                this.copier.setAdjustSequences(this.cmdLine.getBoolean("adjustSequences", false));
                this.lastCopyCount = this.copier.copyData();
                if (this.copier.isSuccess()) {
                    statementRunnerResult.setSuccess();
                } else {
                    statementRunnerResult.setFailure();
                }
                if (this.copier.hasWarnings()) {
                    statementRunnerResult.setWarning();
                }
                statementRunnerResult.addMessage(this.copier.getMessages());
            }
            catch (TableNotFoundException tableNotFoundException) {
                object = ResourceMgr.getFormattedString("ErrTargetTableNotFound", tableNotFoundException.getTableName());
                statementRunnerResult.addErrorMessage((String)object);
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "SQL Error when copying data", sQLException);
                object = this.copier.getMessages();
                if (object.length() == 0) {
                    String string5 = ResourceMgr.getFormattedString("ErrCopy", ExceptionUtil.getDisplay(sQLException, false));
                    statementRunnerResult.addErrorMessage(string5);
                } else {
                    statementRunnerResult.addErrorMessage(object.toString());
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when copying data", exception);
                statementRunnerResult.setFailure();
                this.addErrorInfo(statementRunnerResult, string, exception);
                statementRunnerResult.addMessage(this.copier.getMessages());
            }
            finally {
                this.closeConnections(wbConnection2, wbConnection);
            }
            return statementRunnerResult;
        }
    }

    @Override
    public void done() {
        super.done();
        this.copier = null;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.copier != null) {
            this.copier.cancel();
        }
    }

    private void closeConnections(WbConnection wbConnection, WbConnection wbConnection2) {
        try {
            if (wbConnection != null && wbConnection.getId().startsWith(ID_PREFIX)) {
                wbConnection.disconnect();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when disconnecting source connection", exception);
        }
        try {
            if (wbConnection2 != null && wbConnection2.getId().startsWith(ID_PREFIX)) {
                wbConnection2.disconnect();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when disconnecting target connection", exception);
        }
    }

    @Override
    public ConnectionProfile getModificationTarget(WbConnection wbConnection, String string) {
        this.cmdLine.parse(this.getCommandLine(string));
        CommandLineConnectionHandler commandLineConnectionHandler = new CommandLineConnectionHandler(this.cmdLine, PARAM_TARGETPROFILE, PARAM_TARGETPROFILE_GROUP, PARAM_TARGET_CONN);
        ProfileKey profileKey = commandLineConnectionHandler.getProfileKey();
        if (profileKey == null) {
            return null;
        }
        ConnectionProfile connectionProfile = ConnectionMgr.getInstance().getProfile(profileKey);
        return connectionProfile;
    }

    static DataCopier createDataCopier(ArgumentParser argumentParser, DbSettings dbSettings) {
        DataCopier dataCopier = new DataCopier();
        dataCopier.setIgnoreColumnDefaults(argumentParser.getBoolean(PARAM_REMOVE_DEFAULTS, false));
        dataCopier.setMaxRows(argumentParser.getIntValue(PARAM_MAX_ROWS, -1));
        if (argumentParser.isArgPresent("trimCharData")) {
            dataCopier.setTrimCharData(argumentParser.getBoolean("trimCharData", false));
        }
        dataCopier.setPerTableStatements(new TableStatements(argumentParser));
        dataCopier.setTransactionControl(argumentParser.getBoolean("transactionControl", true));
        dataCopier.setIgnoreIdentityColumns(argumentParser.getBoolean("ignoreIdentityColumns", false));
        dataCopier.setContinueOnError(argumentParser.getBoolean("continueOnError"));
        dataCopier.setDeleteTarget(CommonArgs.getDeleteType(argumentParser));
        dataCopier.setUseSavepoint(argumentParser.getBoolean("useSavepoint", dbSettings.useSavepointForImport()));
        CommonArgs.setProgressInterval(dataCopier, argumentParser);
        CommonArgs.setCommitAndBatchParams(dataCopier, argumentParser);
        return dataCopier;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

