/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;

public class WbDisableOraOutput
extends SqlCommand {
    public static final String VERB = "DISABLEOUT";

    public WbDisableOraOutput() {
        this.cmdLine = new ArgumentParser(false);
        this.cmdLine.addArgument("quiet", ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        this.currentConnection.getMetadata().disableOutput();
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.cmdLine.getBoolean("quiet")) {
            LogMgr.logDebug(new CallerInfo(){}, "Support for dbms_output disabled");
        } else {
            statementRunnerResult.addMessageByKey("MsgDbmsOutputDisabled");
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

