/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.db.WbConnection;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.util.StringUtil;

public class WbFetchSize
extends SqlCommand {
    public static final String VERB = "WbFetchSize";

    public WbFetchSize() {
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        if (StringUtil.isNonBlank(string2)) {
            WbFetchSize.setFetchSize(string2, statementRunnerResult, this.currentConnection);
        } else {
            String string3 = "(" + ResourceMgr.getString("TxtDefault").toLowerCase() + ")";
            int n = this.currentConnection.getFetchSize();
            if (n > -1) {
                string3 = Integer.toString(n);
            }
            statementRunnerResult.addMessageByKey("MsgFetchSizeCurrent", string3);
        }
        return statementRunnerResult;
    }

    public static void setFetchSize(String string, StatementRunnerResult statementRunnerResult, WbConnection wbConnection) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessageByKey("ErrInvalidNumber", string);
            return;
        }
        wbConnection.setFetchSize(n);
        statementRunnerResult.addMessageByKey("MsgFetchSizeChanged", Integer.toString(wbConnection.getFetchSize()));
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

