/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.CommitType;
import workbench.db.DeleteScriptGenerator;
import workbench.db.TableDeleter;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.storage.ColumnData;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.WbFile;

public class WbGenDelete
extends SqlCommand
implements ScriptGenerationMonitor {
    public static final String VERB = "WbGenerateDelete";
    public static final String ARG_TABLE = "table";
    public static final String ARG_COLUMN_VAL = "columnValue";
    public static final String ARG_DO_FORMAT = "formatSql";
    public static final String ARG_INCLUDE_COMMIT = "includeCommit";
    public static final String ARG_APPEND = "appendFile";
    public static final String ARG_SHOW_FK_NAMES = "showConstraints";
    public static final String ARG_EXCLUDE_TABLES = "excludeTables";
    public static final String ARG_USE_TRUNCATE = "useTruncate";
    private DeleteScriptGenerator generator;
    private TableDeleter simpleGenerator;

    public WbGenDelete() {
        this.isUpdatingCommand = true;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("outputFile", ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_DO_FORMAT, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_TABLE, ArgumentType.TableArgument);
        this.cmdLine.addArgument(ARG_COLUMN_VAL, ArgumentType.Repeatable);
        this.cmdLine.addArgument(ARG_INCLUDE_COMMIT, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_APPEND, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_SHOW_FK_NAMES, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_EXCLUDE_TABLES, ArgumentType.TableArgument);
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        Object object;
        Object object22;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrGenDeleteWrongParam"));
            return statementRunnerResult;
        }
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.addErrorMessageByKey("ErrGenDropWrongParam");
            return statementRunnerResult;
        }
        String[] stringArray = this.currentConnection.getMetadata().getTableTypesArray();
        SourceTableArgument sourceTableArgument = new SourceTableArgument(this.cmdLine.getValue(ARG_TABLE), this.cmdLine.getValue(ARG_EXCLUDE_TABLES), null, stringArray, this.currentConnection);
        List<TableIdentifier> list = sourceTableArgument.getTables();
        if (CollectionUtil.isEmpty(list)) {
            statementRunnerResult.addErrorMessageByKey("ErrTableNotFound", this.cmdLine.getValue(ARG_TABLE));
            return statementRunnerResult;
        }
        List<String> list2 = this.cmdLine.getList(ARG_COLUMN_VAL);
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>();
        for (Object object22 : list2) {
            object = object22.split(":");
            if (((String[])object).length == 2) {
                String string3 = object[0];
                String string4 = object[1];
                ColumnData columnData = new ColumnData(string4, new ColumnIdentifier(string3, Integer.MIN_VALUE));
                arrayList.add(columnData);
                continue;
            }
            statementRunnerResult.addErrorMessage("Illegal column specification: " + object22);
            return statementRunnerResult;
        }
        if (list.size() > 1 && CollectionUtil.isNonEmpty(arrayList)) {
            statementRunnerResult.addErrorMessage("Deletion based on column value not supported for multiple tables");
            return statementRunnerResult;
        }
        this.generator = new DeleteScriptGenerator(this.currentConnection);
        Object object3 = null;
        object22 = CommitType.never;
        if (this.cmdLine.getBoolean(ARG_INCLUDE_COMMIT)) {
            object22 = CommitType.once;
        }
        if (list.size() == 1 && CollectionUtil.isNonEmpty(arrayList)) {
            object = new SourceTableArgument(this.cmdLine.getValue(ARG_EXCLUDE_TABLES), this.currentConnection);
            this.generator.setTable(list.get(0));
            this.generator.setExcludedTables(((SourceTableArgument)object).getTables());
            this.generator.setShowConstraintNames(this.cmdLine.getBoolean(ARG_SHOW_FK_NAMES, false));
            this.generator.setFormatSql(this.cmdLine.getBoolean(ARG_DO_FORMAT, false));
            object3 = this.generator.getScriptForValues(arrayList, (CommitType)((Object)object22));
            if (this.rowMonitor != null) {
                this.rowMonitor.setMonitorType(5);
                this.generator.setProgressMonitor(this);
            }
        } else {
            this.simpleGenerator = new TableDeleter(this.currentConnection);
            if (this.rowMonitor != null) {
                this.rowMonitor.setMonitorType(5);
                this.simpleGenerator.setScriptMonitor(this);
            }
            object3 = this.simpleGenerator.generateSortedScript(list, (CommitType)((Object)object22), this.cmdLine.getBoolean(ARG_USE_TRUNCATE, false), true);
        }
        statementRunnerResult.setSuccess();
        if (this.isCancelled) {
            statementRunnerResult.addMessageByKey("MsgStatementCancelled");
            statementRunnerResult.setWarning();
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        if ((object = this.evaluateFileArgument(this.cmdLine.getValue("outputFile"))) != null && object3 != null) {
            boolean bl = this.cmdLine.getBoolean(ARG_APPEND, false);
            try {
                FileUtil.writeString((File)object, (String)object3, bl);
                statementRunnerResult.addMessage(ResourceMgr.getFormattedString("MsgScriptWritten", ((WbFile)object).getFullPath()));
            }
            catch (IOException iOException) {
                statementRunnerResult.addErrorMessageByKey("ErrFileCreate", ExceptionUtil.getDisplay(iOException));
            }
        } else {
            statementRunnerResult.addMessage((CharSequence)object3);
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.generator != null) {
            this.generator.cancel();
        }
        if (this.simpleGenerator != null) {
            this.simpleGenerator.cancel();
        }
    }

    @Override
    public void done() {
        super.done();
        this.generator = null;
    }

    @Override
    public boolean isUpdatingCommand(WbConnection wbConnection, String string) {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentObject(String string, int n, int n2) {
        if (this.rowMonitor != null) {
            if (string.indexOf(32) > -1) {
                try {
                    this.rowMonitor.saveCurrentType("genDel");
                    this.rowMonitor.setMonitorType(7);
                    this.rowMonitor.setCurrentObject(string, n, n2);
                }
                finally {
                    this.rowMonitor.restoreType("genDel");
                }
            } else {
                this.rowMonitor.setCurrentObject(string, n, n2);
            }
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public boolean shouldEndTransaction() {
        return true;
    }
}

