/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.db.DummyInsert;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableDependencySorter;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;

public class WbGenInsert
extends SqlCommand
implements ScriptGenerationMonitor {
    public static final String VERB = "WbGenerateInsert";
    public static final String PARAM_FULL_INSERT = "fullInsert";
    private TableDependencySorter tableSorter;

    public WbGenInsert() {
        this.isUpdatingCommand = true;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("tables", ArgumentType.TableArgument);
        this.cmdLine.addArgument(PARAM_FULL_INSERT, ArgumentType.BoolArgument);
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrGenInsertWrongParam"));
            return statementRunnerResult;
        }
        if (!this.cmdLine.hasArguments()) {
            statementRunnerResult.addErrorMessageByKey("ErrGenInsertWrongParam");
            return statementRunnerResult;
        }
        String string3 = this.cmdLine.getValue("tables");
        boolean bl = this.cmdLine.getBoolean(PARAM_FULL_INSERT, false);
        SourceTableArgument sourceTableArgument = new SourceTableArgument(string3, this.currentConnection);
        List<TableIdentifier> list = sourceTableArgument.getTables();
        if (CollectionUtil.isEmpty(list)) {
            statementRunnerResult.addErrorMessageByKey("ErrTableNotFound", string3);
            return statementRunnerResult;
        }
        List<String> list2 = sourceTableArgument.getMissingTables();
        this.tableSorter = new TableDependencySorter(this.currentConnection);
        this.tableSorter.setValidateTables(false);
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(5);
            this.tableSorter.setProgressMonitor(this);
        }
        List<TableIdentifier> list3 = this.tableSorter.sortForInsert(list);
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        if (this.isCancelled) {
            statementRunnerResult.addMessageByKey("MsgStatementCancelled");
        } else {
            if (!bl) {
                statementRunnerResult.addMessageByKey("MsgInsertSeq");
                statementRunnerResult.addMessageNewLine();
            }
            for (TableIdentifier object : list3) {
                if (bl) {
                    DummyInsert dummyInsert = new DummyInsert(object);
                    dummyInsert.setDoFormatSql(false);
                    String string4 = dummyInsert.getSource(this.currentConnection).toString();
                    statementRunnerResult.addMessage(string4 + "\n");
                } else {
                    statementRunnerResult.addMessage("    " + object.getTableExpression());
                }
                statementRunnerResult.setSuccess();
            }
            if (CollectionUtil.isNonEmpty(list2)) {
                statementRunnerResult.addMessageNewLine();
                statementRunnerResult.addMessageByKey("MsgTablesNotFound");
                statementRunnerResult.addMessageNewLine();
                for (String string5 : list2) {
                    statementRunnerResult.addMessage("    " + string5);
                }
            }
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.tableSorter != null) {
            this.tableSorter.cancel();
        }
    }

    @Override
    public void done() {
        super.done();
        this.tableSorter = null;
    }

    @Override
    public boolean isUpdatingCommand(WbConnection wbConnection, String string) {
        return false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentObject(String string, int n, int n2) {
        if (this.rowMonitor != null) {
            if (string.indexOf(32) > -1) {
                try {
                    this.rowMonitor.saveCurrentType("genDel");
                    this.rowMonitor.setMonitorType(7);
                    this.rowMonitor.setCurrentObject(string, n, n2);
                }
                finally {
                    this.rowMonitor.restoreType("genDel");
                }
            } else {
                this.rowMonitor.setCurrentObject(string, n, n2);
            }
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

