/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.search.ObjectSourceSearcher;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ObjectResultListDataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;

public class WbGrepSource
extends SqlCommand {
    public static final String VERB = "WbGrepSource";
    public static final String PARAM_SEARCH_EXP = "searchValues";
    public static final String PARAM_MATCHALL = "matchAll";
    public static final String PARAM_IGNORE_CASE = "ignoreCase";
    public static final String PARAM_USE_REGEX = "useRegex";
    private ObjectSourceSearcher searcher;

    public WbGrepSource() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addArgument("schemas", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("objects", ArgumentType.TableArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
        this.cmdLine.addArgument(PARAM_SEARCH_EXP);
        this.cmdLine.addArgument(PARAM_USE_REGEX);
        this.cmdLine.addArgument(PARAM_MATCHALL, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(PARAM_IGNORE_CASE, ArgumentType.BoolArgument);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrSrcSearchWrongParameters"));
            return statementRunnerResult;
        }
        List<String> list = this.cmdLine.getListValue(PARAM_SEARCH_EXP);
        if (CollectionUtil.isEmpty(list)) {
            statementRunnerResult.addMessageByKey("ErrScrSearchValueReq");
            statementRunnerResult.addErrorMessageByKey("ErrSrcSearchWrongParameters");
            return statementRunnerResult;
        }
        boolean bl = this.cmdLine.getBoolean(PARAM_MATCHALL, false);
        boolean bl2 = this.cmdLine.getBoolean(PARAM_IGNORE_CASE, true);
        boolean bl3 = this.cmdLine.getBoolean(PARAM_USE_REGEX, false);
        List<String> list2 = this.cmdLine.getListValue("schemas");
        List<String> list3 = this.cmdLine.getListValue("types");
        List<String> list4 = this.cmdLine.getListValue("objects");
        this.searcher = new ObjectSourceSearcher(this.currentConnection);
        this.searcher.setRowMonitor(this.rowMonitor);
        this.searcher.setSchemasToSearch(list2);
        this.searcher.setTypesToSearch(list3);
        this.searcher.setNamesToSearch(list4);
        this.searcher.setCatalog(this.cmdLine.getValue("catalog"));
        try {
            List<DbObject> list5 = this.searcher.searchObjects(list, bl, bl2, bl3);
            ObjectResultListDataStore objectResultListDataStore = new ObjectResultListDataStore(this.currentConnection, list5, this.searcher.getSearchSchemaCount() > 1);
            objectResultListDataStore.setGeneratingSql(string);
            String string3 = ResourceMgr.getFormattedString("MsgGrepSourceFinished", this.searcher.getNumberOfObjectsSearched(), objectResultListDataStore.getRowCount());
            statementRunnerResult.addDataStore(objectResultListDataStore);
            statementRunnerResult.setExecutionDuration(0L);
            statementRunnerResult.addMessage(string3);
            statementRunnerResult.setSuccess();
        }
        finally {
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.searcher != null) {
            this.searcher.cancelSearch();
        }
    }

    @Override
    public void done() {
        super.done();
        this.searcher = null;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

