/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.resource.DbExplorerSettings;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ObjectLister;
import workbench.storage.DataStore;
import workbench.storage.SortDefinition;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;

public class WbList
extends SqlCommand {
    public static final String VERB = "WbList";

    public WbList() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("objects");
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        String string2 = this.getCommandLine(string);
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        this.cmdLine.parse(string2);
        if (this.cmdLine.isArgPresent("help")) {
            statementRunnerResult.addMessageByKey("ErrListWrongArgs");
            statementRunnerResult.setSuccess();
            return statementRunnerResult;
        }
        ObjectLister objectLister = new ObjectLister();
        DataStore dataStore = objectLister.getObjects(this.cmdLine, string2, this.currentConnection);
        if (dataStore != null) {
            dataStore.setResultName(ResourceMgr.getString("TxtObjList"));
            dataStore.setGeneratingSql(string);
            SortDefinition sortDefinition = SortDefinition.getTableListSort();
            sortDefinition.setIgnoreCase(DbExplorerSettings.sortIgnoreCase());
            sortDefinition.setUseNaturalSort(DbExplorerSettings.useNaturalSort());
            dataStore.sort(sortDefinition);
            statementRunnerResult.addDataStore(dataStore);
            if (this.currentConnection.getDbSettings().supportsSchemas() && objectLister.getSchemaUsed() != null) {
                this.currentConnection.getObjectCache().addTableList(dataStore, objectLister.getSchemaUsed());
            } else if (this.currentConnection.getDbSettings().supportsCatalogs() && objectLister.getCatalogUsed() != null) {
                this.currentConnection.getObjectCache().addTableList(dataStore, objectLister.getCatalogUsed());
            }
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

