/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.gui.dbobjects.QuickFilterExpressionBuilder;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.VariablePool;
import workbench.sql.wbcommands.CommandTester;
import workbench.storage.DataStore;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.RegExComparator;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;

public class WbListVars
extends SqlCommand {
    public static final String VERB = "WbVarList";
    public static final String VERB_ALTERNATE = "WbListVars";
    public static final String ARG_MATCH = "match";

    public WbListVars() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_MATCH);
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return VERB_ALTERNATE;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        DataStore dataStore = VariablePool.getInstance().getVariablesDataStore();
        dataStore.setResultName(ResourceMgr.getString("TxtVariables"));
        ColumnExpression columnExpression = null;
        if (this.cmdLine.hasArguments()) {
            object = this.cmdLine.getValue(ARG_MATCH);
            if (StringUtil.isNonBlank((CharSequence)object)) {
                columnExpression = new ColumnExpression(dataStore.getColumnName(0), new RegExComparator(), object);
            }
        } else if (StringUtil.isNonBlank(string2)) {
            object = new QuickFilterExpressionBuilder();
            columnExpression = ((QuickFilterExpressionBuilder)object).buildExpression(string2.trim(), dataStore.getColumnName(0), true);
        }
        if (columnExpression != null) {
            dataStore.applyFilter(columnExpression);
            dataStore.sortByColumn(1, true);
        }
        dataStore.resetStatus();
        object = new CommandTester();
        dataStore.setGeneratingSql(((CommandTester)object).formatVerb(this.getVerb()) + string2);
        statementRunnerResult.addDataStore(dataStore);
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

