/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.storage.DataStore;
import workbench.storage.NamedSortDefinition;
import workbench.storage.SortDefinition;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class WbRowCount
extends SqlCommand {
    public static final String VERB = "WbRowCount";
    public static final String ARG_ORDER_BY = "orderBy";
    public static final String ARG_EXCL_COLS = "excludeColumns";
    public static final String ARG_REMOVE_EMPTY = "removeEmpty";

    public WbRowCount() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("objects", ArgumentType.TableArgument);
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addDeprecatedArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addDeprecatedArgument("catalog", ArgumentType.CatalogArgument);
        this.cmdLine.addArgument("excludeTables", ArgumentType.TableArgument);
        this.cmdLine.addArgument(ARG_REMOVE_EMPTY, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_ORDER_BY, CollectionUtil.arrayList("rowcount", "type", "schema", "catalog", "name"));
        this.cmdLine.addArgument(ARG_EXCL_COLS, CollectionUtil.arrayList("schema", "catalog", "database", "type"));
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    public static DataStore buildResultDataStore(WbConnection wbConnection) {
        return WbRowCount.buildResultDataStore(wbConnection, true, true, true);
    }

    public static DataStore buildResultDataStore(WbConnection wbConnection, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add(ResourceMgr.getString("TxtRowCnt").toUpperCase());
        arrayList.add("NAME");
        if (bl3) {
            arrayList.add("TYPE");
        }
        if (bl) {
            arrayList.add(wbConnection.getMetadata().getCatalogTerm().toUpperCase());
        }
        if (bl2) {
            arrayList.add(wbConnection.getMetadata().getSchemaTerm().toUpperCase());
        }
        int[] nArray = new int[arrayList.size()];
        nArray[0] = -5;
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                nArray[i] = 12;
            }
            stringArray[i] = (String)arrayList.get(i);
        }
        DataStore dataStore = new DataStore(stringArray, nArray);
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        SortDefinition sortDefinition;
        List<String> list;
        String[] stringArray;
        boolean bl;
        String string2 = this.getCommandLine(string);
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string3 = WbRowCount.getDefaultSortConfig();
        String string4 = this.cmdLine.getValue(ARG_ORDER_BY, string3);
        boolean bl2 = bl = !this.cmdLine.getBoolean(ARG_REMOVE_EMPTY);
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(7);
            this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgDiffRetrieveDbInfo"), -1L, -1L);
        }
        String string5 = null;
        String string6 = null;
        if (this.cmdLine.hasArguments()) {
            string5 = this.cmdLine.getValue("objects");
            string6 = this.cmdLine.getValue("excludeTables");
            stringArray = this.cmdLine.getValue("schema");
            list = this.cmdLine.getValue("catalog");
            if (StringUtil.isBlank(string5) && StringUtil.isNonBlank((CharSequence)stringArray)) {
                string5 = (String)stringArray + ".%";
            } else if (StringUtil.isBlank(string5) && StringUtil.isNonBlank((CharSequence)((Object)list))) {
                string5 = (String)((Object)list) + ".%";
            }
        } else {
            string5 = this.cmdLine.getNonArguments();
        }
        if (StringUtil.isEmptyString(string5)) {
            string5 = "%";
        }
        stringArray = null;
        list = this.cmdLine.getListValue("types");
        stringArray = CollectionUtil.isEmpty(list) ? this.currentConnection.getMetadata().getTableTypesArray() : StringUtil.toArray(list, true, true);
        SourceTableArgument sourceTableArgument = new SourceTableArgument(string5, string6, null, stringArray, this.currentConnection);
        List<TableIdentifier> list2 = sourceTableArgument.getTables();
        if (CollectionUtil.isEmpty(list2)) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("ErrNoTablesFound");
            return statementRunnerResult;
        }
        boolean bl3 = this.currentConnection.getDbSettings().useSavePointForDML();
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(this.cmdLine.getListValue(ARG_EXCL_COLS));
        String string7 = this.currentConnection.getMetadata().getSchemaTerm().toLowerCase();
        String string8 = this.currentConnection.getMetadata().getCatalogTerm().toLowerCase();
        boolean bl4 = true;
        boolean bl5 = this.currentConnection.getDbSettings().supportsSchemas();
        boolean bl6 = this.currentConnection.getDbSettings().supportsCatalogs();
        if (set.contains("type")) {
            bl4 = false;
        }
        if (set.contains("schema") || set.contains(string7)) {
            bl5 = false;
        }
        if (set.contains("catalog") || set.contains("database") || set.contains(string8)) {
            bl6 = false;
        }
        DataStore dataStore = WbRowCount.buildResultDataStore(this.currentConnection, bl6, bl5, bl4);
        TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.currentConnection, "tablerowcount", "tabledata");
        this.currentStatement = this.currentConnection.createStatementForQuery();
        int n = dataStore.getColumnIndex("TYPE");
        int n2 = dataStore.getColumnIndex(this.currentConnection.getMetadata().getCatalogTerm());
        int n3 = dataStore.getColumnIndex(this.currentConnection.getMetadata().getSchemaTerm());
        int n4 = list2.size();
        HashSet<TableIdentifier> hashSet = new HashSet<TableIdentifier>(n4);
        CallerInfo callerInfo = new CallerInfo(){};
        for (int i = 0; i < n4; ++i) {
            TableIdentifier tableIdentifier;
            ResultSet resultSet;
            block27: {
                block26: {
                    block25: {
                        resultSet = null;
                        tableIdentifier = list2.get(i);
                        try {
                            if (!hashSet.contains(tableIdentifier)) break block25;
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeResult(resultSet);
                            hashSet.add(tableIdentifier);
                            throw throwable;
                        }
                        JdbcUtils.closeResult(resultSet);
                        hashSet.add(tableIdentifier);
                        continue;
                    }
                    String string9 = tableSelectBuilder.getSelectForCount(tableIdentifier);
                    String string10 = ResourceMgr.getFormattedString("MsgCalculatingRowCount", tableIdentifier.getTableExpression(), i + 1, n4);
                    if (this.rowMonitor != null) {
                        this.rowMonitor.setCurrentObject(string10, i + 1, n4);
                    }
                    if (Settings.getInstance().getLogAllStatements()) {
                        LogMgr.logInfo(callerInfo, "Retrieving rowcount using:\n" + string9);
                    } else {
                        LogMgr.logDebug(callerInfo, "Retrieving rowcount using:\n" + string9);
                    }
                    resultSet = JdbcUtils.runQuery(this.currentConnection, this.currentStatement, string9, bl3);
                    if (!this.isCancelled) break block26;
                    JdbcUtils.closeResult(resultSet);
                    hashSet.add(tableIdentifier);
                    break;
                }
                long l = -1L;
                if (resultSet != null && resultSet.next()) {
                    l = resultSet.getLong(1);
                }
                if (!bl && l <= 0L) break block27;
                int n5 = dataStore.addRow();
                dataStore.setValue(n5, 0, (Object)l);
                dataStore.setValue(n5, 1, (Object)tableIdentifier.getTableName());
                if (bl4) {
                    dataStore.setValue(n5, n, (Object)tableIdentifier.getObjectType());
                }
                if (bl6) {
                    dataStore.setValue(n5, n2, (Object)tableIdentifier.getCatalog());
                }
                if (!bl5) break block27;
                dataStore.setValue(n5, n3, (Object)tableIdentifier.getSchema());
            }
            JdbcUtils.closeResult(resultSet);
            hashSet.add(tableIdentifier);
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.jobFinished();
        }
        if ((sortDefinition = WbRowCount.getRowCountSort(string4, dataStore, this.currentConnection)).hasColumns()) {
            dataStore.sort(sortDefinition);
        }
        dataStore.setResultName(VERB);
        dataStore.setGeneratingSql(string);
        dataStore.resetStatus();
        statementRunnerResult.addDataStore(dataStore);
        return statementRunnerResult;
    }

    public static String getDefaultSortConfig() {
        return Settings.getInstance().getProperty("workbench.sql.wbrowcount.sortdef", "name;a").toLowerCase();
    }

    public static SortDefinition getDefaultRowCountSort(DataStore dataStore, WbConnection wbConnection) {
        return WbRowCount.getRowCountSort(WbRowCount.getDefaultSortConfig(), dataStore, wbConnection);
    }

    public static SortDefinition getRowCountSort(String string, DataStore dataStore, WbConnection wbConnection) {
        if (string == null) {
            return new SortDefinition();
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        String string2 = string.replace("rowcount", dataStore.getColumnName(0).toLowerCase());
        String string3 = dbMetadata.getSchemaTerm().toLowerCase();
        string2 = string2.replace("schema", string3);
        String string4 = dbMetadata.getCatalogTerm().toLowerCase();
        string2 = string2.replace("catalog", string4);
        NamedSortDefinition namedSortDefinition = NamedSortDefinition.parseDefinitionString(string2);
        return namedSortDefinition.getSortDefinition(dataStore);
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }

    @Override
    public boolean shouldEndTransaction() {
        return true;
    }
}

