/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.oracle.OracleUtils;
import workbench.db.report.SchemaReporter;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;
import workbench.sql.wbcommands.WbXslt;
import workbench.storage.RowActionMonitor;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.XsltTransformer;

public class WbSchemaReport
extends SqlCommand
implements RowActionMonitor {
    public static final String ARG_EXCLUDE_TABLES = "excludeTableNames";
    public static final String ARG_EXCLUDE_OBJECTS = "excludeObjectNames";
    public static final String ARG_INCLUDE_TABLES = "includeTables";
    public static final String ARG_INCLUDE_PROCS = "includeProcedures";
    public static final String ARG_INCLUDE_PARTITIONS = "includePartitions";
    public static final String ARG_INCLUDE_GRANTS = "includeTableGrants";
    public static final String ARG_INCLUDE_SEQUENCES = "includeSequences";
    public static final String ARG_INCLUDE_TRIGGERS = "includeTriggers";
    public static final String ARG_INCLUDE_VIEWS = "includeViews";
    public static final String ARG_OBJECT_NAMES = "objects";
    public static final String ARG_OBJECT_TYPE_NAMES = "objectTypeNames";
    public static final String ARG_FULL_SOURCE = "writeFullSource";
    public static final String ARG_GENERATE_CONSTRAINT_NAMES = "generateConstraintNames";
    public static final String ALTERNATE_VERB = "WbReport";
    public static final String VERB = "WbSchemaReport";
    private SchemaReporter reporter;
    private int currentTable = 0;

    public WbSchemaReport() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("types", ArgumentType.ObjectTypeArgument);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addDeprecatedArgument("tables", ArgumentType.StringArgument);
        this.cmdLine.addArgument(ARG_OBJECT_NAMES, ArgumentType.TableArgument);
        this.cmdLine.addArgument(ARG_EXCLUDE_OBJECTS, ArgumentType.TableArgument);
        this.cmdLine.addDeprecatedArgument(ARG_EXCLUDE_TABLES, ArgumentType.StringArgument);
        this.cmdLine.addArgument(ARG_OBJECT_TYPE_NAMES, ArgumentType.Repeatable);
        this.cmdLine.addArgument("schemas");
        this.cmdLine.addArgument("reportTitle");
        this.cmdLine.addArgument("useSchemaName", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_GENERATE_CONSTRAINT_NAMES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_VIEWS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_PROCS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_TABLES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_PARTITIONS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_GRANTS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_SEQUENCES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_INCLUDE_TRIGGERS, ArgumentType.BoolArgument);
        WbXslt.addCommonXsltParameters(this.cmdLine);
        this.cmdLine.addArgument(ARG_FULL_SOURCE, ArgumentType.BoolSwitch);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(this.messageLogger);
        this.cmdLine.parse(this.getCommandLine(string));
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, ResourceMgr.getString("ErrSchemaReportWrongParameters"));
            return statementRunnerResult;
        }
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
        if (wbFile == null) {
            statementRunnerResult.addErrorMessage(ResourceMgr.getString("ErrSchemaReportWrongParameters"));
            return statementRunnerResult;
        }
        this.reporter = new SchemaReporter(this.currentConnection);
        boolean bl = this.cmdLine.getBoolean(ARG_INCLUDE_VIEWS, true);
        boolean bl2 = this.cmdLine.getBoolean(ARG_INCLUDE_SEQUENCES, true);
        boolean bl3 = this.cmdLine.getBoolean(ARG_INCLUDE_TABLES, true);
        String string2 = this.cmdLine.getValue("reportTitle");
        this.reporter.setReportTitle(string2);
        this.reporter.setGenerateConstraintNames(this.cmdLine.getBoolean(ARG_GENERATE_CONSTRAINT_NAMES, false));
        this.reporter.setIncludeProcedures(this.cmdLine.getBoolean(ARG_INCLUDE_PROCS, false));
        this.reporter.setCreateFullObjectSource(this.cmdLine.getBoolean(ARG_FULL_SOURCE, false));
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(this.cmdLine.getListValue("types"));
        String string3 = this.cmdLine.getValue(ARG_OBJECT_NAMES, this.cmdLine.getValue("tables"));
        String string4 = this.cmdLine.getValue(ARG_EXCLUDE_OBJECTS, this.cmdLine.getValue(ARG_EXCLUDE_TABLES));
        String string5 = this.cmdLine.getValue("schemas");
        List<String> list = this.cmdLine.getList(ARG_OBJECT_TYPE_NAMES);
        if (set.isEmpty()) {
            if (bl3) {
                set.addAll(this.currentConnection.getMetadata().getTableTypes());
            }
            if (bl) {
                set.add(this.currentConnection.getMetadata().getViewTypeName());
            }
            if (bl2 && (object6 = this.currentConnection.getMetadata().getSequenceReader()) != null) {
                set.add(object6.getSequenceTypeName());
            }
        }
        object6 = StringUtil.toArray(set, true);
        this.reporter.setIncludeTriggers(this.cmdLine.getBoolean(ARG_INCLUDE_TRIGGERS, true));
        this.reporter.setIncludePartitions(this.cmdLine.getBoolean(ARG_INCLUDE_PARTITIONS, false));
        List<String> list2 = StringUtil.stringToList(string5, ",");
        if (list2.isEmpty()) {
            list2.add(this.currentConnection.getCurrentSchema());
        }
        if (this.rowMonitor != null) {
            this.rowMonitor.setCurrentObject(ResourceMgr.getString("MsgRetrievingTables"), -1L, -1L);
        }
        if (CollectionUtil.isEmpty(list)) {
            for (String object52 : list2) {
                object4 = new SourceTableArgument(string3, string4, object52, (String[])object6, this.currentConnection);
                if (this.isCancelled || (object3 = ((SourceTableArgument)object4).getTables()) == null || object3.size() <= 0) continue;
                this.reporter.setObjectList((List<? extends DbObject>)object3);
            }
        } else {
            for (String iOException : list) {
                object4 = iOException.split(":");
                if (object4 != null && ((String[])object4).length == 2) {
                    object3 = object4[0].toUpperCase();
                    object2 = new String[]{object3};
                    object = object4[1];
                    for (String string6 : list2) {
                        List<TableIdentifier> list3;
                        if (((String)object3).equalsIgnoreCase("procedure")) {
                            this.reporter.setProcedureNames((String)object);
                            continue;
                        }
                        SourceTableArgument sourceTableArgument = new SourceTableArgument((String)object, string4, string6, (String[])object2, this.currentConnection);
                        if (this.isCancelled || (list3 = sourceTableArgument.getTables()) == null || list3.size() <= 0) continue;
                        this.reporter.setObjectList(list3);
                    }
                    continue;
                }
                statementRunnerResult.addWarning(ResourceMgr.getFormattedString("ErrIgnoringArg", iOException, ARG_OBJECT_TYPE_NAMES));
            }
        }
        if (this.isCancelled) {
            statementRunnerResult.addWarningByKey("MsgStatementCancelled");
            return statementRunnerResult;
        }
        this.reporter.setSchemas(list2);
        String string7 = this.cmdLine.getValue("useschemaname");
        this.reporter.setSchemaNameToUse(string7);
        this.reporter.setProgressMonitor(this);
        if (this.rowMonitor != null) {
            this.rowMonitor.setMonitorType(6);
        }
        this.reporter.setIncludeGrants(this.cmdLine.getBoolean(ARG_INCLUDE_GRANTS, false));
        if (this.currentConnection != null) {
            if (this.currentConnection.getMetadata().isOracle() && !OracleUtils.remarksEnabled(this.currentConnection)) {
                statementRunnerResult.addMessageByKey("MsgSchemaReporterOracleRemarksWarning");
                statementRunnerResult.addMessageNewLine();
            }
            if (this.currentConnection.getMetadata().isMySql() && !OracleUtils.remarksEnabledMySQL(this.currentConnection)) {
                statementRunnerResult.addMessageByKey("MsgSchemaReporterMySQLRemarksWarning");
                statementRunnerResult.addMessageNewLine();
            }
        }
        this.reporter.retrieveProcedures();
        if (this.reporter.getObjectCount() == 0) {
            statementRunnerResult.addErrorMessageByKey("ErrNoTablesFound");
            return statementRunnerResult;
        }
        this.currentTable = 0;
        this.reporter.setOutputFilename(wbFile.getFullPath());
        try {
            this.reporter.writeXml();
        }
        catch (IOException iOException) {
            statementRunnerResult.addErrorMessage(iOException.getMessage());
        }
        WbFile wbFile2 = this.findXsltFile(this.cmdLine.getValue("stylesheet"));
        object4 = this.evaluateFileArgument(this.cmdLine.getValue("xsltOutput"));
        if (statementRunnerResult.isSuccess()) {
            statementRunnerResult.addMessageByKey("MsgSchemaReportTablesWritten", this.currentTable, wbFile.getFullPath());
            statementRunnerResult.setSuccess();
        }
        if (wbFile2 != null && object4 != null) {
            object3 = new XsltTransformer();
            object2 = WbXslt.getParameters(this.cmdLine);
            try {
                ((XsltTransformer)object3).setXsltBaseDir(this.getXsltBaseDir());
                ((XsltTransformer)object3).transform(wbFile, (File)object4, wbFile2, (Map<String, String>)object2);
                object = ((XsltTransformer)object3).getAllOutputs();
                if (((String)object).length() != 0) {
                    statementRunnerResult.addMessage((CharSequence)object);
                    statementRunnerResult.addMessageNewLine();
                }
                statementRunnerResult.addMessageByKey("MsgXsltSuccessful", object4);
                statementRunnerResult.setSuccess();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogMgr.logError(new CallerInfo(){}, "Stylesheet " + wbFile2 + " not found!", fileNotFoundException);
                statementRunnerResult.addErrorMessageByKey("ErrXsltNotFound", wbFile2.toString());
            }
            catch (Exception exception) {
                String string8 = ((XsltTransformer)object3).getAllOutputs(exception);
                LogMgr.logError(new CallerInfo(){}, "Error when transforming '" + wbFile.getFullPath() + "' to '" + object4 + "' using " + wbFile2, exception);
                LogMgr.logError(new CallerInfo(){}, string8, null);
                statementRunnerResult.addErrorMessage(string8);
            }
        }
        return statementRunnerResult;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.reporter != null) {
            this.reporter.cancelExecution();
        }
    }

    @Override
    public void setCurrentObject(String string, long l, long l2) {
        if (string == null) {
            this.currentTable = 0;
        } else {
            ++this.currentTable;
            if (this.rowMonitor != null) {
                if (l > 0L) {
                    this.rowMonitor.setCurrentObject(string, l, l2);
                } else if (this.rowMonitor instanceof ScriptGenerationMonitor) {
                    ((ScriptGenerationMonitor)((Object)this.rowMonitor)).setCurrentObject(string, (int)l, (int)l2);
                }
            }
        }
    }

    @Override
    public String getAlternateVerb() {
        return ALTERNATE_VERB;
    }

    @Override
    public void setCurrentRow(long l, long l2) {
    }

    @Override
    public int getMonitorType() {
        return 7;
    }

    @Override
    public void setMonitorType(int n) {
    }

    @Override
    public void jobFinished() {
    }

    @Override
    public void saveCurrentType(String string) {
    }

    @Override
    public void restoreType(String string) {
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

