/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.SourceTableArgument;

public class WbTableSource
extends SqlCommand {
    public static final String VERB = "WbTableSource";

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        SourceTableArgument sourceTableArgument = new SourceTableArgument(string2, this.currentConnection);
        List<TableIdentifier> list = sourceTableArgument.getTables();
        List<String> list2 = sourceTableArgument.getMissingTables();
        if (list2.size() > 0) {
            for (String object : list2) {
                statementRunnerResult.addWarning(ResourceMgr.getFormattedString("ErrTableNotFound", object));
            }
            statementRunnerResult.addMessageNewLine();
            if (list.isEmpty()) {
                statementRunnerResult.setFailure();
                return statementRunnerResult;
            }
        }
        for (TableIdentifier tableIdentifier : list) {
            TableDefinition tableDefinition = this.currentConnection.getMetadata().getTableDefinition(tableIdentifier);
            TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.currentConnection);
            String string3 = tableSourceBuilder.getTableSource(tableDefinition.getTable(), tableDefinition.getColumns());
            if (string3 == null) continue;
            statementRunnerResult.addMessage(string3);
        }
        statementRunnerResult.setSuccess();
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

