/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionProfile;
import workbench.db.DeleteScriptGenerator;
import workbench.db.JdbcUtils;
import workbench.db.QuoteHandler;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.postgres.HstoreSupport;
import workbench.gui.WbSwingUtilities;
import workbench.interfaces.JobErrorHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.annotations.ResultNameAnnotation;
import workbench.storage.ColumnData;
import workbench.storage.DataConverter;
import workbench.storage.DmlStatement;
import workbench.storage.RefCursorConsumer;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.RowDataList;
import workbench.storage.RowDataListSorter;
import workbench.storage.SortDefinition;
import workbench.storage.SourceTableDetector;
import workbench.storage.SqlLiteralFormatter;
import workbench.storage.StatementFactory;
import workbench.storage.UpdateTableDetector;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.FilterExpression;
import workbench.storage.reader.ResultSetHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.Alias;
import workbench.util.CollectionUtil;
import workbench.util.ConverterException;
import workbench.util.ExceptionUtil;
import workbench.util.LowMemoryException;
import workbench.util.MemoryWatcher;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;

public class DataStore
implements RowDataContainer {
    private RowActionMonitor rowActionMonitor;
    private boolean modified;
    private RowDataList data;
    private RowDataList deletedRows;
    private RowDataList filteredRows;
    private String sql;
    private ColumnExpression generatingFilter;
    private ResultInfo resultInfo;
    private TableIdentifier updateTable;
    private TableIdentifier updateTableToBeUsed;
    private WbConnection originalConnection;
    private boolean allowUpdates;
    private boolean updateHadErrors;
    private boolean cancelRetrieve;
    private boolean cancelUpdate;
    private List<ColumnIdentifier> missingPkcolumns;
    private int currentUpdateRow;
    private int currentInsertRow;
    private int currentDeleteRow;
    private Statement currentDelete;
    private DmlStatement currentDml;
    private boolean trimCharData;
    private boolean hasGeneratedKeys;
    private long loadedAt;
    protected boolean useNaturalSort;
    private SortDefinition lastSort;
    private String resultName;
    private boolean ignoreAllUpdateErrors = false;

    public DataStore(String[] stringArray, int[] nArray) {
        this(stringArray, nArray, null);
    }

    public DataStore(String[] stringArray, int[] nArray, int[] nArray2) {
        this.data = this.createData();
        this.resultInfo = new ResultInfo(stringArray, nArray, nArray2);
        this.checkForGeneratedKeys();
        this.setLoadTimeToNow();
    }

    public DataStore(ResultSet resultSet, WbConnection wbConnection) throws SQLException {
        if (resultSet == null) {
            return;
        }
        this.setOriginalConnection(wbConnection);
        this.initData(resultSet);
    }

    public DataStore(ResultInfo resultInfo) {
        this.resultInfo = resultInfo;
        this.data = this.createData();
        this.checkForGeneratedKeys();
    }

    private void checkForGeneratedKeys() {
        this.hasGeneratedKeys = false;
        if (this.resultInfo == null) {
            return;
        }
        for (int i = 0; i < this.resultInfo.getColumnCount(); ++i) {
            if (!this.resultInfo.getColumn(i).isAutoGenerated()) continue;
            this.hasGeneratedKeys = true;
            break;
        }
    }

    public DataStore(ResultSet resultSet) throws SQLException {
        this(resultSet, false);
    }

    public DataStore(ResultSet resultSet, boolean bl) throws SQLException {
        this(resultSet, bl, null, -1, null);
    }

    public DataStore(ResultSet resultSet, WbConnection wbConnection, boolean bl) throws SQLException {
        this(resultSet, bl, null, -1, wbConnection);
    }

    public DataStore(ResultSet resultSet, boolean bl, int n) throws SQLException {
        this(resultSet, bl, null, n, null);
    }

    public DataStore(ResultSet resultSet, boolean bl, RowActionMonitor rowActionMonitor) throws SQLException {
        this(resultSet, bl, rowActionMonitor, -1, null);
    }

    public DataStore(ResultSet resultSet, boolean bl, RowActionMonitor rowActionMonitor, int n, WbConnection wbConnection) throws SQLException {
        this.rowActionMonitor = rowActionMonitor;
        this.setOriginalConnection(wbConnection);
        if (bl) {
            this.initData(resultSet, n);
            this.cancelRetrieve = false;
        } else {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            this.initMetaData(resultSetMetaData);
            this.data = this.createData();
        }
    }

    public DataStore(ResultSetMetaData resultSetMetaData, WbConnection wbConnection) throws SQLException {
        this.setOriginalConnection(wbConnection);
        this.initMetaData(resultSetMetaData);
        this.data = this.createData();
    }

    public void addColumn(ColumnIdentifier columnIdentifier) {
        this.resultInfo.addColumn(columnIdentifier);
        this.addColumn(-1, this.data, this.filteredRows, this.deletedRows);
    }

    public void addColumnAt(ColumnIdentifier columnIdentifier, int n) {
        this.resultInfo.addColumnAt(columnIdentifier, n);
        this.addColumn(n, this.data, this.filteredRows, this.deletedRows);
    }

    private void addColumn(int n, RowDataList ... rowDataListArray) {
        if (rowDataListArray == null) {
            return;
        }
        for (RowDataList rowDataList : rowDataListArray) {
            if (rowDataList == null) continue;
            if (n == -1) {
                rowDataList.addColumn();
                continue;
            }
            rowDataList.addColumn(n);
        }
    }

    public void setTrimCharData(boolean bl) {
        this.trimCharData = bl;
    }

    @Override
    public WbConnection getOriginalConnection() {
        return this.originalConnection;
    }

    public void setOriginalConnection(WbConnection wbConnection) {
        ConnectionProfile connectionProfile;
        this.originalConnection = wbConnection;
        if (this.originalConnection != null && (connectionProfile = this.originalConnection.getProfile()) != null) {
            this.trimCharData = connectionProfile.getTrimCharData();
        }
    }

    public void setUseNaturalSort(boolean bl) {
        this.useNaturalSort = bl;
    }

    public void setColumnSizes(int[] nArray) {
        if (this.resultInfo == null) {
            return;
        }
        this.resultInfo.setColumnSizes(nArray);
    }

    public void setAllowUpdates(boolean bl) {
        this.allowUpdates = bl;
    }

    private RowDataList createData(int n) {
        return new RowDataList(n);
    }

    private RowDataList createData() {
        return new RowDataList();
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String string) {
        this.resultName = string;
    }

    public void copyFrom(DataStore dataStore) {
        if (dataStore == null) {
            return;
        }
        if (dataStore.getRowCount() == 0) {
            return;
        }
        if (dataStore.getColumnCount() != this.getColumnCount()) {
            return;
        }
        int n = dataStore.getRowCount();
        for (int i = 0; i < n; ++i) {
            RowData rowData = dataStore.getRow(i);
            this.addRow(rowData);
        }
    }

    public DataStore createCopy(boolean bl) {
        DataStore dataStore = new DataStore(this.resultInfo.createCopy());
        if (bl) {
            dataStore.copyFrom(this);
        }
        return dataStore;
    }

    public int duplicateRow(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return -1;
        }
        RowData rowData = this.getRow(n);
        RowData rowData2 = rowData.createCopy();
        int n2 = n + 1;
        if (n2 >= this.getRowCount()) {
            n2 = this.getRowCount();
        }
        this.data.add(n2, rowData2);
        this.modified = true;
        return n2;
    }

    public int getFilteredCount() {
        if (this.filteredRows == null) {
            return 0;
        }
        return this.filteredRows.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.resultInfo.getColumnCount();
    }

    public int getModifiedCount() {
        int n;
        if (!this.isModified()) {
            return 0;
        }
        int n2 = this.getRowCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!this.isRowModified(n)) continue;
            ++n3;
        }
        if (this.deletedRows != null) {
            n2 = this.deletedRows.size();
            for (n = 0; n < n2; ++n) {
                RowData rowData = this.deletedRows.get(n);
                if (rowData.isNew()) continue;
                ++n3;
            }
        }
        return n3;
    }

    public String getDbmsType(int n) throws IndexOutOfBoundsException {
        return this.resultInfo.getDbmsTypeName(n);
    }

    public int getColumnType(int n) throws IndexOutOfBoundsException {
        return this.resultInfo.getColumnType(n);
    }

    public String getColumnClassName(int n) {
        Class clazz;
        String string;
        int n2;
        DataConverter dataConverter = RowDataReader.getConverterInstance(this.originalConnection);
        if (dataConverter != null && dataConverter.convertsType(n2 = this.resultInfo.getColumnType(n), string = this.resultInfo.getDbmsTypeName(n)) && (clazz = dataConverter.getConvertedClass(n2, string)) != null) {
            return clazz.getName();
        }
        return this.resultInfo.getColumnClassName(n);
    }

    public Class getColumnClass(int n) {
        String string;
        int n2;
        DataConverter dataConverter = RowDataReader.getConverterInstance(this.originalConnection);
        if (dataConverter != null && dataConverter.convertsType(n2 = this.resultInfo.getColumnType(n), string = this.resultInfo.getDbmsTypeName(n))) {
            return dataConverter.getConvertedClass(n2, string);
        }
        return this.resultInfo.getColumnClass(n);
    }

    public void applyFilter(FilterExpression filterExpression) {
        this.clearFilter();
        int n = this.getColumnCount();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(n);
        this.filteredRows = this.createData();
        int n2 = this.getRowCount();
        for (int i = n2 - 1; i >= 0; --i) {
            RowData rowData = this.getRow(i);
            for (int j = 0; j < n; ++j) {
                String string = this.getColumnName(j);
                Object object = rowData.getValue(j);
                hashMap.put(string.toLowerCase(), object);
            }
            if (filterExpression.evaluate(hashMap)) continue;
            this.data.remove(i);
            this.filteredRows.add(rowData);
        }
        if (this.filteredRows.size() == 0) {
            this.filteredRows = null;
        }
    }

    public void clearFilter() {
        if (this.filteredRows == null) {
            return;
        }
        int n = this.filteredRows.size();
        for (int i = 0; i < n; ++i) {
            RowData rowData = this.filteredRows.get(i);
            this.data.add(rowData);
        }
        this.filteredRows.clear();
        this.filteredRows = null;
    }

    public void deleteRow(int n) throws IndexOutOfBoundsException {
        RowData rowData = this.data.get(n);
        if (rowData.isNew()) {
            this.data.remove(n);
        } else {
            if (this.deletedRows == null) {
                this.deletedRows = this.createData();
            }
            this.deletedRows.add(rowData);
            this.data.remove(n);
            this.modified = true;
        }
    }

    public void deleteRowWithDependencies(int n) throws IndexOutOfBoundsException, SQLException {
        RowData rowData;
        if (this.updateTable == null) {
            this.checkUpdateTable(this.originalConnection);
        }
        if ((rowData = this.data.get(n)) == null) {
            return;
        }
        if (!rowData.isNew()) {
            List<ColumnData> list = this.getPkValues(n, true);
            DeleteScriptGenerator deleteScriptGenerator = new DeleteScriptGenerator(this.originalConnection);
            deleteScriptGenerator.setTable(this.updateTable);
            List<String> list2 = deleteScriptGenerator.getStatementsForValues(list, false);
            rowData.setDependencyDeletes(list2);
        }
        this.deleteRow(n);
    }

    public int addRow() {
        RowData rowData = new RowData(this.resultInfo);
        this.data.add(rowData);
        this.modified = true;
        return this.getRowCount() - 1;
    }

    public int addRow(RowData rowData) {
        this.data.add(rowData);
        this.modified = true;
        return this.getRowCount() - 1;
    }

    public int insertRowAfter(int n) {
        int n2;
        RowData rowData = new RowData(this.resultInfo);
        if (++n > this.data.size() || n < 0) {
            this.data.add(rowData);
            n2 = this.getRowCount();
        } else {
            this.data.add(n, rowData);
            n2 = n;
        }
        this.modified = true;
        return n2;
    }

    public void setUpdateTableToBeUsed(TableIdentifier tableIdentifier) {
        this.updateTableToBeUsed = tableIdentifier == null ? null : tableIdentifier.createCopy();
    }

    public void setUpdateTable(String string, WbConnection wbConnection) {
        if (StringUtil.isEmptyString(string)) {
            this.setUpdateTable((TableIdentifier)null, wbConnection);
        } else {
            TableIdentifier tableIdentifier = new TableIdentifier(string, wbConnection);
            tableIdentifier.setPreserveQuotes(true);
            this.setUpdateTable(tableIdentifier, wbConnection);
        }
    }

    public List<ColumnIdentifier> getMissingPkColumns() {
        return this.missingPkcolumns;
    }

    public boolean pkColumnsComplete() {
        return CollectionUtil.isEmpty(this.missingPkcolumns);
    }

    public void setUpdateTable(TableIdentifier tableIdentifier) {
        this.setUpdateTable(tableIdentifier, this.originalConnection);
    }

    public void forceUpdateTable(TableIdentifier tableIdentifier) {
        this.updateTable = tableIdentifier == null ? null : tableIdentifier.createCopy();
    }

    public void setUpdateTable(TableIdentifier tableIdentifier, WbConnection wbConnection) {
        if (wbConnection == null || tableIdentifier != null && TableIdentifier.compareNames(tableIdentifier, this.updateTable, true)) {
            return;
        }
        this.updateTable = null;
        this.resultInfo.setUpdateTable(null);
        this.missingPkcolumns = null;
        if (tableIdentifier == null) {
            return;
        }
        SourceTableDetector sourceTableDetector = new SourceTableDetector();
        sourceTableDetector.checkColumnTables(this.sql, this.resultInfo, wbConnection);
        UpdateTableDetector updateTableDetector = new UpdateTableDetector(wbConnection);
        updateTableDetector.setCheckPKOnly(wbConnection.getDbSettings().getUpdateTableCheckPkOnly());
        updateTableDetector.checkUpdateTable(tableIdentifier, this.resultInfo);
        this.updateTable = updateTableDetector.getUpdateTable();
        this.missingPkcolumns = updateTableDetector.getMissingPkColumns();
        this.checkForGeneratedKeys();
        this.restoreModifiedNotUpdateableColumns();
    }

    public void setUpdateTable(TableDefinition tableDefinition) {
        this.missingPkcolumns = new ArrayList<ColumnIdentifier>(0);
        if (tableDefinition == null) {
            this.updateTable = null;
            this.resultInfo.setUpdateTable(null);
            return;
        }
        this.updateTable = tableDefinition.getTable();
        this.resultInfo.setUpdateTable(this.updateTable);
        UpdateTableDetector updateTableDetector = new UpdateTableDetector(this.originalConnection);
        List<ColumnIdentifier> list = tableDefinition.getColumns();
        for (ColumnIdentifier columnIdentifier : list) {
            int n = this.findColumn(columnIdentifier.getColumnName());
            if (n > -1) {
                updateTableDetector.syncResultColumn(n, columnIdentifier, this.resultInfo);
                continue;
            }
            LogMgr.logError(new CallerInfo(){}, "Could not find column " + columnIdentifier + " from table definition in ResultInfo!", null);
        }
        this.checkForGeneratedKeys();
    }

    private boolean columnBelongsToUpdateTable(int n) {
        if (this.updateTable == null) {
            return true;
        }
        if (!this.resultInfo.isColumnTableDetected()) {
            return true;
        }
        String string = this.resultInfo.getColumn(n).getSourceTableName();
        if (StringUtil.isEmptyString(string)) {
            return true;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(string);
        return TableIdentifier.compareNames(tableIdentifier, this.updateTable, true);
    }

    private void restoreModifiedNotUpdateableColumns() {
        if (!Settings.getInstance().getCheckEditableColumns()) {
            return;
        }
        if (this.resultInfo.getUpdateTable() == null) {
            return;
        }
        String string = this.resultInfo.getUpdateTable().getTableExpression();
        CallerInfo callerInfo = new CallerInfo(){};
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isRowModified(i)) continue;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                boolean bl;
                String string2 = this.resultInfo.getColumnName(j);
                boolean bl2 = bl = this.resultInfo.isUpdateable(j) && !this.resultInfo.getColumn(j).isReadonly();
                if (!bl && this.isColumnModified(i, j)) {
                    boolean bl3 = this.resultInfo.getColumn(j).getComputedColumnExpression() != null;
                    LogMgr.logWarning(callerInfo, "Restoring original value for column " + string + "." + string2 + " because column is marked as not updateable. (isUpdateable: " + this.resultInfo.isUpdateable(j) + ", isReadonly: " + this.resultInfo.getColumn(j).isReadonly() + ", isComputed: " + bl3 + ")");
                    this.getRow(i).restoreOriginalValue(j);
                    continue;
                }
                if (this.columnBelongsToUpdateTable(j)) continue;
                String string3 = this.resultInfo.getColumn(j).getSourceTableName();
                LogMgr.logWarning(callerInfo, "Restoring original value for column " + string3 + "." + string2 + " because column does not belong to the detected update table: " + string);
                this.getRow(i).restoreOriginalValue(j);
            }
        }
    }

    @Override
    public TableIdentifier getUpdateTable() {
        if (this.updateTable == null) {
            return null;
        }
        return this.updateTable.createCopy();
    }

    public ColumnIdentifier getColumn(int n) {
        return this.resultInfo.getColumn(n);
    }

    public String getColumnName(int n) throws IndexOutOfBoundsException {
        return this.resultInfo.getColumnName(n);
    }

    public String getColumnDisplayName(int n) {
        return this.resultInfo.getColumnDisplayName(n);
    }

    public int getColumnSize(int n) throws IndexOutOfBoundsException {
        return this.resultInfo.getColumn(n).getColumnSize();
    }

    public int getColumnDisplaySize(int n) throws IndexOutOfBoundsException {
        return this.resultInfo.getColumn(n).getDisplaySize();
    }

    public Object getOriginalValue(int n, int n2) {
        RowData rowData = this.getRow(n);
        return rowData.getOriginalValue(n2);
    }

    public Object getValue(int n, int n2) throws IndexOutOfBoundsException {
        RowData rowData = this.getRow(n);
        return rowData.getValue(n2);
    }

    public Object getValue(int n, String string) throws IndexOutOfBoundsException {
        int n2 = this.findColumn(string);
        RowData rowData = this.getRow(n);
        return rowData.getValue(n2);
    }

    public String getValueAsString(int n, String string) throws IndexOutOfBoundsException {
        return this.getValueAsString(n, this.findColumn(string));
    }

    public String getValueAsString(int n, int n2) throws IndexOutOfBoundsException {
        Object object = this.getValue(n, n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            try {
                Clob clob = (Clob)object;
                long l = clob.length();
                return clob.getSubString(1L, (int)l);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error converting BLOB to String", exception);
                return null;
            }
        }
        if (object instanceof Map && "hstore".equalsIgnoreCase(this.getDbmsType(n2))) {
            return HstoreSupport.getDisplay((Map)object);
        }
        return object.toString();
    }

    public int getValueAsInt(int n, int n2, int n3) {
        Object object = this.getValue(n, n2);
        if (object == null) {
            return n3;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return StringUtil.getIntValue(object.toString(), n3);
    }

    public long getValueAsLong(int n, int n2, long l) {
        Object object = this.getValue(n, n2);
        if (object == null) {
            return l;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return StringUtil.getLongValue(object.toString(), l);
    }

    public void setInputValue(int n, int n2, Object object) throws ConverterException {
        Object object2 = this.convertCellValue(object, n2);
        this.setValue(n, n2, object2);
    }

    public void setValue(int n, String string, Object object) throws IndexOutOfBoundsException {
        int n2 = this.findColumn(string);
        if (n2 > -1) {
            this.setValue(n, n2, object);
        }
    }

    public void setValue(int n, int n2, Object object) throws IndexOutOfBoundsException {
        Object object2;
        boolean bl;
        if (this.resultInfo.getColumnName(n2) == null) {
            return;
        }
        boolean bl2 = bl = Settings.getInstance().getCheckEditableColumns() && this.resultInfo.getUpdateTable() != null;
        if (bl) {
            object2 = this.resultInfo.getUpdateTable().getTableName();
            String string = this.resultInfo.getColumnName(n2);
            if (!this.resultInfo.isUpdateable(n2) || this.resultInfo.getColumn(n2).isReadonly()) {
                boolean bl3 = this.resultInfo.getColumn(n2).getComputedColumnExpression() != null;
                LogMgr.logWarning(new CallerInfo(){}, "Discarding new value for column " + (String)object2 + "." + string + " because column is marked as not updateable. (isUpdateable: " + this.resultInfo.isUpdateable(n2) + ", isReadonly: " + this.resultInfo.getColumn(n2).isReadonly() + ", isComputed: " + bl3 + ")");
                return;
            }
            if (!this.columnBelongsToUpdateTable(n2)) {
                LogMgr.logWarning(new CallerInfo(){}, "Restoring original value for column " + (String)object2 + "." + string + " because column does not belong to the detected update table: " + this.updateTable.getTableExpression());
                return;
            }
        }
        if ((object2 = this.getRow(n)) == null) {
            LogMgr.logError(new CallerInfo(){}, "Could not find specified row!", new Exception("Invalid row specified"));
            return;
        }
        ((RowData)object2).setValue(n2, object);
        this.modified = ((RowData)object2).isModified();
    }

    public int getColumnIndex(String string) {
        return this.findColumn(string);
    }

    public boolean isRowModified(int n) {
        RowData rowData = this.getRow(n);
        return rowData.isModified();
    }

    public boolean isColumnModified(int n, int n2) {
        RowData rowData = this.getRow(n);
        return rowData.isColumnModified(n2);
    }

    public Object restoreColumnValue(int n, int n2) {
        RowData rowData = this.getRow(n);
        if (rowData != null) {
            return rowData.restoreOriginalValue(n2);
        }
        return null;
    }

    public boolean restoreOriginalValues() {
        RowData rowData;
        int n;
        int n2 = 0;
        if (this.deletedRows != null) {
            n2 = this.deletedRows.size();
            for (n = 0; n < this.deletedRows.size(); ++n) {
                rowData = this.deletedRows.get(n);
                this.data.add(rowData);
            }
            this.deletedRows = null;
        }
        for (n = 0; n < this.data.size(); ++n) {
            rowData = this.getRow(n);
            boolean bl = rowData.restoreOriginalValues();
            if (!bl) continue;
            ++n2;
        }
        this.resetStatus();
        return n2 > 0;
    }

    public void reset() {
        this.data.reset();
        if (this.deletedRows != null) {
            this.deletedRows.clear();
            this.deletedRows = null;
        }
        if (this.filteredRows != null) {
            this.filteredRows.clear();
            this.filteredRows = null;
        }
        this.modified = false;
    }

    public boolean hasUpdateableColumns() {
        return this.resultInfo.hasUpdateableColumns();
    }

    public boolean hasUpdatedRows() {
        if (!this.isModified()) {
            return false;
        }
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            RowData rowData = this.getRow(i);
            if (!rowData.isModified() || rowData.isNew()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeletedRows() {
        return this.deletedRows != null && this.deletedRows.size() > 0;
    }

    public boolean needPkForUpdate() {
        if (!this.isModified()) {
            return false;
        }
        return this.hasDeletedRows() || this.hasUpdatedRows();
    }

    public boolean isFiltered() {
        return this.filteredRows != null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isUpdateable() {
        if (this.allowUpdates) {
            return true;
        }
        return this.updateTable != null && this.hasUpdateableColumns();
    }

    private int findColumn(String string) {
        return this.resultInfo.findColumn(string, this.originalConnection != null ? this.originalConnection.getMetadata() : QuoteHandler.STANDARD_HANDLER);
    }

    public Map<String, Object> getRowData(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.getColumnCount());
        for (int i = 0; i < this.resultInfo.getColumnCount(); ++i) {
            hashMap.put(this.getColumnName(i), this.getValue(n, i));
        }
        return hashMap;
    }

    @Override
    public RowData getRow(int n) throws IndexOutOfBoundsException {
        return this.data.get(n);
    }

    private void initMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.resultInfo = new ResultInfo(resultSetMetaData, this.originalConnection);
        this.checkForGeneratedKeys();
    }

    public final void initData(ResultSet resultSet) throws SQLException {
        this.initData(resultSet, -1);
    }

    public void setLoadTimeToNow() {
        this.loadedAt = System.currentTimeMillis();
    }

    public int fetchOnly(ResultSet resultSet) throws SQLException {
        return this.initData(resultSet, 0, false, null);
    }

    public void initData(ResultSet resultSet, int n) throws SQLException {
        this.initData(resultSet, n, true, null);
    }

    public void initData(ResultSet resultSet, int n, RefCursorConsumer refCursorConsumer) throws SQLException {
        this.initData(resultSet, n, true, refCursorConsumer);
    }

    protected int initData(ResultSet resultSet, int n, boolean bl, RefCursorConsumer refCursorConsumer) throws SQLException {
        int n2;
        boolean bl2;
        block18: {
            if (this.resultInfo == null) {
                try {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    this.initMetaData(resultSetMetaData);
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Error while retrieving ResultSetMetaData", sQLException);
                    throw sQLException;
                }
            }
            if (this.rowActionMonitor != null) {
                this.rowActionMonitor.setMonitorType(2);
            }
            this.setLoadTimeToNow();
            this.cancelRetrieve = false;
            bl2 = false;
            n2 = 0;
            int n3 = Settings.getInstance().getIntProperty("workbench.gui.data.reportinterval", 10);
            int n4 = Settings.getInstance().getLowMemoryCheckInterval();
            if (bl && this.data == null) {
                this.data = this.createData();
            }
            CallerInfo callerInfo = new CallerInfo(){};
            try {
                RowDataReader rowDataReader = RowDataReaderFactory.createReader(this.resultInfo, this.originalConnection);
                rowDataReader.setRefCursorConsumer(refCursorConsumer);
                if (bl) {
                    rowDataReader.setUseStreamsForBlobs(false);
                    rowDataReader.setUseStreamsForClobs(false);
                }
                ResultSetHolder resultSetHolder = new ResultSetHolder(resultSet);
                while (!this.cancelRetrieve && resultSet.next()) {
                    if (this.rowActionMonitor != null && ++n2 % n3 == 0) {
                        this.rowActionMonitor.setCurrentRow(n2, -1L);
                    }
                    if (bl) {
                        RowData rowData = rowDataReader.read(resultSetHolder, this.trimCharData);
                        this.data.add(rowData);
                    }
                    if (n > 0 && n2 > n) break;
                    if (!bl || n2 % n4 != 0 || !MemoryWatcher.isMemoryLow(false)) continue;
                    LogMgr.logError(callerInfo, "Memory is running low. Aborting reading...", null);
                    bl2 = true;
                    break;
                }
                this.cancelRetrieve = false;
            }
            catch (SQLException sQLException) {
                if (this.cancelRetrieve) {
                    LogMgr.logInfo(callerInfo, "Retrieve cancelled");
                    break block18;
                }
                LogMgr.logError(callerInfo, "SQL Error during retrieve", sQLException);
                throw sQLException;
            }
            catch (Exception exception) {
                this.cancelRetrieve = false;
                LogMgr.logError(callerInfo, "Error during retrieve", exception);
                throw new SQLException(ExceptionUtil.getDisplay(exception));
            }
            finally {
                this.modified = false;
            }
        }
        if (bl2) {
            throw new LowMemoryException();
        }
        return n2;
    }

    public long getLoadedAt() {
        return this.loadedAt;
    }

    public void setGeneratingSql(String string) {
        this.sql = string;
        ResultNameAnnotation resultNameAnnotation = new ResultNameAnnotation();
        if (this.resultName == null) {
            String string2 = resultNameAnnotation.getResultName(this.sql);
            if (string2 == null && GuiSettings.getUseTablenameAsResultName()) {
                String string3 = SqlUtil.getSqlVerb(this.sql);
                if (string3.toLowerCase().startsWith("explain")) {
                    string2 = "Execution plan";
                } else {
                    List<Alias> list = SqlUtil.getTables(string, false, this.originalConnection);
                    if (list.size() > 0) {
                        string2 = list.get(0).getObjectName();
                    }
                }
            }
            this.setResultName(string2);
        }
    }

    public void setGeneratingFilter(ColumnExpression columnExpression) {
        this.generatingFilter = columnExpression;
    }

    public ColumnExpression getGeneratingFilter() {
        return this.generatingFilter;
    }

    public String getGeneratingSql() {
        return this.sql;
    }

    public boolean checkUpdateTable() {
        return this.checkUpdateTable(this.originalConnection);
    }

    public boolean checkUpdateTable(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (this.updateTableToBeUsed != null) {
            TableIdentifier tableIdentifier = this.updateTableToBeUsed;
            this.updateTableToBeUsed = null;
            this.setUpdateTable(tableIdentifier, wbConnection);
        } else if (this.updateTable == null) {
            if (this.sql == null) {
                return false;
            }
            List<Alias> list = SqlUtil.getTables(this.sql, false, wbConnection);
            if (list.size() != 1) {
                LogMgr.logWarning(new CallerInfo(){}, "More than one table found in the original query. No update table will be set.");
                return false;
            }
            String string = list.get(0).getObjectName();
            LogMgr.logDebug(new CallerInfo(){}, "Using table name: " + string);
            this.setUpdateTable(string, wbConnection);
        }
        return this.updateTable != null;
    }

    public String getInsertTable() {
        if (this.updateTable != null) {
            return this.updateTable.getTableExpression();
        }
        if (this.updateTableToBeUsed != null) {
            return this.updateTableToBeUsed.getTableExpression();
        }
        if (this.sql == null) {
            return null;
        }
        if (!this.sqlHasUpdateTable()) {
            return null;
        }
        List<Alias> list = SqlUtil.getTables(this.sql, false, this.originalConnection);
        if (list.size() != 1) {
            return null;
        }
        String string = list.get(0).getObjectName();
        return string;
    }

    public boolean canSaveAsSqlInsert() {
        return this.getInsertTable() != null;
    }

    private SqlLiteralFormatter createLiteralFormatter() {
        return new SqlLiteralFormatter(this.originalConnection);
    }

    public boolean sqlHasUpdateTable() {
        if (this.updateTable != null) {
            return true;
        }
        if (this.sql == null) {
            return false;
        }
        List<Alias> list = SqlUtil.getTables(this.sql, false, this.originalConnection);
        return list.size() == 1;
    }

    public void setRowNull(int n) {
        for (int i = 0; i < this.resultInfo.getColumnCount(); ++i) {
            this.setValue(n, i, null);
        }
    }

    public void cancelUpdate() {
        this.cancelUpdate = true;
        if (this.currentDelete != null) {
            try {
                this.currentDelete.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.currentDml != null) {
            this.currentDml.cancel();
        }
    }

    public void cancelRetrieve() {
        this.cancelRetrieve = true;
    }

    public boolean isCancelled() {
        return this.cancelRetrieve;
    }

    public void resetCancelStatus() {
        this.cancelRetrieve = false;
    }

    private void updateProgressMonitor(int n, int n2) {
        if (this.rowActionMonitor != null) {
            this.rowActionMonitor.setCurrentRow(n, n2);
        }
    }

    public List<DmlStatement> getUpdateStatements(WbConnection wbConnection) throws SQLException {
        DmlStatement dmlStatement;
        if (this.updateTable == null) {
            throw new NullPointerException("No update table defined!");
        }
        this.updatePkInformation();
        ArrayList<DmlStatement> arrayList = new ArrayList<DmlStatement>(this.getModifiedCount());
        this.resetUpdateRowCounters();
        StatementFactory statementFactory = new StatementFactory(this.resultInfo, this.originalConnection);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        RowData rowData = this.getNextDeletedRow();
        while (rowData != null) {
            List<String> list = rowData.getDependencyDeletes();
            if (list != null) {
                for (String string2 : list) {
                    if (string2 == null) continue;
                    arrayList.add(new DmlStatement(string2, null));
                }
            }
            dmlStatement = statementFactory.createDeleteStatement(rowData);
            arrayList.add(dmlStatement);
            rowData = this.getNextDeletedRow();
        }
        rowData = this.getNextChangedRow();
        while (rowData != null) {
            dmlStatement = statementFactory.createUpdateStatement(rowData, false, string);
            arrayList.add(dmlStatement);
            rowData = this.getNextChangedRow();
        }
        rowData = this.getNextInsertedRow();
        while (rowData != null) {
            dmlStatement = statementFactory.createInsertStatement(rowData, false, string);
            arrayList.add(dmlStatement);
            rowData = this.getNextInsertedRow();
        }
        this.resetUpdateRowCounters();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeGuarded(WbConnection wbConnection, RowData rowData, DmlStatement dmlStatement, JobErrorHandler jobErrorHandler, int n) throws SQLException {
        int n2 = 0;
        String string2 = null;
        CallerInfo callerInfo = new CallerInfo(){};
        boolean bl = wbConnection.getDbSettings().getRetrieveGeneratedKeys();
        try {
            this.currentDml = dmlStatement;
            List<String> list = rowData.getDependencyDeletes();
            if (list != null) {
                try {
                    this.currentDelete = wbConnection.createStatement();
                    for (String string2 : list) {
                        this.currentDelete.executeUpdate(string2);
                        if (!Settings.getInstance().getLogAllStatements()) continue;
                        LogMgr.logInfo(callerInfo, string2);
                    }
                }
                finally {
                    JdbcUtils.closeStatement(this.currentDelete);
                    this.currentDelete = null;
                }
            }
            n2 = dmlStatement.execute(wbConnection, rowData.isNew() && this.hasGeneratedKeys && bl);
            rowData.setDmlSent(true);
            if (Settings.getInstance().getLogAllStatements()) {
                LogMgr.logInfo(callerInfo, dmlStatement.getExecutableStatement(this.createLiteralFormatter(), this.originalConnection));
            }
        }
        catch (SQLException sQLException) {
            String string3;
            this.updateHadErrors = true;
            String string4 = string3 = string2 == null ? dmlStatement.getExecutableStatement(this.createLiteralFormatter(), this.originalConnection).toString() : string2;
            if (this.ignoreAllUpdateErrors) {
                LogMgr.logError(callerInfo, "Error executing statement " + string3 + " for row = " + rowData + ", error: " + sQLException.getMessage(), null);
            } else {
                boolean bl2 = true;
                int n3 = 3;
                if (jobErrorHandler != null) {
                    n3 = jobErrorHandler.getActionOnError(n, null, string3, sQLException.getMessage());
                }
                if (n3 == 1) {
                    bl2 = false;
                } else if (n3 == 2) {
                    bl2 = false;
                    this.ignoreAllUpdateErrors = true;
                }
                if (bl2) {
                    throw sQLException;
                }
            }
        }
        finally {
            this.currentDml = null;
        }
        return n2;
    }

    public synchronized int updateDb(WbConnection wbConnection, JobErrorHandler jobErrorHandler) throws SQLException {
        int n = 0;
        this.cancelUpdate = false;
        this.updatePkInformation();
        int n2 = this.getModifiedCount();
        this.updateHadErrors = false;
        int n3 = 0;
        if (this.rowActionMonitor != null) {
            this.rowActionMonitor.setMonitorType(1);
        }
        this.ignoreAllUpdateErrors = false;
        if (this.updateTable != null && this.resultInfo.getUpdateTable() == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Update table for ResultInfo not in sync with DataStore!");
            this.resultInfo.setUpdateTable(this.updateTable);
        }
        StatementFactory statementFactory = new StatementFactory(this.resultInfo, wbConnection);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        boolean bl = false;
        try {
            DmlStatement dmlStatement;
            this.resetUpdateRowCounters();
            RowData rowData = this.getNextDeletedRow();
            while (rowData != null) {
                this.updateProgressMonitor(++n3, n2);
                if (!rowData.isDmlSent()) {
                    dmlStatement = statementFactory.createDeleteStatement(rowData);
                    n += this.executeGuarded(wbConnection, rowData, dmlStatement, jobErrorHandler, -1);
                }
                if (this.cancelUpdate) {
                    return n;
                }
                rowData = this.getNextDeletedRow();
            }
            rowData = this.getNextChangedRow();
            while (rowData != null) {
                this.updateProgressMonitor(++n3, n2);
                if (!rowData.isDmlSent()) {
                    dmlStatement = statementFactory.createUpdateStatement(rowData, false, string);
                    n += this.executeGuarded(wbConnection, rowData, dmlStatement, jobErrorHandler, this.currentUpdateRow);
                }
                if (this.cancelUpdate) {
                    return n;
                }
                rowData = this.getNextChangedRow();
            }
            rowData = this.getNextInsertedRow();
            while (rowData != null) {
                this.updateProgressMonitor(++n3, n2);
                if (!rowData.isDmlSent()) {
                    dmlStatement = statementFactory.createInsertStatement(rowData, false, string);
                    int n4 = this.executeGuarded(wbConnection, rowData, dmlStatement, jobErrorHandler, this.currentInsertRow);
                    n += n4;
                    if (n4 == 1 && dmlStatement.hasGeneratedKeys()) {
                        this.updateGeneratedKeys(rowData, dmlStatement);
                    }
                }
                if (this.cancelUpdate) {
                    return n;
                }
                rowData = this.getNextInsertedRow();
            }
            if (!wbConnection.getAutoCommit()) {
                bl = true;
                wbConnection.commit();
            }
            this.resetStatusForSentRows();
            this.resetStatus();
        }
        catch (SQLException sQLException) {
            if (bl) {
                String string2 = ResourceMgr.getFormattedString("ErrCommit", ExceptionUtil.getDisplay(sQLException));
                if (jobErrorHandler != null) {
                    jobErrorHandler.fatalError(string2);
                } else {
                    WbSwingUtilities.showErrorMessage(null, string2);
                }
            }
            if (!wbConnection.getAutoCommit()) {
                this.resetDmlSentStatus();
                try {
                    wbConnection.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            LogMgr.logError(new CallerInfo(){}, "Error when saving data for row=" + n3 + ", error: " + sQLException.getMessage(), null);
            throw sQLException;
        }
        return n;
    }

    private void updateGeneratedKeys(RowData rowData, DmlStatement dmlStatement) {
        if (dmlStatement == null) {
            return;
        }
        if (rowData == null) {
            return;
        }
        if (this.resultInfo == null) {
            return;
        }
        for (int i = 0; i < this.resultInfo.getColumnCount(); ++i) {
            if (!this.resultInfo.getColumn(i).isAutoGenerated()) continue;
            Object object = dmlStatement.getGeneratedKey(this.resultInfo.getColumnName(i));
            rowData.setValue(i, object);
            rowData.resetStatusForColumn(i);
        }
    }

    public boolean lastUpdateHadErrors() {
        return this.updateHadErrors;
    }

    public void resetDmlSentStatus() {
        RowData rowData;
        int n;
        int n2 = this.getRowCount();
        for (n = 0; n < n2; ++n) {
            rowData = this.getRow(n);
            rowData.setDmlSent(false);
        }
        if (this.deletedRows != null) {
            n2 = this.deletedRows.size();
            for (n = 0; n < n2; ++n) {
                rowData = this.deletedRows.get(n);
                rowData.setDmlSent(false);
            }
        }
    }

    public void resetStatusForSentRows() {
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            RowData rowData = this.getRow(i);
            if (!rowData.isDmlSent()) continue;
            rowData.resetStatus();
        }
        if (this.deletedRows != null) {
            RowDataList rowDataList = this.createData(this.deletedRows.size());
            n = this.deletedRows.size();
            for (int i = 0; i < n; ++i) {
                RowData rowData = this.deletedRows.get(i);
                if (rowData.isDmlSent()) continue;
                rowDataList.add(rowData);
            }
            this.deletedRows.clear();
            this.deletedRows = rowDataList;
        }
    }

    public void resetStatus() {
        this.deletedRows = null;
        this.modified = false;
        for (int i = 0; i < this.data.size(); ++i) {
            RowData rowData = this.getRow(i);
            rowData.resetStatus();
        }
        this.resetUpdateRowCounters();
    }

    protected RowDataListSorter createSorter(SortDefinition sortDefinition) {
        RowDataListSorter rowDataListSorter = new RowDataListSorter(sortDefinition);
        rowDataListSorter.setIgnoreCase(sortDefinition.getIgnoreCase());
        return rowDataListSorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(SortDefinition sortDefinition) {
        this.lastSort = sortDefinition;
        DataStore dataStore = this;
        synchronized (dataStore) {
            RowDataListSorter rowDataListSorter = this.createSorter(sortDefinition);
            rowDataListSorter.sort(this.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortByColumn(int n, boolean bl) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            this.lastSort = new SortDefinition(n, bl);
            this.lastSort.setUseNaturalSort(this.useNaturalSort);
            RowDataListSorter rowDataListSorter = this.createSorter(this.lastSort);
            rowDataListSorter.sort(this.data);
        }
    }

    public SortDefinition getLastSort() {
        return this.lastSort;
    }

    public Object convertCellValue(Object object, int n) throws ConverterException {
        int n2 = this.getColumnType(n);
        if (object == null) {
            return null;
        }
        ValueConverter valueConverter = new ValueConverter(this.originalConnection);
        return valueConverter.convertValue(object, n2);
    }

    public int getRowStatus(int n) throws IndexOutOfBoundsException {
        RowData rowData = this.getRow(n);
        if (rowData == null) {
            return 0;
        }
        if (rowData.isNew()) {
            return 2;
        }
        if (rowData.isModified()) {
            return 1;
        }
        return 0;
    }

    public List<ColumnData> getPkValues(int n) {
        return this.getPkValues(n, false);
    }

    public List<ColumnData> getPkValues(int n, boolean bl) {
        if (this.originalConnection == null) {
            return Collections.emptyList();
        }
        try {
            this.updatePkInformation();
        }
        catch (SQLException sQLException) {
            return Collections.emptyList();
        }
        if (!this.resultInfo.hasPkColumns()) {
            return Collections.emptyList();
        }
        RowData rowData = this.getRow(n);
        if (rowData == null) {
            return Collections.emptyList();
        }
        int n2 = this.resultInfo.getColumnCount();
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>(2);
        for (int i = 0; i < n2; ++i) {
            if (!this.resultInfo.isPkColumn(i)) continue;
            ColumnIdentifier columnIdentifier = this.resultInfo.getColumn(i);
            Object object = bl ? rowData.getOriginalValue(i) : rowData.getValue(i);
            arrayList.add(new ColumnData(object, columnIdentifier));
        }
        return arrayList;
    }

    protected void resetUpdateRowCounters() {
        this.currentUpdateRow = 0;
        this.currentInsertRow = 0;
        this.currentDeleteRow = 0;
    }

    protected RowData getNextChangedRow() {
        if (this.currentUpdateRow >= this.getRowCount()) {
            return null;
        }
        int n = this.getRowCount();
        while (this.currentUpdateRow < n) {
            RowData rowData = this.getRow(this.currentUpdateRow);
            ++this.currentUpdateRow;
            if (!rowData.isModified() || rowData.isNew()) continue;
            return rowData;
        }
        return null;
    }

    public int getDeletedRowCount() {
        if (this.deletedRows == null) {
            return 0;
        }
        return this.deletedRows.size();
    }

    public Object getDeletedValue(int n, int n2) {
        if (this.deletedRows == null || this.deletedRows.size() == 0) {
            return null;
        }
        int n3 = this.deletedRows.size();
        if (n > n3) {
            return null;
        }
        RowData rowData = this.deletedRows.get(n);
        return rowData.getValue(n2);
    }

    protected RowData getNextDeletedRow() {
        if (this.deletedRows == null || this.deletedRows.size() == 0) {
            return null;
        }
        int n = this.deletedRows.size();
        if (this.currentDeleteRow > n) {
            return null;
        }
        if (this.currentDeleteRow < n) {
            RowData rowData = this.deletedRows.get(this.currentDeleteRow);
            ++this.currentDeleteRow;
            return rowData;
        }
        return null;
    }

    protected RowData getNextInsertedRow() {
        int n = this.getRowCount();
        if (this.currentInsertRow >= n) {
            return null;
        }
        while (this.currentInsertRow < n) {
            RowData rowData = this.getRow(this.currentInsertRow);
            ++this.currentInsertRow;
            if (!rowData.isNew() || !rowData.isModified()) continue;
            return rowData;
        }
        return null;
    }

    public void setPKColumns(ColumnIdentifier[] columnIdentifierArray) {
        this.resultInfo.setPKColumns(columnIdentifierArray);
        this.missingPkcolumns = null;
    }

    @Override
    public ResultInfo getResultInfo() {
        return this.resultInfo;
    }

    public ColumnIdentifier[] getColumns() {
        return this.resultInfo.getColumns();
    }

    public boolean hasPkColumns() {
        return this.resultInfo.hasPkColumns();
    }

    public void updatePkInformation() throws SQLException {
        if (this.resultInfo.hasPkColumns()) {
            return;
        }
        if (this.updateTable == null) {
            this.checkUpdateTable();
        }
        if (this.updateTable == null) {
            LogMgr.logDebug(new CallerInfo(){}, "No update table found, PK information not available");
        }
        if (this.updateTable != null && !this.hasPkColumns()) {
            LogMgr.logDebug(new CallerInfo(){}, "Trying to retrieve PK information from user-defined PK mapping");
            this.resultInfo.readPkColumnsFromMapping();
        }
    }

    public RowActionMonitor getProgressMonitor() {
        return this.rowActionMonitor;
    }

    public void setProgressMonitor(RowActionMonitor rowActionMonitor) {
        this.rowActionMonitor = rowActionMonitor;
    }

    public String toString() {
        return Integer.toString(this.getRowCount()) + " rows";
    }
}

