/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Array;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ArrayValueHandler;
import workbench.db.DbSettings;
import workbench.db.DmlExpressionBuilder;
import workbench.db.DmlExpressionType;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.storage.ColumnData;
import workbench.storage.SqlLiteralFormatter;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DmlStatement {
    private String sql;
    private List<ColumnData> values;
    private String chrFunc;
    private String concatString;
    private String concatFunction;
    private boolean formatInserts;
    private boolean formatUpdates;
    private boolean formatDeletes;
    private Map<String, Object> generatedKeys;
    private PreparedStatement currentStatement;

    public DmlStatement(String string, List<ColumnData> list) {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.countParameters(string);
        if (n > 0 && list != null && n != list.size()) {
            throw new IllegalArgumentException("Number of parameter tokens does not match number of parameters passed.");
        }
        this.sql = string;
        this.values = list == null ? Collections.emptyList() : list;
        this.initFormattingFlags();
    }

    public void setFormatSql(boolean bl) {
        this.formatInserts = bl;
        this.formatUpdates = bl;
        this.formatDeletes = bl;
    }

    private void initFormattingFlags() {
        this.formatInserts = Settings.getInstance().getDoFormatInserts();
        this.formatUpdates = Settings.getInstance().getDoFormatUpdates();
        this.formatDeletes = Settings.getInstance().getDoFormatDeletes();
    }

    public int execute(WbConnection wbConnection, boolean bl) throws SQLException {
        ArrayList<Closeable> arrayList = new ArrayList<Closeable>();
        int n = -1;
        DbSettings dbSettings = wbConnection.getDbSettings();
        boolean bl2 = dbSettings.useSetNull();
        boolean bl3 = dbSettings.useXmlAPI();
        boolean bl4 = dbSettings.useSetStringForClobs();
        boolean bl5 = dbSettings.useSetBytesForBlobs();
        boolean bl6 = dbSettings.padCharColumns();
        ArrayValueHandler arrayValueHandler = ArrayValueHandler.Factory.getInstance(wbConnection);
        DmlExpressionBuilder dmlExpressionBuilder = DmlExpressionBuilder.Factory.getBuilder(wbConnection);
        this.generatedKeys = null;
        try {
            this.currentStatement = bl ? wbConnection.getSqlConnection().prepareStatement(this.sql, 1) : wbConnection.getSqlConnection().prepareStatement(this.sql);
            for (int i = 0; i < this.values.size(); ++i) {
                Closeable closeable;
                Object object;
                ColumnData columnData = this.values.get(i);
                int n2 = columnData.getIdentifier().getDataType();
                String string = columnData.getIdentifier().getDbmsType();
                Object object2 = columnData.getValue();
                if (object2 == null) {
                    if (bl2) {
                        this.currentStatement.setNull(i + 1, n2);
                        continue;
                    }
                    this.currentStatement.setObject(i + 1, null);
                    continue;
                }
                if (SqlUtil.isClobType(n2) && object2 instanceof String) {
                    if (bl4) {
                        this.currentStatement.setString(i + 1, (String)object2);
                        continue;
                    }
                    object = (String)object2;
                    closeable = new StringReader((String)object);
                    this.currentStatement.setCharacterStream(i + 1, (Reader)closeable, ((String)object).length());
                    arrayList.add(closeable);
                    continue;
                }
                if (bl3 && SqlUtil.isXMLType(n2, string) && !dmlExpressionBuilder.isDmlExpressionDefined(string, DmlExpressionType.Any) && (object2 instanceof String || object2 instanceof Clob)) {
                    object = null;
                    object = object2 instanceof Clob ? JdbcUtils.createXML((Clob)object2, wbConnection) : JdbcUtils.createXML((String)object2, wbConnection);
                    this.currentStatement.setSQLXML(i + 1, (SQLXML)object);
                    continue;
                }
                if (object2 instanceof File) {
                    object = (File)object2;
                    try {
                        closeable = new FileInputStream((File)object);
                        if (bl5) {
                            byte[] byArray = FileUtil.readBytes((InputStream)closeable);
                            this.currentStatement.setBytes(i + 1, byArray);
                            continue;
                        }
                        this.currentStatement.setBinaryStream(i + 1, (InputStream)closeable, (int)((File)object).length());
                        arrayList.add(closeable);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new SQLException("Input file (" + ((File)object).getAbsolutePath() + ") for LOB not found!");
                    }
                }
                if (bl6 && (n2 == 1 || n2 == -15)) {
                    this.currentStatement.setString(i + 1, this.getCharValue(object2, columnData.getIdentifier().getColumnSize()));
                    continue;
                }
                if (n2 == 2003) {
                    if (arrayValueHandler != null) {
                        arrayValueHandler.setValue(this.currentStatement, i + 1, object2, columnData.getIdentifier());
                        continue;
                    }
                    this.handleArray(this.currentStatement, i + 1, object2);
                    continue;
                }
                this.currentStatement.setObject(i + 1, object2);
            }
            n = this.currentStatement.executeUpdate();
            if (bl) {
                this.retrieveKeys(this.currentStatement);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error executing statement " + this.sql, sQLException);
            throw sQLException;
        }
        finally {
            FileUtil.closeStreams(arrayList);
            JdbcUtils.closeStatement(this.currentStatement);
            this.currentStatement = null;
        }
        return n;
    }

    public void cancel() {
        if (this.currentStatement != null) {
            try {
                this.currentStatement.cancel();
            }
            catch (SQLException sQLException) {
                LogMgr.logDebug(new CallerInfo(){}, "Error when cancelling DML statement", sQLException);
            }
        }
    }

    private String getCharValue(Object object, int n) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return StringUtil.padRight((String)object, n);
        }
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveKeys(PreparedStatement preparedStatement) {
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.getGeneratedKeys();
            if (resultSet != null && resultSet.next()) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                this.generatedKeys = new HashMap<String, Object>(n);
                for (int i = 1; i <= n; ++i) {
                    this.generatedKeys.put(resultSetMetaData.getColumnName(i), resultSet.getObject(i));
                }
                LogMgr.logDebug(new CallerInfo(){}, "Driver returned generated keys: " + this.generatedKeys);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve generated key", throwable);
            this.generatedKeys = null;
        }
        finally {
            JdbcUtils.closeResult(resultSet);
        }
    }

    public boolean hasGeneratedKeys() {
        return this.generatedKeys != null && this.generatedKeys.size() > 0;
    }

    public Object getGeneratedKey(String string) {
        if (CollectionUtil.isEmpty(this.generatedKeys)) {
            return null;
        }
        Object object = this.generatedKeys.get(string);
        if (object != null) {
            return object;
        }
        if (this.generatedKeys.size() > 1) {
            LogMgr.logWarning(new CallerInfo(){}, "Multiple keys returned, but column name " + string + " not found in returned key information: " + this.generatedKeys);
        }
        return this.generatedKeys.values().iterator().next();
    }

    private void handleArray(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        String string;
        if (object instanceof Array) {
            preparedStatement.setArray(n, (Array)object);
            return;
        }
        String string2 = string = object == null ? null : object.toString().trim();
        if (StringUtil.isEmptyString(string)) {
            preparedStatement.setNull(n, 2003);
        } else {
            preparedStatement.setObject(n, object, 2003);
        }
    }

    public void setConcatString(String string) {
        if (string == null) {
            return;
        }
        this.concatString = string;
        this.concatFunction = null;
    }

    public void setConcatFunction(String string) {
        if (string == null) {
            return;
        }
        this.concatFunction = string;
        this.concatString = null;
    }

    public void setChrFunction(String string) {
        this.chrFunc = string;
    }

    public CharSequence getExecutableStatement(SqlLiteralFormatter sqlLiteralFormatter) {
        return this.getExecutableStatement(sqlLiteralFormatter, null, null);
    }

    public CharSequence getExecutableStatement(SqlLiteralFormatter sqlLiteralFormatter, WbConnection wbConnection) {
        return this.getExecutableStatement(sqlLiteralFormatter, wbConnection, null);
    }

    public CharSequence getExecutableStatement(SqlLiteralFormatter sqlLiteralFormatter, WbConnection wbConnection, String string) {
        boolean bl;
        int n;
        boolean bl2;
        CharSequence charSequence = this.sql;
        if (this.values.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.sql.length() + this.values.size() * 10);
            bl2 = false;
            n = 0;
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if (c == '\'') {
                    boolean bl3 = bl2 = !bl2;
                }
                if (c == '?' && !bl2 && n < this.values.size()) {
                    ColumnData columnData = this.values.get(n);
                    CharSequence charSequence2 = sqlLiteralFormatter.getDefaultLiteral(columnData);
                    if (this.chrFunc != null && SqlUtil.isCharacterType(columnData.getIdentifier().getDataType())) {
                        charSequence2 = this.createInsertString(charSequence2);
                    }
                    stringBuilder.append(charSequence2);
                    ++n;
                    continue;
                }
                stringBuilder.append(c);
            }
            charSequence = stringBuilder;
        }
        bl2 = !(bl = charSequence.subSequence(0, "INSERT".length()).equals("INSERT")) && charSequence.subSequence(0, "UPDATE".length()).equals("UPDATE");
        int n2 = n = !bl2 && !bl && charSequence.subSequence(0, "DELETE".length()).equals("DELETE") ? 1 : 0;
        if (bl && this.formatInserts || bl2 && this.formatUpdates || n != 0 && this.formatDeletes) {
            WbSqlFormatter wbSqlFormatter = new WbSqlFormatter(charSequence, wbConnection == null ? null : wbConnection.getDbId());
            if (string != null) {
                wbSqlFormatter.setLineEnding(string);
            }
            if (wbConnection != null) {
                wbSqlFormatter.setCatalogSeparator(wbConnection.getMetadata().getCatalogSeparator());
                wbSqlFormatter.setSchemaSeparator(wbConnection.getMetadata().getSchemaSeparator());
            }
            return wbSqlFormatter.getFormattedSql();
        }
        return charSequence;
    }

    private CharSequence createInsertString(CharSequence charSequence) {
        boolean bl;
        if (charSequence == null) {
            return null;
        }
        if (this.chrFunc == null) {
            return charSequence;
        }
        boolean bl2 = bl = this.concatFunction != null;
        if (!bl && this.concatString == null) {
            this.concatString = "||";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < ' ') {
                if (bl) {
                    if (!bl3) {
                        StringBuilder stringBuilder2 = new StringBuilder(this.concatFunction);
                        stringBuilder2.append('(');
                        stringBuilder2.append((CharSequence)stringBuilder);
                        stringBuilder = stringBuilder2;
                        bl3 = true;
                    }
                    if (bl4 && n >= 32) {
                        stringBuilder.append(",'");
                    }
                    if (n >= 32) {
                        stringBuilder.append('\'');
                    }
                    stringBuilder.append(',');
                    stringBuilder.append(this.chrFunc);
                    stringBuilder.append('(');
                    stringBuilder.append(NumberStringCache.getNumberString(c));
                    stringBuilder.append(')');
                    bl4 = true;
                } else {
                    if (n >= 32) {
                        stringBuilder.append('\'');
                        stringBuilder.append(this.concatString);
                    }
                    stringBuilder.append(this.chrFunc);
                    stringBuilder.append('(');
                    stringBuilder.append(NumberStringCache.getNumberString(c));
                    stringBuilder.append(')');
                    stringBuilder.append(this.concatString);
                    bl4 = true;
                }
            } else {
                if (bl4) {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append('\'');
                }
                stringBuilder.append(c);
                bl4 = false;
            }
            n = c;
        }
        if (bl3) {
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    private int countParameters(String string) {
        if (string == null) {
            return -1;
        }
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (c != '?' || bl) continue;
            ++n;
        }
        return n;
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return this.getSql();
    }
}

