/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class PkMapping {
    private final Map<String, String> columnMapping = new HashMap<String, String>();
    private static PkMapping instance;

    public static synchronized boolean isInitialized() {
        return instance != null;
    }

    public static synchronized PkMapping getInstance() {
        if (instance == null) {
            instance = new PkMapping();
        }
        return instance;
    }

    PkMapping(String string) {
        this.loadMapping(string);
    }

    private PkMapping() {
        String string = Settings.getInstance().getPKMappingFilename();
        this.loadMapping(string);
    }

    public synchronized void clear() {
        if (this.columnMapping != null) {
            this.columnMapping.clear();
        }
    }

    public synchronized String getMappingAsText() {
        if (CollectionUtil.isEmpty(this.columnMapping)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.columnMapping.size() * 50);
        for (Map.Entry<String, String> entry : this.columnMapping.entrySet()) {
            stringBuilder.append((Object)entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append((Object)entry.getValue());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void loadMapping(String string) {
        if (string == null) {
            return;
        }
        Properties properties = new Properties();
        File file = new File(string);
        if (!file.exists()) {
            LogMgr.logWarning(new CallerInfo(){}, "Mapping file '" + string + "' not found! Please check workbench.settings", null);
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            properties.load(bufferedInputStream);
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error reading mapping file", exception);
                this.columnMapping.clear();
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(bufferedInputStream);
                throw throwable;
            }
            FileUtil.closeQuietely(bufferedInputStream);
        }
        FileUtil.closeQuietely(bufferedInputStream);
        LogMgr.logInfo(new CallerInfo(){}, "Using PK mappings from " + file.getAbsolutePath());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (StringUtil.isEmptyString(string3)) continue;
            this.columnMapping.put(string2, string3);
        }
    }

    public synchronized void removeMapping(WbConnection wbConnection, String string) {
        if (this.columnMapping == null) {
            return;
        }
        this.columnMapping.remove(string);
    }

    public synchronized void addMapping(TableIdentifier tableIdentifier, String string) {
        this.addMapping(tableIdentifier.getTableExpression(), string);
    }

    public synchronized void addMapping(String string, String string2) {
        if (!StringUtil.isEmptyString(string) && !StringUtil.isEmptyString(string2)) {
            this.columnMapping.put(string.toLowerCase(), string2);
        }
    }

    public synchronized List<String> getPKColumns(TableIdentifier tableIdentifier) {
        Object object;
        if (this.columnMapping == null) {
            return null;
        }
        String string = tableIdentifier.getTableName().toLowerCase();
        String string2 = this.columnMapping.get(string);
        if (string2 == null) {
            object = tableIdentifier.getTableExpression().toLowerCase();
            string2 = this.columnMapping.get(object);
        }
        object = null;
        if (string2 != null) {
            object = StringUtil.stringToList(string2, ",", true, true);
            LogMgr.logInfo(new CallerInfo(){}, "Using PK Columns [" + string2 + "] for table [" + tableIdentifier.getTableExpression() + "]");
        }
        return object;
    }

    public synchronized Map<String, String> getMapping() {
        if (this.columnMapping == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.columnMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveMapping(String string) {
        if (this.columnMapping == null) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            Iterator<Map.Entry<String, String>> iterator = this.columnMapping.entrySet().iterator();
            File file = new File(string);
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("# Primary key mapping for SQL Workbench/J");
            bufferedWriter.newLine();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                bufferedWriter.write(string2);
                bufferedWriter.write(61);
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
            FileUtil.closeQuietely(bufferedWriter);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error saving mapping to properties file", exception);
        }
        finally {
            FileUtil.closeQuietely(bufferedWriter);
        }
    }

    public synchronized void addMapping(TableIdentifier tableIdentifier, ColumnIdentifier[] columnIdentifierArray) {
        StringBuilder stringBuilder = new StringBuilder(50);
        for (ColumnIdentifier columnIdentifier : columnIdentifierArray) {
            if (!columnIdentifier.isPkColumn()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(columnIdentifier.getColumnName());
        }
        if (stringBuilder.length() > 0) {
            this.addMapping(tableIdentifier, stringBuilder.toString());
        }
    }
}

