/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import workbench.db.exporter.BlobMode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.BlobLiteralFormatter;
import workbench.storage.BlobLiteralType;
import workbench.storage.DefaultBlobFormatter;
import workbench.util.FileUtil;
import workbench.util.NumberStringCache;

public class PostgresBlobFormatter
implements BlobLiteralFormatter {
    private BlobLiteralType blobLiteral;
    private DefaultBlobFormatter defaultFormatter;

    public PostgresBlobFormatter() {
        String string = Settings.getInstance().getProperty("workbench.db.postgresql.blobformat", "decode");
        this.blobLiteral = "escape".equalsIgnoreCase(string) ? BlobLiteralType.pgEscape : BlobLiteralType.pgDecode;
    }

    public PostgresBlobFormatter(BlobMode blobMode) {
        switch (blobMode) {
            case pgEscape: {
                this.setLiteralType(BlobLiteralType.pgEscape);
                break;
            }
            case pgHex: {
                this.setLiteralType(BlobLiteralType.pgHex);
                break;
            }
            case UUID: {
                this.setLiteralType(BlobLiteralType.uuid);
                break;
            }
            default: {
                this.setLiteralType(BlobLiteralType.pgDecode);
            }
        }
    }

    public PostgresBlobFormatter(BlobLiteralType blobLiteralType) {
        this.setLiteralType(blobLiteralType);
    }

    private void setLiteralType(BlobLiteralType blobLiteralType) {
        this.blobLiteral = blobLiteralType;
        if (this.blobLiteral == BlobLiteralType.uuid) {
            this.defaultFormatter = new DefaultBlobFormatter();
            this.defaultFormatter.setLiteralType(BlobLiteralType.uuid);
        }
    }

    @Override
    public CharSequence getBlobLiteral(Object object) throws SQLException {
        switch (this.blobLiteral) {
            case pgEscape: {
                return this.getEscapeString(object);
            }
            case pgHex: {
                return this.getHexString(object);
            }
            case uuid: {
                return this.getUUIDString(object);
            }
        }
        return this.getDecodeString(object);
    }

    private CharSequence getUUIDString(Object object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = this.getBytes(object);
        if (byArray == null) {
            return object.toString();
        }
        try {
            return this.defaultFormatter.getBlobLiteral(byArray);
        }
        catch (SQLException sQLException) {
            return object.toString();
        }
    }

    private CharSequence getDecodeString(Object object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = this.getBytes(object);
        if (byArray == null) {
            return object.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2 + 20);
        stringBuilder.append("decode('");
        this.appendBuffer(byArray, stringBuilder);
        stringBuilder.append("', 'hex')");
        return stringBuilder;
    }

    private CharSequence getHexString(Object object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = this.getBytes(object);
        if (byArray == null) {
            return object.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2 + 5);
        stringBuilder.append("\\\\x");
        this.appendBuffer(byArray, stringBuilder);
        return stringBuilder;
    }

    private void appendBuffer(byte[] byArray, StringBuilder stringBuilder) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] < 0 ? 256 + byArray[i] : byArray[i];
            stringBuilder.append(NumberStringCache.getHexString(n));
        }
    }

    private CharSequence getEscapeString(Object object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = this.getBytes(object);
        if (byArray == null) {
            return object.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 5 + 12);
        stringBuilder.append("E'");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append("\\\\");
            int n = byArray[i] < 0 ? 256 + byArray[i] : byArray[i];
            String string = Integer.toOctalString(n);
            int n2 = string.length();
            if (n2 == 1) {
                stringBuilder.append("00");
            } else if (n2 == 2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("'::bytea");
        return stringBuilder;
    }

    private byte[] getBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            try {
                return FileUtil.readBytes(inputStream);
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, "Could not read input stream", iOException);
            }
        }
        return null;
    }

    @Override
    public BlobLiteralType getType() {
        return this.blobLiteral;
    }
}

