/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ColumnExpression;
import workbench.storage.filter.FilterExpression;

public abstract class ComplexExpression
implements FilterExpression {
    protected List<FilterExpression> filter = new ArrayList<FilterExpression>();

    public void addExpression(FilterExpression filterExpression) {
        this.filter.add(filterExpression);
    }

    public void addColumnExpression(String string, ColumnComparator columnComparator, Object object) {
        this.addColumnExpression(string, columnComparator, object, columnComparator.supportsIgnoreCase());
    }

    public void addColumnExpression(String string, ColumnComparator columnComparator, Object object, boolean bl) {
        ColumnExpression columnExpression = new ColumnExpression(string, columnComparator, object);
        if (columnComparator.supportsIgnoreCase()) {
            columnExpression.setIgnoreCase(bl);
        }
        this.addExpression(columnExpression);
    }

    public boolean hasFilter() {
        if (this.filter == null) {
            return false;
        }
        return this.filter.size() > 0;
    }

    public void removeExpression(FilterExpression filterExpression) {
        this.filter.remove(filterExpression);
    }

    public List<FilterExpression> getExpressions() {
        return Collections.unmodifiableList(this.filter);
    }

    public void setExpressions(List<FilterExpression> list) {
        this.filter.clear();
        this.filter.addAll(list);
    }

    public boolean equals(Object object) {
        try {
            ComplexExpression complexExpression = (ComplexExpression)object;
            return this.filter.equals(complexExpression.filter);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public boolean isColumnSpecific() {
        for (FilterExpression filterExpression : this.filter) {
            if (!filterExpression.isColumnSpecific()) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract boolean evaluate(Map<String, Object> var1);
}

