/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.storage.reader.OracleRowDataReader;
import workbench.storage.reader.PostgresRowDataReader;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.SQLiteRowDataReader;
import workbench.storage.reader.SqlServerRowDataReader;

public class RowDataReaderFactory {
    public static RowDataReader createReader(ResultInfo resultInfo, WbConnection wbConnection) {
        DbMetadata dbMetadata;
        DbMetadata dbMetadata2 = dbMetadata = wbConnection == null ? null : wbConnection.getMetadata();
        if (wbConnection != null && dbMetadata != null && dbMetadata.isOracle()) {
            try {
                return new OracleRowDataReader(resultInfo, wbConnection);
            }
            catch (Exception exception) {
                if (LogMgr.isDebugEnabled()) {
                    LogMgr.logDebug(new CallerInfo(){}, "Could not instantiate OracleRowDataReader", exception);
                } else {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not instantiate OracleRowDataReader. Probably the Oracle specific classes are not available");
                }
            }
        } else {
            DbSettings dbSettings;
            if (dbMetadata != null && dbMetadata.isPostgres()) {
                return new PostgresRowDataReader(resultInfo, wbConnection);
            }
            if (dbMetadata != null && dbMetadata.isSqlServer()) {
                return new SqlServerRowDataReader(resultInfo, wbConnection);
            }
            if (DBID.SQLite.isDB(wbConnection) && (dbSettings = wbConnection.getDbSettings()) != null && dbSettings.useSQLiteDataReader()) {
                LogMgr.logDebug(new CallerInfo(){}, "Using SQLiteDataReader that returns columns with errors as a string");
                return new SQLiteRowDataReader(resultInfo, wbConnection);
            }
        }
        return new RowDataReader(resultInfo, wbConnection);
    }
}

