/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.storage.ResultInfo;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.SqlServerTZHandler;
import workbench.storage.reader.TimestampTZHandler;

public class SqlServerRowDataReader
extends RowDataReader {
    private final SqlServerTZHandler handler;

    public SqlServerRowDataReader(ResultInfo resultInfo, WbConnection wbConnection) {
        this(resultInfo, wbConnection, false);
    }

    protected SqlServerRowDataReader(ResultInfo resultInfo, WbConnection wbConnection, boolean bl) {
        super(resultInfo, wbConnection);
        boolean bl2;
        this.useGetObjectForTimestamps = bl2 = JdbcUtils.hasMiniumDriverVersion(wbConnection, "7.1");
        this.useGetObjectForDates = bl2;
        this.handler = !this.useGetObjectForTimestamps && TimestampTZHandler.Factory.supportsJava8Time(wbConnection) ? new SqlServerTZHandler(wbConnection, bl) : null;
    }

    @Override
    protected Object readTimestampValue(ResultHolder resultHolder, int n) throws SQLException {
        if (this.useGetObjectForTimestamps) {
            return resultHolder.getObject(n, LocalDateTime.class);
        }
        return super.readTimestampValue(resultHolder, n);
    }

    @Override
    protected Object readTimestampTZValue(ResultHolder resultHolder, int n) throws SQLException {
        if (this.useGetObjectForTimestamps) {
            return resultHolder.getObject(n, OffsetDateTime.class);
        }
        if (this.handler == null) {
            return super.readTimestampTZValue(resultHolder, n);
        }
        return this.handler.readOffsetDateTime(resultHolder, n);
    }
}

