/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import workbench.db.ConnectionMgr;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.reader.ResultHolder;
import workbench.storage.reader.TimestampTZHandler;

public class SqlServerTZHandler
implements TimestampTZHandler {
    private static final String MS_DTO_CLASS = "microsoft.sql.DateTimeOffset";
    private boolean useSystemClassloader;
    private Method getOffset;
    private Method getTimestamp;
    private Method valueOf;

    public SqlServerTZHandler(WbConnection wbConnection) {
        this(wbConnection, false);
    }

    public SqlServerTZHandler(WbConnection wbConnection, boolean bl) {
        this.useSystemClassloader = bl;
        this.init(wbConnection);
    }

    public Object readOffsetDateTime(ResultHolder resultHolder, int n) throws SQLException {
        Object object = resultHolder.getObject(n);
        if (object == null) {
            return null;
        }
        if (this.getTimestamp == null || this.getOffset == null) {
            return object;
        }
        String string = object.getClass().getName();
        if (MS_DTO_CLASS.equals(string)) {
            try {
                Timestamp timestamp = (Timestamp)this.getTimestamp.invoke(object, new Object[0]);
                int n2 = 0;
                Integer n3 = (Integer)this.getOffset.invoke(object, new Object[0]);
                if (n3 != null) {
                    n2 = n3;
                }
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n2 * 60);
                OffsetDateTime offsetDateTime = OffsetDateTime.of(timestamp.toLocalDateTime(), zoneOffset);
                return offsetDateTime;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return object;
    }

    @Override
    public Object convertTimestampTZ(Object object) {
        Comparable<OffsetDateTime> comparable;
        if (object == null) {
            return object;
        }
        if (this.valueOf == null) {
            return object;
        }
        Timestamp timestamp = null;
        int n = Integer.MIN_VALUE;
        if (object instanceof OffsetDateTime) {
            comparable = (OffsetDateTime)object;
            n = ((OffsetDateTime)comparable).getOffset().getTotalSeconds() * 60;
            timestamp = Timestamp.valueOf(((OffsetDateTime)comparable).toLocalDateTime());
        }
        if (object instanceof ZonedDateTime) {
            comparable = (ZonedDateTime)object;
            timestamp = Timestamp.valueOf(((ZonedDateTime)comparable).toLocalDateTime());
            n = ((ZonedDateTime)comparable).getOffset().getTotalSeconds() * 60;
        }
        if (timestamp != null && n != Integer.MIN_VALUE) {
            try {
                return this.valueOf.invoke(null, timestamp, n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return object;
    }

    private void init(WbConnection wbConnection) {
        try {
            Class clazz = this.loadClass(wbConnection, MS_DTO_CLASS);
            this.getTimestamp = clazz.getMethod("getTimestamp", null);
            this.getOffset = clazz.getMethod("getMinutesOffset", null);
            this.valueOf = clazz.getMethod("valueOf", Timestamp.class, Integer.TYPE);
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Class microsoft.sql.DateTimeOffset not available!");
        }
    }

    private Class loadClass(WbConnection wbConnection, String string) throws ClassNotFoundException {
        if (this.useSystemClassloader) {
            return Class.forName(string);
        }
        return ConnectionMgr.getInstance().loadClassFromDriverLib(wbConnection.getProfile(), string);
    }
}

