/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class AggregatingMap<K, V> {
    private final Map<K, Set<V>> content;
    private final boolean sorted;

    public AggregatingMap(boolean bl) {
        this.sorted = bl;
        this.content = bl ? new TreeMap<K, Set<V>>() : new HashMap<K, Set<V>>();
    }

    public AggregatingMap(Map<K, Set<V>> map) {
        if (map == null) {
            throw new NullPointerException("Content cannot be null");
        }
        this.content = map;
        this.sorted = false;
    }

    public Set<V> addValue(K k, Set<V> set) {
        Set<V> set2 = this.content.get(k);
        if (set2 == null) {
            set2 = this.createValueSet();
            this.content.put(k, set2);
        }
        set2.addAll(set);
        return set2;
    }

    private Set<V> createValueSet() {
        if (this.sorted) {
            return new TreeSet();
        }
        return new HashSet();
    }

    public Set<V> addValue(K k, V v) {
        Set<V> set = this.content.get(k);
        if (set == null) {
            set = this.createValueSet();
            this.content.put(k, set);
        }
        set.add(v);
        return set;
    }

    public Set<V> get(K k) {
        Set<V> set = this.content.get(k);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Map<K, Set<V>> getMap() {
        return this.content;
    }

    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.content.entrySet();
    }

    public void addAllValues(Map<K, Set<V>> map) {
        for (Map.Entry<K, Set<V>> entry : map.entrySet()) {
            this.addValue(entry.getKey(), (V)entry.getValue());
        }
    }

    public void addAll(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.addValue(entry.getKey(), entry.getValue());
        }
    }

    public int size() {
        return this.content.size();
    }
}

