/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.regex.Pattern;
import workbench.db.exporter.BlobMode;
import workbench.storage.BlobLiteralType;
import workbench.util.StringUtil;

public class BlobDecoder {
    private File baseDir;
    private static final Pattern NON_HEX = Pattern.compile("[^0-9a-f]", 2);

    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    public Object decodeBlob(String string, BlobMode blobMode) throws IOException {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        switch (blobMode) {
            case SaveToFile: {
                File file = new File(string.trim());
                if (!file.isAbsolute() && this.baseDir != null) {
                    file = new File(string.trim());
                }
                return file;
            }
            case Base64: {
                return this.decodeBase64(string);
            }
            case AnsiLiteral: {
                return this.decodeHex(string);
            }
            case UUID: {
                return this.decodeUUID(string);
            }
        }
        return string;
    }

    public byte[] decodeString(String string, BlobLiteralType blobLiteralType) throws IOException {
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        if (blobLiteralType != null) {
            switch (blobLiteralType) {
                case base64: {
                    return this.decodeBase64(string);
                }
                case octal: {
                    return this.decodeOctal(string);
                }
                case hex: {
                    return this.decodeHex(string);
                }
                case uuid: {
                    return this.decodeUUID(string);
                }
            }
        }
        throw new IllegalArgumentException("BlobLiteralType " + (Object)((Object)blobLiteralType) + " not supported");
    }

    private byte[] decodeUUID(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string2 = NON_HEX.matcher(string).replaceAll("");
        if (string2.isEmpty()) {
            return null;
        }
        if (string2.length() != 32) {
            throw new IllegalArgumentException("'" + string + "' is not a valid UUID string");
        }
        return this.plainHexToByte(string2);
    }

    private byte[] decodeOctal(String string) throws IOException {
        byte[] byArray = new byte[string.length() / 4];
        for (int i = 0; i < byArray.length; ++i) {
            byte by;
            String string2 = string.substring(i * 4 + 1, i * 4 + 4);
            byArray[i] = by = (byte)Integer.parseInt(string2, 8);
        }
        return byArray;
    }

    private byte[] decodeHex(String string) {
        int n = 0;
        int n2 = string.length();
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n = 2;
        } else if (string.toLowerCase().startsWith("x'")) {
            n = 2;
            --n2;
        }
        byte[] byArray = new byte[(n2 - n) / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = i * 2 + n;
            byArray[i] = (byte)((Character.digit(string.charAt(n3), 16) << 4) + Character.digit(string.charAt(n3 + 1), 16));
        }
        return byArray;
    }

    private byte[] plainHexToByte(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    private byte[] decodeBase64(String string) {
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(string);
    }
}

