/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;
import workbench.util.UnicodeReader;
import workbench.util.WbThread;

public class EncodingUtil {
    private static String[] charsets;

    public static Reader createReader(File file, String string) throws IOException, UnsupportedEncodingException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return EncodingUtil.createReader(fileInputStream, string);
    }

    public static Reader createReader(InputStream inputStream, String string) throws IOException, UnsupportedEncodingException {
        Reader reader = null;
        if (string != null) {
            String string2 = EncodingUtil.cleanupEncoding(string);
            if (string2.toLowerCase().startsWith("utf")) {
                reader = new UnicodeReader(inputStream, string2);
            }
            reader = new InputStreamReader(inputStream, string2);
        } else {
            reader = new InputStreamReader(inputStream);
        }
        return reader;
    }

    public static BufferedReader createBufferedReader(File file, String string) throws IOException {
        return EncodingUtil.createBufferedReader(file, string, 0x100000);
    }

    public static BufferedReader createBufferedReader(File file, String string, int n) throws IOException {
        Reader reader = EncodingUtil.createReader(file, string);
        return new BufferedReader(reader, n);
    }

    public static String cleanupEncoding(String string) {
        if (string == null) {
            return null;
        }
        if ("utf".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        String string2 = string.toUpperCase();
        Pattern pattern = Pattern.compile("UTF[0-9]+.*");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            return string2.replace("UTF", "UTF-");
        }
        Pattern pattern2 = Pattern.compile("ISO8859[0-9]+");
        Matcher matcher2 = pattern2.matcher(string2);
        if (matcher2.matches()) {
            return string2.replace("8859", "-8859-");
        }
        return string2;
    }

    public static synchronized String[] getEncodings() {
        if (charsets == null) {
            List<String> list = Settings.getInstance().getEncodingsToUse();
            if (CollectionUtil.isEmpty(list)) {
                charsets = EncodingUtil.getSystemCharsets();
            } else {
                charsets = new String[list.size()];
                int n = 0;
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    EncodingUtil.charsets[n] = string = iterator.next();
                    ++n;
                }
            }
            Arrays.sort(charsets, StringUtil.NATURAL_COMPARATOR);
        }
        return charsets;
    }

    public static boolean isMultibyte(String string) {
        try {
            Charset charset = Charset.forName(string);
            return charset.newEncoder().maxBytesPerChar() > 1.0f;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static String[] getSystemCharsets() {
        long l = System.currentTimeMillis();
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        String[] stringArray = new String[sortedMap.size()];
        int n = 0;
        Iterator<String> iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = iterator.next();
            ++n;
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving encodings took: " + l2 + "ms");
        return stringArray;
    }

    public static boolean isEncodingSupported(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        String string2 = EncodingUtil.cleanupEncoding(string);
        try {
            return Charset.isSupported(string2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Writer createWriter(File file, String string, boolean bl) throws IOException {
        return EncodingUtil.createWriter(new FileOutputStream(file, bl), string);
    }

    public static Writer createWriter(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = null;
        if (string != null) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, EncodingUtil.cleanupEncoding(string));
                bufferedWriter = new BufferedWriter(outputStreamWriter, 0x400000);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream), 0x400000);
                LogMgr.logError(new CallerInfo(){}, "Invalid encoding: " + string, unsupportedEncodingException);
            }
        }
        return bufferedWriter;
    }

    public static String getDefaultEncoding() {
        return System.getProperty("file.encoding");
    }

    public static void fetchEncodings() {
        WbThread wbThread = new WbThread("Fetch Encodings"){

            @Override
            public void run() {
                EncodingUtil.getEncodings();
            }
        };
        wbThread.start();
    }
}

