/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class FileVersioner {
    private char versionSeparator = (char)46;
    private final int maxVersions;
    private File backupDir;

    public FileVersioner(int n) {
        this(n, null, '.');
    }

    public FileVersioner(int n, String string, char c) {
        int n2 = this.maxVersions = n > 0 ? n : 5;
        if (StringUtil.isNonBlank(string)) {
            this.backupDir = new File(string);
            if (!this.backupDir.isAbsolute()) {
                this.backupDir = new File(Settings.getInstance().getConfigDir(), string);
            }
        }
        if (c != '\u0000') {
            this.versionSeparator = c;
        }
    }

    public File createBackup(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        long l = System.currentTimeMillis();
        int n = this.findNextIndex(file);
        File file2 = this.getTargetDir(file);
        if (file2 == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not determine target directory. Using current directory");
            file2 = new File(".");
        }
        if (!file2.exists() && !file2.mkdirs()) {
            LogMgr.logError(new CallerInfo(){}, "Could not create backup dir: " + file2.getAbsolutePath() + ", using directory: " + file.getParentFile().getAbsolutePath(), null);
            file2 = file.getParentFile();
        }
        File file3 = new File(file2, file.getName() + this.versionSeparator + n);
        FileUtil.copy(file, file3);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Created file \"" + file3.getAbsolutePath() + "\" as a backup of \"" + file + "\" in " + l2 + "ms");
        return file3;
    }

    private File getTargetDir(File file) {
        if (this.backupDir != null) {
            return this.backupDir;
        }
        return file.getAbsoluteFile().getParentFile();
    }

    private int findNextIndex(File file) {
        if (!file.exists()) {
            return 1;
        }
        Path path = this.getTargetDir(file).toPath();
        if (!path.toFile().exists()) {
            return 1;
        }
        String string = file.getName() + this.versionSeparator + "*";
        int n = 0;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, string);){
            for (Path path2 : directoryStream) {
                int n2;
                String string2 = path2.getFileName().toString();
                int n3 = string2.lastIndexOf(this.versionSeparator);
                if (n3 < 0 || (n2 = StringUtil.getIntValue(string2.substring(n3 + 1), -1)) <= n) continue;
                n = n2;
            }
        }
        catch (IOException iOException) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not determine highest version", iOException);
        }
        if (n < this.maxVersions) {
            return n + 1;
        }
        this.slideVersions(file);
        return this.maxVersions;
    }

    private void slideVersions(File file) {
        long l = System.currentTimeMillis();
        File file2 = this.getTargetDir(file);
        String string = file.getName();
        File file3 = new File(file2, string + this.versionSeparator + '1');
        file3.delete();
        for (int i = 2; i <= this.maxVersions; ++i) {
            File file4 = new File(file2, string + this.versionSeparator + i);
            if (!file4.exists()) continue;
            File file5 = new File(file2, string + this.versionSeparator + (i - 1));
            file4.renameTo(file5);
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Adjusting backup versions for \"" + file + "\" took " + l2 + "ms");
    }
}

