/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import workbench.util.MacOSHelper;
import workbench.util.VersionNumber;

public class PlatformHelper {
    private static String OS_NAME = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS_NAME.contains("windows");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("linux");
    }

    public static boolean isWindowsXP() {
        if (PlatformHelper.isWindows()) {
            VersionNumber versionNumber = new VersionNumber(System.getProperty("os.version"));
            VersionNumber versionNumber2 = new VersionNumber(5, 1);
            return versionNumber.isNewerOrEqual(versionNumber2);
        }
        return false;
    }

    public static boolean isWindows8() {
        if (PlatformHelper.isWindows()) {
            VersionNumber versionNumber = new VersionNumber(System.getProperty("os.version"));
            VersionNumber versionNumber2 = new VersionNumber(8, 1);
            return versionNumber.isNewerOrEqual(versionNumber2);
        }
        return false;
    }

    public static boolean isMacOS() {
        return MacOSHelper.isMacOS();
    }

    public static void installGtkPopupBugWorkaround() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        Class<?> clazz = lookAndFeel.getClass();
        if (!clazz.getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            return;
        }
        try {
            Field field = clazz.getDeclaredField("styleFactory");
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            Object object = field.get(lookAndFeel);
            field.setAccessible(bl);
            Object object2 = PlatformHelper.getGtkStyle(object, new JPopupMenu(), "POPUP_MENU");
            PlatformHelper.fixGtkThickness(object2, "yThickness");
            PlatformHelper.fixGtkThickness(object2, "xThickness");
            object2 = PlatformHelper.getGtkStyle(object, new JSeparator(), "POPUP_MENU_SEPARATOR");
            PlatformHelper.fixGtkThickness(object2, "yThickness");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fixGtkThickness(Object object, String string) throws Exception {
        Field field = object.getClass().getDeclaredField(string);
        boolean bl = field.isAccessible();
        field.setAccessible(true);
        field.setInt(object, Math.max(1, field.getInt(object)));
        field.setAccessible(bl);
    }

    private static Object getGtkStyle(Object object, JComponent jComponent, String string) throws Exception {
        Class<?> clazz = Class.forName("javax.swing.plaf.synth.Region");
        Field field = clazz.getField(string);
        Object object2 = field.get(clazz);
        Class<?> clazz2 = object.getClass();
        Method method = clazz2.getMethod("getStyle", JComponent.class, clazz);
        boolean bl = method.isAccessible();
        method.setAccessible(true);
        Object object3 = method.invoke(object, jComponent, object2);
        method.setAccessible(bl);
        return object3;
    }
}

