/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.gui.editor.SearchAndReplace;
import workbench.util.StringUtil;

public class Replacer {
    private final String searchValue;
    private final String replacement;
    private boolean isRegex;
    private Pattern replacePattern;
    private boolean ignoreCase = true;

    public Replacer(String string, String string2, boolean bl, boolean bl2) {
        this.searchValue = string;
        this.replacement = string2;
        this.isRegex = bl2;
        this.ignoreCase = bl;
        this.initPattern();
    }

    private void initPattern() {
        String string = SearchAndReplace.getSearchExpression(this.searchValue, this.ignoreCase, false, this.isRegex);
        this.replacePattern = Pattern.compile(string);
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
        this.initPattern();
    }

    public String replace(String string) {
        if (StringUtil.isEmptyString(string)) {
            return string;
        }
        Matcher matcher = this.replacePattern.matcher(string);
        return matcher.replaceAll(this.replacement);
    }
}

