/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.fire.simulation;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;
import wf.rothermel.Behave;

public class FireSimulationAlgorithm
extends GeoAlgorithm {
    private static final int NO_DATA = -1;
    private static final double[][] ANGLES = new double[][]{{315.0, 0.0, 45.0}, {270.0, 0.0, 90.0}, {225.0, 180.0, 135.0}};
    public static final String DEM = "DEM";
    public static final String MODEL = "MODEL";
    public static final String INITPOINTS = "INITPOINTS";
    public static final String WINDSPEED = "WINDSPEED";
    public static final String WINDDIR = "WINDDIR";
    public static final String DEAD1 = "DEAD1";
    public static final String DEAD10 = "DEAD10";
    public static final String DEAD100 = "DEAD100";
    public static final String HERB = "HERB";
    public static final String WOODY = "WOODY";
    public static final String TIME = "TIME";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Dead1;
    private IRasterLayer m_Dead10;
    private IRasterLayer m_Dead100;
    private IRasterLayer m_WindDir;
    private IRasterLayer m_WindSpeed;
    private IRasterLayer m_Herb;
    private IRasterLayer m_Woody;
    private IRasterLayer m_Points;
    private IRasterLayer m_Model;
    private IRasterLayer m_DEM;
    private IRasterLayer m_Time;
    private IRasterLayer m_SpreadRate;
    private IRasterLayer m_Dir;
    private IRasterLayer m_Eccentricity;
    private ArrayList m_CentralPoints;
    private ArrayList m_AdjPoints;
    private Behave m_Behave;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Fire_simulation"));
        this.setGroup(Sextante.getText((String)"Fire_modeling"));
        this.setUserCanDefineAnalysisExtent(true);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(MODEL, Sextante.getText((String)"Fuel_model"), true);
            this.m_Parameters.addInputRasterLayer(INITPOINTS, Sextante.getText((String)"Ignition_points"), true);
            this.m_Parameters.addInputRasterLayer(WINDSPEED, Sextante.getText((String)"Wind_speed_m-s"), true);
            this.m_Parameters.addInputRasterLayer(WINDDIR, Sextante.getText((String)"Wind_direction"), true);
            this.m_Parameters.addInputRasterLayer(DEAD1, Sextante.getText((String)"Dead_fuel_moisture_1H"), true);
            this.m_Parameters.addInputRasterLayer(DEAD10, Sextante.getText((String)"Dead_fuel_moisture_10H"), true);
            this.m_Parameters.addInputRasterLayer(DEAD100, Sextante.getText((String)"Dead_fuel_moisture_100"), true);
            this.m_Parameters.addInputRasterLayer(HERB, Sextante.getText((String)"Herb_fuel_moisture"), true);
            this.m_Parameters.addInputRasterLayer(WOODY, Sextante.getText((String)"Woody_fuel_moisture"), true);
            this.addOutputRasterLayer(TIME, Sextante.getText((String)"Time"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_CentralPoints = new ArrayList();
        this.m_AdjPoints = new ArrayList();
        this.m_Behave = new Behave();
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Woody = this.m_Parameters.getParameterValueAsRasterLayer(WOODY);
        this.m_Herb = this.m_Parameters.getParameterValueAsRasterLayer(HERB);
        this.m_Dead1 = this.m_Parameters.getParameterValueAsRasterLayer(DEAD1);
        this.m_Dead10 = this.m_Parameters.getParameterValueAsRasterLayer(DEAD10);
        this.m_Dead100 = this.m_Parameters.getParameterValueAsRasterLayer(DEAD100);
        this.m_WindSpeed = this.m_Parameters.getParameterValueAsRasterLayer(WINDSPEED);
        this.m_WindDir = this.m_Parameters.getParameterValueAsRasterLayer(WINDDIR);
        this.m_Model = this.m_Parameters.getParameterValueAsRasterLayer(MODEL);
        this.m_Points = this.m_Parameters.getParameterValueAsRasterLayer(INITPOINTS);
        this.m_Time = this.getNewRasterLayer(TIME, Sextante.getText((String)"Time"), 5);
        AnalysisExtent extent = this.m_Time.getLayerGridExtent();
        this.m_SpreadRate = this.getTempRasterLayer(5, extent);
        this.m_Eccentricity = this.getTempRasterLayer(5, extent);
        this.m_Dir = this.getTempRasterLayer(5, extent);
        this.m_DEM.setWindowExtent(extent);
        this.m_Herb.setWindowExtent(extent);
        this.m_Woody.setWindowExtent(extent);
        this.m_Dead1.setWindowExtent(extent);
        this.m_Dead10.setWindowExtent(extent);
        this.m_Dead100.setWindowExtent(extent);
        this.m_WindSpeed.setWindowExtent(extent);
        this.m_WindDir.setWindowExtent(extent);
        this.m_Model.setWindowExtent(extent);
        this.m_Points.setWindowExtent(extent);
        this.m_Points.setInterpolationMethod(0);
        this.m_iNX = extent.getNX();
        this.m_iNY = extent.getNY();
        this.m_Time.setNoDataValue(-1.0);
        this.m_Time.assignNoData();
        this.setProgressText(Sextante.getText((String)"Calculando_velocidades_propagacion"));
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.calculateCostValues(x, y);
                double dValue = this.m_Points.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || this.m_Points.isNoDataValue(dValue)) continue;
                this.m_CentralPoints.add(new GridCell(x, y, 0.0));
                this.m_Time.setCellValue(x, y, 0.0);
            }
        }
        this.simulateFire();
        return !this.m_Task.isCanceled();
    }

    private void calculateCostValues(int x, int y) {
        double dDead1 = this.m_Dead1.getCellValueAsDouble(x, y);
        double dDead10 = this.m_Dead10.getCellValueAsDouble(x, y);
        double dDead100 = this.m_Dead100.getCellValueAsDouble(x, y);
        double dWoody = this.m_Woody.getCellValueAsDouble(x, y);
        double dHerb = this.m_Herb.getCellValueAsDouble(x, y);
        double dWindSpeed = this.m_WindSpeed.getCellValueAsDouble(x, y);
        double dWindDir = this.m_WindDir.getCellValueAsDouble(x, y);
        double dAspect = this.m_DEM.getAspect(x, y);
        double dSlope = this.m_DEM.getSlope(x, y);
        int iModel = this.m_Model.getCellValueAsInt(x, y);
        if (!(this.m_Dead1.isNoDataValue(dDead1) || this.m_Dead10.isNoDataValue(dDead10) || this.m_Dead100.isNoDataValue(dDead100) || this.m_Herb.isNoDataValue(dHerb) || this.m_Woody.isNoDataValue(dWoody) || this.m_WindSpeed.isNoDataValue(dWindSpeed) || this.m_WindDir.isNoDataValue(dWindDir) || this.m_Model.isNoDataValue((double)iModel) || this.m_DEM.isNoDataValue(dAspect) || this.m_DEM.isNoDataValue(dSlope))) {
            if (this.m_Behave.setFuelModel(iModel)) {
                this.m_Behave.setAspect(Math.toDegrees(dAspect));
                this.m_Behave.setSlope(Math.toDegrees(dSlope));
                this.m_Behave.setWindSpeed(dWindSpeed);
                this.m_Behave.setWindDir(dWindDir);
                this.m_Behave.setWindSpeed(dWindSpeed);
                this.m_Behave.setDeadMoisture1(dDead1);
                this.m_Behave.setDeadMoisture10(dDead10);
                this.m_Behave.setDeadMoisture100(dDead100);
                this.m_Behave.setWoodyMoisture(dWoody);
                this.m_Behave.setHerbMoisture(dHerb);
                this.m_Behave.calc();
                this.m_SpreadRate.setCellValue(x, y, this.m_Behave.ros);
                this.m_Dir.setCellValue(x, y, this.m_Behave.sdr);
                this.m_Eccentricity.setCellValue(x, y, this.m_Behave.ecc);
            } else {
                this.m_SpreadRate.setNoData(x, y);
                this.m_Eccentricity.setNoData(x, y);
                this.m_Dir.setNoData(x, y);
            }
        }
    }

    private void simulateFire() {
        int j;
        int i;
        double dCellSize = this.m_Time.getWindowCellSize();
        double[][] dDist = new double[3][3];
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                dDist[i + 1][j + 1] = Math.sqrt(i * i + j * j);
            }
        }
        this.setProgressText(Sextante.getText((String)"Simulando_propagacion_fuego"));
        while (this.m_CentralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                double dSpeed1 = this.m_SpreadRate.getCellValueAsDouble(x, y);
                for (i = -1; i < 2; ++i) {
                    for (j = -1; j < 2; ++j) {
                        int x2 = x + i;
                        int y2 = y + j;
                        double dSpeed2 = this.m_SpreadRate.getCellValueAsDouble(x2, y2);
                        if (this.m_SpreadRate.isNoDataValue(dSpeed1) || this.m_SpreadRate.isNoDataValue(dSpeed2)) continue;
                        double dAccTime = this.m_Time.getCellValueAsDouble(x, y);
                        dAccTime += dCellSize * dDist[i + 1][j + 1] / this.getSpreadRateAt(x, y, i, j);
                        double dPrevTime = this.m_Time.getCellValueAsDouble(x2, y2);
                        if (!this.m_Time.isNoDataValue(dPrevTime) && !(dPrevTime > dAccTime)) continue;
                        this.m_Time.setCellValue(x2, y2, dAccTime);
                        this.m_AdjPoints.add(new GridCell(x2, y2, 0.0));
                    }
                }
            }
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            this.setProgressText(Integer.toString(this.m_CentralPoints.size()));
        }
    }

    private double getSpreadRateAt(int x, int y, int iH, int iV) {
        int x2 = x + iH;
        int y2 = y + iV;
        double dAngle = ANGLES[iV + 1][iH + 1];
        double dAngle1 = this.m_Dir.getCellValueAsDouble(x, y);
        double dAngle2 = this.m_Dir.getCellValueAsDouble(x2, y2);
        double dEcc1 = this.m_Eccentricity.getCellValueAsDouble(x, y);
        double dEcc2 = this.m_Eccentricity.getCellValueAsDouble(x2, y2);
        double dRos1 = this.m_SpreadRate.getCellValueAsDouble(x, y);
        double dRos2 = this.m_SpreadRate.getCellValueAsDouble(x2, y2);
        double dCost1 = Behave.getRosInDir(dRos1, dAngle1, dAngle, dEcc1) / 2.0;
        double dCost2 = Behave.getRosInDir(dRos2, dAngle2, dAngle, dEcc2) / 2.0;
        return dCost1 + dCost2;
    }
}

