/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.accCostAnisotropic;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;

public class AccCostAnisotropicAlgorithm
extends GeoAlgorithm {
    public static final String COST = "COST";
    public static final String COSTDIR = "COSTDIR";
    public static final String KFACTOR = "KFACTOR";
    public static final String FEATURES = "FEATURES";
    public static final String ACCCOST = "ACCCOST";
    public static final String CLOSESTPOINT = "CLOSESTPOINT";
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private static final double[] m_dDist = new double[]{1.0, Math.sqrt(2.0), 1.0, Math.sqrt(2.0), 1.0, Math.sqrt(2.0), 1.0, Math.sqrt(2.0)};
    private static final int NO_DATA = -1;
    private static final int DATA = 1;
    private static final double[][] ANGLES = new double[][]{{135.0, 180.0, 225.0}, {90.0, 0.0, 270.0}, {45.0, 0.0, 315.0}};
    private int m_iNX;
    private int m_iNY;
    private double m_dK;
    private IRasterLayer m_Cost;
    private IRasterLayer m_CostDir;
    private IRasterLayer m_Features;
    private IRasterLayer m_AccCost;
    private IRasterLayer m_ClosestPoint;
    private IRasterLayer m_Points;
    private IRasterLayer m_Points2;
    private ArrayList m_AdjPoints;
    private ArrayList m_CentralPoints;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Accumulated_cost__anisotropic"));
        this.setGroup(Sextante.getText((String)"Cost_distances_and_routes"));
        this.setUserCanDefineAnalysisExtent(true);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(COST, Sextante.getText((String)"Maximum_unitary_cost"), true);
            this.m_Parameters.addInputRasterLayer(COSTDIR, Sextante.getText((String)"Direction_of_maximum_cost_[degrees]"), true);
            this.m_Parameters.addInputRasterLayer(FEATURES, Sextante.getText((String)"Origin-destination_points"), true);
            this.m_Parameters.addNumericalValue(KFACTOR, Sextante.getText((String)"K"), 2.0, 2);
            this.addOutputRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"));
            this.addOutputRasterLayer(CLOSESTPOINT, Sextante.getText((String)"Closest_points"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iPoint = 1;
        this.m_Cost = this.m_Parameters.getParameterValueAsRasterLayer(COST);
        this.m_CostDir = this.m_Parameters.getParameterValueAsRasterLayer(COSTDIR);
        this.m_Features = this.m_Parameters.getParameterValueAsRasterLayer(FEATURES);
        this.m_AdjPoints = new ArrayList();
        this.m_CentralPoints = new ArrayList();
        this.m_dK = this.m_Parameters.getParameterValueAsDouble(KFACTOR);
        this.m_AccCost = this.getNewRasterLayer(ACCCOST, Sextante.getText((String)"Accumulated_cost"), 5);
        this.m_ClosestPoint = this.getNewRasterLayer(CLOSESTPOINT, Sextante.getText((String)"Closest_points"), 3);
        AnalysisExtent extent = this.m_AccCost.getWindowGridExtent();
        this.m_Cost.setWindowExtent(extent);
        this.m_Cost.setInterpolationMethod(4);
        this.m_CostDir.setWindowExtent(extent);
        this.m_CostDir.setInterpolationMethod(4);
        this.m_Features.setWindowExtent(extent);
        this.m_Features.setInterpolationMethod(0);
        this.m_iNX = this.m_Cost.getNX();
        this.m_iNY = this.m_Cost.getNY();
        this.m_AccCost.setNoDataValue(-1.0);
        this.m_AccCost.assignNoData();
        this.m_Points = this.getTempRasterLayer(3, extent);
        this.m_Points2 = this.getTempRasterLayer(3, extent);
        this.m_Points.setNoDataValue(-1.0);
        this.m_Points.assignNoData();
        this.m_Points2.setNoDataValue(-1.0);
        this.m_Points2.assignNoData();
        this.m_ClosestPoint.assign(0.0);
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Features.getCellValueAsDouble(x, y);
                if (dValue == 0.0 || this.m_Features.isNoDataValue(dValue)) continue;
                this.m_Points.setCellValue(x, y, 1.0);
                this.m_CentralPoints.add(new GridCell(x, y, (double)iPoint));
                this.m_AccCost.setCellValue(x, y, 0.0);
                this.m_ClosestPoint.setCellValue(x, y, (double)iPoint);
                ++iPoint;
            }
        }
        this.calculateCost();
        return !this.m_Task.isCanceled();
    }

    private void calculateCost() {
        while (this.m_CentralPoints.size() != 0 && !this.m_Task.isCanceled()) {
            for (int iPt = 0; iPt < this.m_CentralPoints.size(); ++iPt) {
                GridCell cell = (GridCell)this.m_CentralPoints.get(iPt);
                int x = cell.getX();
                int y = cell.getY();
                int iPoint = (int)cell.getValue();
                if (this.m_Points.getCellValueAsInt(x, y) != 1) continue;
                this.m_Points.setCellValue(x, y, -1.0);
                for (int i = 0; i < 8; ++i) {
                    double dCostInDir;
                    int x2 = x + m_iOffsetX[i];
                    int y2 = y + m_iOffsetY[i];
                    double dAccCost = this.m_AccCost.getCellValueAsDouble(x, y);
                    double dPrevAccCost = this.m_AccCost.getCellValueAsDouble(x2, y2);
                    if (!(dPrevAccCost > dAccCost) && !this.m_AccCost.isNoDataValue(dPrevAccCost) || (dCostInDir = this.getCostInDir(x, y, m_iOffsetX[i], m_iOffsetY[i])) == -1.0) continue;
                    dAccCost += dCostInDir * m_dDist[i];
                    if (!this.m_AccCost.isNoDataValue(dPrevAccCost) && !(dPrevAccCost > dAccCost)) continue;
                    this.m_AccCost.setCellValue(x2, y2, dAccCost);
                    this.m_ClosestPoint.setCellValue(x2, y2, (double)iPoint);
                    if (this.m_Points2.getCellValueAsInt(x2, y2) != -1) continue;
                    this.m_Points2.setCellValue(x2, y2, 1.0);
                    this.m_AdjPoints.add(new GridCell(x2, y2, (double)iPoint));
                }
            }
            IRasterLayer swap = this.m_Points;
            this.m_Points = this.m_Points2;
            this.m_Points2 = swap;
            this.m_CentralPoints = this.m_AdjPoints;
            this.m_AdjPoints = new ArrayList();
            this.setProgressText(Integer.toString(this.m_AdjPoints.size()));
        }
    }

    private double getCostInDir(int x, int y, int iH, int iV) {
        double dAngle = ANGLES[iV + 1][iH + 1];
        int x2 = x + iH;
        int y2 = y + iV;
        double dCost1 = this.m_Cost.getCellValueAsDouble(x, y);
        double dCost2 = this.m_Cost.getCellValueAsDouble(x2, y2);
        double dCostDir1 = this.m_CostDir.getCellValueAsDouble(x, y);
        double dCostDir2 = this.m_CostDir.getCellValueAsDouble(x2, y2);
        if (this.m_Cost.isNoDataValue(dCost1) || this.m_Cost.isNoDataValue(dCost2) || this.m_CostDir.isNoDataValue(dCostDir1) || this.m_CostDir.isNoDataValue(dCostDir2) || dCost1 <= 0.0 || dCost2 <= 0.0) {
            return -1.0;
        }
        double dDifAngle1 = Math.abs(dCostDir1 - dAngle);
        double dDifAngle2 = Math.abs(dCostDir2 - dAngle);
        dDifAngle1 = Math.toRadians(dDifAngle1);
        dDifAngle2 = Math.toRadians(dDifAngle2);
        double dCos1 = Math.cos(dDifAngle1);
        double dCos2 = Math.cos(dDifAngle2);
        int dSgn1 = this.signum(dCos1);
        int dSgn2 = this.signum(dCos2);
        double dExp1 = (double)dSgn1 * Math.pow(Math.abs(dCos1), this.m_dK);
        double dExp2 = (double)dSgn2 * Math.pow(Math.abs(dCos2), this.m_dK);
        dCost1 = Math.pow(dCost1, dExp1) / 2.0;
        dCost2 = Math.pow(dCost2, dExp2) / 2.0;
        return dCost1 + dCost2;
    }

    private int signum(double difAngle) {
        if (difAngle < 0.0) {
            return -1;
        }
        return 1;
    }
}

