/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.owa;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.FixedTableModel;
import java.util.ArrayList;
import java.util.Arrays;

public class OWAAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String WEIGHTS = "WEIGHTS";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Ordered_Weighted_Averaging__OWA"));
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Layers"), 1, true);
            this.m_Parameters.addFixedTable(WEIGHTS, Sextante.getText((String)"Weights"), new String[]{Sextante.getText((String)"Pesos")}, 3, false);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        ArrayList layers = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        FixedTableModel weights = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(WEIGHTS);
        if (layers.size() == 0 || weights.getRowCount() == 0 || weights.getRowCount() < layers.size()) {
            return false;
        }
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"OWA"), 5);
        double[] dWeights = new double[layers.size()];
        IRasterLayer[] windows = new IRasterLayer[layers.size()];
        for (i = 0; i < layers.size(); ++i) {
            windows[i] = (IRasterLayer)layers.get(i);
            windows[i].setWindowExtent(result.getWindowGridExtent());
            windows[i].setInterpolationMethod(4);
            try {
                dWeights[i] = Double.parseDouble(weights.getValueAt(i, 0).toString());
                continue;
            }
            catch (NumberFormatException e) {
                throw new GeoAlgorithmExecutionException(Sextante.getText((String)"OWA_Invalid_weight"));
            }
        }
        int iNX = result.getWindowGridExtent().getNX();
        int iNY = result.getWindowGridExtent().getNY();
        double[] dValues = new double[layers.size()];
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                boolean bNoDataValue = false;
                for (i = 0; i < dValues.length; ++i) {
                    dValues[i] = windows[i].getCellValueAsDouble(x, y);
                    if (!windows[i].isNoDataValue(dValues[i])) continue;
                    bNoDataValue = true;
                    break;
                }
                if (bNoDataValue) {
                    result.setNoData(x, y);
                    continue;
                }
                Arrays.sort(dValues);
                double dResult = 0.0;
                for (i = 0; i < dValues.length; ++i) {
                    dResult += dValues[i] * dWeights[i];
                }
                result.setCellValue(x, y, dResult);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

