/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridAnalysis.predictiveModels;

import Jama.Matrix;
import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class PredictiveModelsAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String POINTS = "POINTS";
    public static final String METHOD = "METHOD";
    public static final String CUTOFF = "CUTOFF";
    public static final String RESULT = "RESULT";
    private static final double NODATA = -9.9999999999999E13;
    private static final int DISTTOAVG = 0;
    private static final int MAHALANOBIS = 1;
    private static final int BIOCLIM = 2;
    private int m_iNX;
    private int m_iNY;
    private int m_iMethod;
    private double m_dCutoff;
    private double[] m_dMean;
    private double[] m_dMin;
    private double[] m_dMax;
    private double[] m_dStdDev;
    private ArrayList m_RasterLayers;
    private IVectorLayer m_Points;
    private IRasterLayer[] m_Windows;
    private IRasterLayer m_Result;
    private Matrix m_Inverse;

    public void defineCharacteristics() {
        String[] sOptions = new String[]{Sextante.getText((String)"Distance_to_mean_value"), Sextante.getText((String)"Mahalanobis_distance"), Sextante.getText((String)"BIOCLIM")};
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Raster_layer_analysis"));
        this.setName(Sextante.getText((String)"Predictive_models"));
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Predictors"), 1, true);
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Presence_points"), 0, true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sOptions);
            this.m_Parameters.addNumericalValue(CUTOFF, Sextante.getText((String)"Cutoff__BIOCLIM"), 2, 0.1, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Suitability"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_RasterLayers = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_dCutoff = this.m_Parameters.getParameterValueAsDouble(CUTOFF);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iCount = this.m_Points.getShapesCount();
        if (this.m_RasterLayers.size() == 0 || iCount < 3) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Numero_insuficiente_de_puntos"));
        }
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Suitability"), 5);
        this.m_Windows = new IRasterLayer[this.m_RasterLayers.size()];
        for (int i = 0; i < this.m_RasterLayers.size(); ++i) {
            this.m_Windows[i] = (IRasterLayer)this.m_RasterLayers.get(i);
            this.m_Windows[i].setWindowExtent(this.m_Result.getWindowGridExtent());
            this.m_Windows[i].setInterpolationMethod(4);
        }
        this.m_iNX = this.m_Result.getWindowGridExtent().getNX();
        this.m_iNY = this.m_Result.getWindowGridExtent().getNY();
        this.calculateStatisticalValues();
        this.calculateSuitability();
        return !this.m_Task.isCanceled();
    }

    private void calculateSuitability() {
        switch (this.m_iMethod) {
            case 0: {
                this.calculateDistanceToAverage();
                break;
            }
            case 1: {
                this.calculateMahalanobisDistance();
                break;
            }
            case 2: {
                this.calculateBioclim();
            }
        }
    }

    private void calculateBioclim() {
        this.setProgressText(Sextante.getText((String)"Calculating_distances"));
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                boolean bNoDataValue = false;
                double dSuitability = 1.0;
                for (int i = 0; i < this.m_Windows.length; ++i) {
                    double dValue = this.m_Windows[i].getCellValueAsDouble(x, y);
                    if (this.m_Windows[i].isNoDataValue(dValue)) {
                        bNoDataValue = true;
                        break;
                    }
                    if (!(Math.abs(dValue - this.m_dMean[i]) > this.m_dCutoff * this.m_dStdDev[i])) continue;
                    if (dValue > this.m_dMax[i] && dValue < this.m_dMin[i]) {
                        dSuitability = 0.5;
                        continue;
                    }
                    dSuitability = 0.0;
                    break;
                }
                if (bNoDataValue) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                this.m_Result.setCellValue(x, y, dSuitability);
            }
        }
    }

    private void calculateDistanceToAverage() {
        double dNormalizeFactor = Math.sqrt(this.m_Windows.length);
        this.setProgressText(Sextante.getText((String)"Calculating_distances"));
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                boolean bNoDataValue = false;
                double dDist = 0.0;
                for (int i = 0; i < this.m_Windows.length; ++i) {
                    double dValue = this.m_Windows[i].getCellValueAsDouble(x, y);
                    if (this.m_Windows[i].isNoDataValue(dValue)) {
                        bNoDataValue = true;
                        break;
                    }
                    dDist += Math.pow((dValue - this.m_dMean[i]) / (this.m_dMax[i] - this.m_dMin[i]), 2.0);
                }
                if (bNoDataValue) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                this.m_Result.setCellValue(x, y, dDist / dNormalizeFactor);
            }
        }
    }

    private void calculateMahalanobisDistance() {
        Matrix values = new Matrix(1, this.m_Windows.length);
        this.setProgressText(Sextante.getText((String)"Calculating_distances"));
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                boolean bNoDataValue = false;
                for (int i = 0; i < this.m_Windows.length; ++i) {
                    double dValue = this.m_Windows[i].getCellValueAsDouble(x, y);
                    if (this.m_Windows[i].isNoDataValue(dValue)) {
                        bNoDataValue = true;
                        break;
                    }
                    values.set(0, i, dValue - this.m_dMean[i]);
                }
                if (bNoDataValue) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                Matrix temp = values.times(this.m_Inverse);
                double dDist = temp.times(values.transpose()).get(0, 0);
                this.m_Result.setCellValue(x, y, dDist);
            }
        }
    }

    private void calculateStatisticalValues() throws GeoAlgorithmExecutionException {
        double[][] covariances = new double[this.m_Windows.length][this.m_Windows.length];
        try {
            int i;
            int iCount = this.m_Points.getShapesCount();
            double[][] values = new double[this.m_Windows.length][iCount];
            int[] iValues = new int[this.m_Windows.length];
            this.m_dMean = new double[this.m_Windows.length];
            this.m_dMin = new double[this.m_Windows.length];
            this.m_dMax = new double[this.m_Windows.length];
            this.m_dStdDev = new double[this.m_Windows.length];
            for (i = 0; i < this.m_Windows.length; ++i) {
                this.m_dMin[i] = Double.MAX_VALUE;
                this.m_dMax[i] = Double.NEGATIVE_INFINITY;
            }
            this.setProgressText(Sextante.getText((String)"Calculating_statistical_values"));
            IFeatureIterator iter = this.m_Points.iterator();
            i = 0;
            while (iter.hasNext() && this.setProgress(i, iCount)) {
                IFeature feature = iter.next();
                Coordinate pt = feature.getGeometry().getCoordinate();
                for (int j = 0; j < this.m_Windows.length; ++j) {
                    double dValue = this.m_Windows[j].getValueAt(pt.x, pt.y);
                    if (!this.m_Windows[j].isNoDataValue(dValue)) {
                        values[j][i] = dValue;
                        int n = j;
                        this.m_dMean[n] = this.m_dMean[n] + dValue;
                        this.m_dMin[j] = Math.min(this.m_dMin[j], dValue);
                        this.m_dMax[j] = Math.max(this.m_dMax[j], dValue);
                        int n2 = j;
                        iValues[n2] = iValues[n2] + 1;
                        continue;
                    }
                    values[j][i] = -9.9999999999999E13;
                }
                ++i;
            }
            iter.close();
            if (this.m_Task.isCanceled()) {
                return;
            }
            for (i = 0; i < this.m_Windows.length; ++i) {
                if (iValues[i] == 0) {
                    throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_calculando_valores_estadisticos"));
                }
                int n = i;
                this.m_dMean[n] = this.m_dMean[n] / (double)iValues[i];
            }
            if (this.m_iMethod == 1) {
                for (int iRow = 0; iRow < this.m_Windows.length; ++iRow) {
                    for (int iCol = 0; iCol < iRow + 1; ++iCol) {
                        double dCov = this.calculateCovariance(values[iCol], this.m_dMean[iCol], values[iRow], this.m_dMean[iRow]);
                        if (dCov == -9.9999999999999E13) {
                            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_calculando_valores_estadisticos"));
                        }
                        covariances[iRow][iCol] = dCov;
                        covariances[iCol][iRow] = dCov;
                    }
                }
                Matrix C = new Matrix(covariances);
                this.m_Inverse = C.inverse();
            } else if (this.m_iMethod == 2) {
                for (i = 0; i < this.m_Windows.length; ++i) {
                    this.m_dStdDev[i] = this.calculateCovariance(values[i], this.m_dMean[i], values[i], this.m_dMean[i]);
                }
            }
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Error_calculando_valores_estadisticos"));
        }
    }

    private double calculateCovariance(double[] xx, double x, double[] yy, double y) {
        double dSum = 0.0;
        int iValues = 0;
        for (int i = 0; i < yy.length; ++i) {
            if (xx[i] == -9.9999999999999E13 || yy[i] == -9.9999999999999E13) continue;
            dSum += (xx[i] - x) * (yy[i] - y);
            ++iValues;
        }
        if (iValues > 1) {
            return dSum / (double)(iValues - 1);
        }
        return -9.9999999999999E13;
    }
}

