/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.generateTerrain;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GenerateTerrainAlgorithm
extends GeoAlgorithm {
    public static final String RADIUS = "RADIUS";
    public static final String ITERATIONS = "ITERATIONS";
    public static final String DEM = "DEM";
    private int m_iNX;
    private int m_iNY;
    private int m_iRadius;
    private int m_iRadius2;
    private IRasterLayer m_DEM;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iIterations = this.m_Parameters.getParameterValueAsInt(ITERATIONS);
        this.m_iRadius = this.m_Parameters.getParameterValueAsInt(RADIUS);
        this.m_iRadius2 = (int)Math.pow(this.m_iRadius, 2.0);
        this.m_DEM = this.getNewRasterLayer(DEM, Sextante.getText((String)"Elevation"), 5);
        this.m_iNX = this.m_DEM.getWindowGridExtent().getNX();
        this.m_iNY = this.m_DEM.getWindowGridExtent().getNY();
        this.m_DEM.assign(0.0);
        for (int i = 0; i < iIterations; ++i) {
            this.addBump();
            this.setProgress(i, iIterations);
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Random_DEM"));
        this.setGroup(Sextante.getText((String)"Raster_creation_tools"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius_[cells]"), 1, 100.0, 0.0, 2.147483647E9);
            this.m_Parameters.addNumericalValue(ITERATIONS, Sextante.getText((String)"Iterations"), 1, 50.0, 0.0, 2.147483647E9);
            this.addOutputRasterLayer(DEM, Sextante.getText((String)"Elevation"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addBump() {
        int x = (int)((double)(-this.m_iRadius) + Math.random() * (double)(this.m_iNX + 2 * this.m_iRadius));
        int y = (int)((double)(-this.m_iRadius) + Math.random() * (double)(this.m_iNY + 2 * this.m_iRadius));
        for (int i = -this.m_iRadius; i < this.m_iRadius; ++i) {
            for (int j = -this.m_iRadius; j < this.m_iRadius; ++j) {
                int iDist;
                int x2 = x + i;
                int y2 = y + j;
                if (!this.m_DEM.getWindowGridExtent().containsCell(x2, y2) || (iDist = i * i + j * j) > this.m_iRadius2) continue;
                double dOffset = Math.sqrt(this.m_iRadius2 - iDist);
                this.m_DEM.addToCellValue(x2, y2, dOffset);
            }
        }
    }
}

