/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.fragstatsArea;

import es.unex.sextante.dataObjects.IRasterLayer;

public class PatchInfo {
    private final int[] m_iOffsetX = new int[]{-1, 0, 0, 1};
    private final int[] m_iOffsetY = new int[]{0, -1, 1, 0};
    private final int m_iClass;
    private int m_iCells;
    private int m_iPerimeter;
    private int m_iSumX;
    private int m_iSumY;
    private double m_dCentroidX;
    private double m_dCentroidY;
    private double m_dRadiusOfGyration;
    private final IRasterLayer m_Window;

    public PatchInfo(int iClass, IRasterLayer window) {
        this.m_Window = window;
        this.m_iCells = 0;
        this.m_iPerimeter = 0;
        this.m_iSumX = 0;
        this.m_iSumY = 0;
        this.m_iClass = iClass;
    }

    public void add(int x, int y) {
        ++this.m_iCells;
        this.m_iSumX += x;
        this.m_iSumY += y;
        for (int n = 0; n < 4; ++n) {
            int x2 = x + this.m_iOffsetX[n];
            int y2 = y + this.m_iOffsetY[n];
            int iClass = this.m_Window.getCellValueAsInt(x2, y2);
            if (!this.m_Window.isNoDataValue((double)iClass) && iClass == this.m_iClass) continue;
            ++this.m_iPerimeter;
        }
    }

    public void addForRadiusOfGyration(int x, int y) {
        this.m_dRadiusOfGyration += Math.sqrt(Math.pow((double)x - this.m_dCentroidX, 2.0) + Math.pow((double)y - this.m_dCentroidY, 2.0));
    }

    public double getPerimeter() {
        return this.m_Window.getWindowCellSize() * (double)this.m_iPerimeter;
    }

    public void calculateCentroid() {
        this.m_dCentroidX = (double)this.m_iSumX / (double)this.m_iCells;
        this.m_dCentroidY = (double)this.m_iSumY / (double)this.m_iCells;
    }

    public double getArea() {
        return this.m_Window.getWindowCellSize() * this.m_Window.getWindowCellSize() * (double)this.m_iCells;
    }

    public double getRadiusOfGyration() {
        return this.m_dRadiusOfGyration / (double)this.m_iCells * this.m_Window.getWindowCellSize();
    }

    public int getClassID() {
        return this.m_iClass;
    }

    public int getAreaInCells() {
        return this.m_iCells;
    }

    public int getPerimeterInCells() {
        return this.m_iPerimeter;
    }
}

