/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.reclassify;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.FixedTableModel;

public class ReclassifyAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String METHOD = "METHOD";
    public static final String RECLASS = "RECLASS";
    public static final String LUT = "LUT";
    public static final int METHOD_LOWER_THAN = 0;
    public static final int METHOD_LOWER_THAN_OR_EQUAL = 1;

    public void defineCharacteristics() {
        String[] sColumnNames = new String[]{Sextante.getText((String)"Min_value"), Sextante.getText((String)"Max_value"), Sextante.getText((String)"New_value")};
        String[] sMethod = new String[]{"Min < x < Max", "Min < x <= Max"};
        this.setName(Sextante.getText((String)"Reclassify"));
        this.setGroup(Sextante.getText((String)"Reclassify_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer_to_reclassify"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addFixedTable(LUT, Sextante.getText((String)"Look-up_table"), sColumnNames, 1, false);
            this.addOutputRasterLayer(RECLASS, Sextante.getText((String)"Reclassify"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        boolean bClassGroupNotFound = false;
        IRasterLayer grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        IRasterLayer result = this.getNewRasterLayer(RECLASS, grid.getName() + Sextante.getText((String)"[reclassified]"), 5);
        FixedTableModel lut = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(LUT);
        grid.setWindowExtent(result.getWindowGridExtent());
        grid.setInterpolationMethod(0);
        int iNX = grid.getNX();
        int iNY = grid.getNY();
        if (iMethod == 0) {
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    int i;
                    double dCellValue = grid.getCellValueAsDouble(x, y);
                    for (i = 0; i < lut.getRowCount(); ++i) {
                        double dMaxValue;
                        double dMinValue = Double.parseDouble(lut.getValueAt(i, 0).toString());
                        if (!(dCellValue > dMinValue) || !(dCellValue < (dMaxValue = Double.parseDouble(lut.getValueAt(i, 1).toString())))) continue;
                        double dNewValue = Double.parseDouble(lut.getValueAt(i, 2).toString());
                        result.setCellValue(x, y, dNewValue);
                        break;
                    }
                    if (i < lut.getRowCount()) continue;
                    result.setCellValue(x, y, dCellValue);
                    bClassGroupNotFound = true;
                }
            }
        } else {
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    int i;
                    double dCellValue = grid.getCellValueAsDouble(x, y);
                    for (i = 0; i < lut.getRowCount(); ++i) {
                        double dMaxValue;
                        double dMinValue = Double.parseDouble(lut.getValueAt(i, 0).toString());
                        if (!(dCellValue > dMinValue) || !(dCellValue <= (dMaxValue = Double.parseDouble(lut.getValueAt(i, 1).toString())))) continue;
                        double dNewValue = Double.parseDouble(lut.getValueAt(i, 2).toString());
                        result.setCellValue(x, y, dNewValue);
                        break;
                    }
                    if (i < lut.getRowCount()) continue;
                    result.setCellValue(x, y, dCellValue);
                    bClassGroupNotFound = true;
                }
                this.setProgress(y, iNY);
            }
        }
        if (bClassGroupNotFound) {
            Sextante.addWarningToLog((String)Sextante.getText((String)"ClassGroupNotFound"));
        }
        return !this.m_Task.isCanceled();
    }
}

