/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.reclassifyConsecutive;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.HashMap;

public class ReclassifyConsecutiveAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String RECLASS = "RECLASS";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Reclassify_into_ordered_classes"));
        this.setGroup(Sextante.getText((String)"Reclassify_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputRasterLayer(RECLASS, Sextante.getText((String)"Reclassify"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iClass = 1;
        IRasterLayer window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        IRasterLayer result = this.getNewRasterLayer(RECLASS, window.getName() + Sextante.getText((String)"[reclassified]"), 3);
        window.setWindowExtent(result.getWindowGridExtent());
        window.setInterpolationMethod(0);
        int iNX = window.getNX();
        int iNY = window.getNY();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = window.getCellValueAsDouble(x, y);
                if (!window.isNoDataValue(dValue)) {
                    Integer ClassID = new Integer(window.getCellValueAsInt(x, y));
                    if (map.containsKey(ClassID)) {
                        result.setCellValue(x, y, (double)((Integer)map.get(ClassID)).intValue());
                        continue;
                    }
                    result.setCellValue(x, y, (double)iClass);
                    map.put(ClassID, new Integer(iClass));
                    ++iClass;
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

