/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.reclassifyEqualAmplitude;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ReclassifyEqualAmplitudeAlgorithm
extends GeoAlgorithm {
    public static final String CLASSCOUNT = "CLASSCOUNT";
    public static final String RECLASS = "RECLASS";
    public static final String INPUT = "INPUT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Divide_into_n_classes_of_equal_amplitude"));
        this.setGroup(Sextante.getText((String)"Reclassify_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(CLASSCOUNT, Sextante.getText((String)"Number_of_classes"), 1, 10.0, 2.0, 2.147483647E9);
            this.addOutputRasterLayer(RECLASS, Sextante.getText((String)"Reclassify"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        int iClasses = this.m_Parameters.getParameterValueAsInt(CLASSCOUNT);
        IRasterLayer result = this.getNewRasterLayer(RECLASS, grid.getName() + Sextante.getText((String)"[reclassified]"), 3);
        grid.setWindowExtent(result.getWindowGridExtent());
        double dMax = grid.getMaxValue();
        double dMin = grid.getMinValue();
        if (dMax != dMin) {
            double dClassAmplitude = (dMax - dMin) / (double)iClasses;
            int iNX = grid.getNX();
            int iNY = grid.getNY();
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    double dValue = grid.getCellValueAsDouble(x, y);
                    if (!grid.isNoDataValue(dValue)) {
                        int iClass = (int)Math.floor(Math.min((dValue - dMin) / dClassAmplitude, (double)(iClasses - 1)));
                        result.setCellValue(x, y, (double)(iClass + 1));
                        continue;
                    }
                    result.setNoData(x, y);
                }
            }
        }
        return !this.m_Task.isCanceled();
    }
}

