/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.tabulateArea;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gridCategorical.tabulateArea.SubAreaResult;
import es.unex.sextante.gridCategorical.tabulateArea.TabulateSubArea;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public class TabulateAreaAlgorithm
extends GeoAlgorithm {
    public static final String GRID = "GRID";
    public static final String GRID2 = "GRID2";
    public static final String TABLE = "TABLE";
    public static final String COMPACT = "COMPACT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Window;
    private IRasterLayer m_Window2;
    private int numAreas;
    private int absStep;
    private int normStep;
    private final String LOGGING_TEXT1 = Sextante.getText((String)"Tabulating subzones");
    private final String LOGGING_TEXT2 = Sextante.getText((String)"Merging results");
    private final int MAXTILESIZE = 0x800000;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Tabulate_Area"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Zones_Grid"), true);
            this.m_Parameters.addInputRasterLayer(GRID2, Sextante.getText((String)"Values_Grid"), true);
            this.m_Parameters.addBoolean(COMPACT, Sextante.getText((String)"Compact_output"), false);
            this.addOutputTable(TABLE, Sextante.getText((String)"Tabulate_Area"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Class[] types;
        String[] sFields;
        long time1 = System.currentTimeMillis();
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        this.m_Window2 = this.m_Parameters.getParameterValueAsRasterLayer(GRID2);
        boolean useCompactOutput = this.m_Parameters.getParameterValueAsBoolean(COMPACT);
        this.m_Window.setWindowExtent(this.m_AnalysisExtent);
        this.m_Window.setInterpolationMethod(0);
        this.m_Window2.setWindowExtent(this.m_AnalysisExtent);
        this.m_Window2.setInterpolationMethod(0);
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        double cellArea = this.m_AnalysisExtent.getCellSize() * this.m_AnalysisExtent.getCellSize();
        int maxRowPerArea = 0x800000 > this.m_iNX ? (int)Math.floor(0x800000 / this.m_iNX) : 1;
        this.numAreas = (int)Math.ceil((float)this.m_iNY / (float)maxRowPerArea);
        TabulateSubArea subArea = new TabulateSubArea(this, this.m_Window, this.m_Window2);
        int currY = 0;
        SubAreaResult[] result = new SubAreaResult[this.numAreas];
        System.out.println("Num Areas: " + this.numAreas);
        for (int curArea = 0; curArea < this.numAreas; ++curArea) {
            int maxY = Math.min(currY + maxRowPerArea - 1, this.m_iNY - 1);
            result[curArea] = subArea.processArea(0, currY, this.m_iNX - 1, maxY);
            this.setProgress(this.LOGGING_TEXT1);
            System.gc();
            if (result[curArea] != null && !result[curArea].isSuccessful()) {
                for (SubAreaResult element : result) {
                    try {
                        if (result[curArea].getReader() == null) continue;
                        result[curArea].getReader().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
            currY += maxRowPerArea;
        }
        subArea = null;
        System.gc();
        HashSet<Object> globalZonesSet = new HashSet<Object>();
        for (int curArea = 0; curArea < this.numAreas; ++curArea) {
            if (result[curArea] == null) continue;
            Map<Object, Integer> currZonesMap = result[curArea].getZones();
            for (Object o : currZonesMap.keySet()) {
                if (globalZonesSet.contains(o)) continue;
                globalZonesSet.add(o);
            }
        }
        Object[] m_ArrayZones = globalZonesSet.toArray(new Object[globalZonesSet.size()]);
        Arrays.sort(m_ArrayZones);
        HashMap<Object, Integer> globalZonesMap = new HashMap<Object, Integer>();
        for (int i = 0; i < m_ArrayZones.length; ++i) {
            globalZonesMap.put(m_ArrayZones[i], new Integer(i + 1));
        }
        m_ArrayZones = null;
        Sextante.addInfoToLog((String)("Total zones: " + globalZonesMap.size()));
        this.setProgressText(this.LOGGING_TEXT2);
        this.setProgress(51, 100);
        String sTableName = Sextante.getText((String)"Tabulate_Area");
        if (useCompactOutput) {
            sFields = new String[3];
            types = new Class[3];
            sFields[0] = "VALUE";
            types[0] = Integer.class;
            sFields[1] = "ZONE";
            types[1] = Integer.class;
            sFields[2] = "AREA";
            types[2] = Integer.class;
        } else {
            sFields = new String[globalZonesMap.size() + 1];
            types = new Class[globalZonesMap.size() + 1];
            sFields[0] = "VALUE";
            types[0] = Integer.class;
            for (Object zone : globalZonesMap.keySet()) {
                int idx = (Integer)globalZonesMap.get(zone);
                sFields[idx] = zone.toString();
                types[idx] = zone.getClass();
            }
        }
        ITable outputTable = this.getNewTable(TABLE, sTableName, types, sFields);
        try {
            TreeSet<Object> nextValues = new TreeSet<Object>();
            for (int curArea = 0; curArea < this.numAreas; ++curArea) {
                IRecord next;
                if (result[curArea] == null || !result[curArea].getReader().hasNext() || (next = result[curArea].getReader().getNext()) == null) continue;
                nextValues.add(next.getValue(0));
            }
            boolean zoneCount = false;
            while (nextValues.size() > 0) {
                Object[] row = new Object[globalZonesMap.size() + 1];
                Object curValue = nextValues.first();
                row[0] = curValue;
                for (int k = 1; k < row.length; ++k) {
                    row[k] = 0;
                }
                for (int curArea = 0; curArea < this.numAreas; ++curArea) {
                    IRecord cur;
                    if (result[curArea] == null || (cur = result[curArea].getReader().getCurrent()) == null || !cur.getValue(0).equals(curValue)) continue;
                    Map<Object, Integer> zonesMap = result[curArea].getZones();
                    for (Object theZone : zonesMap.keySet()) {
                        int globalIndex = (Integer)globalZonesMap.get(theZone);
                        int localIndex = zonesMap.get(theZone);
                        row[globalIndex] = new Long(((Number)row[globalIndex]).longValue() + ((Number)cur.getValue(localIndex + 1)).longValue());
                    }
                    if (result[curArea].getReader().hasNext()) {
                        cur = result[curArea].getReader().getNext();
                        if (cur == null) continue;
                        nextValues.add(cur.getValue(0));
                        continue;
                    }
                    result[curArea] = null;
                    this.setProgress(this.LOGGING_TEXT2);
                }
                nextValues.remove(curValue);
                if (useCompactOutput) {
                    Object[] tmpRow = new Object[3];
                    for (Object zone : globalZonesMap.keySet()) {
                        int globalIdx = (Integer)globalZonesMap.get(zone);
                        int value = ((Number)row[globalIdx]).intValue();
                        if (value <= 0) continue;
                        tmpRow[0] = row[0];
                        tmpRow[1] = zone;
                        double areaValue = (double)((Number)row[globalIdx]).longValue() * cellArea;
                        tmpRow[2] = new Long(Math.round(areaValue));
                        outputTable.addRecord(tmpRow);
                    }
                    continue;
                }
                for (int i = 1; i < row.length; ++i) {
                    double areaValue = (double)((Number)row[i]).longValue() * cellArea;
                    row[i] = new Long(Math.round(areaValue));
                }
                outputTable.addRecord(row);
            }
            long time2 = System.currentTimeMillis();
            this.setProgress(100, 100);
            result = null;
            System.gc();
            System.out.println("Processing time: " + (double)(time2 - time1) / 1000.0 + "secs.");
            Sextante.addInfoToLog((String)(Sextante.getText((String)"Processing_time") + (double)(time2 - time1) / 1000.0 + "secs."));
            System.out.println("Cell size: " + this.m_AnalysisExtent.getCellSize());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.m_Task.isCanceled();
    }

    protected void setProgress(String text) {
        ++this.absStep;
        int curStep = this.absStep * 100 / (2 * this.numAreas);
        if (curStep > this.normStep) {
            this.normStep = curStep;
            this.setProgressText(text);
            this.setProgress(this.normStep, 100);
        }
    }

    protected boolean isCancelled() {
        return this.m_Task.isCanceled();
    }

    protected OutputFactory getOuputFactory() {
        return this.m_OutputFactory;
    }
}

