/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.tabulateArea;

import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gridCategorical.tabulateArea.SubAreaResult;
import es.unex.sextante.gridCategorical.tabulateArea.TabulateAreaAlgorithm;
import es.unex.sextante.gridCategorical.tabulateArea.TempTableReader;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TabulateSubArea {
    public static final String GRID = "GRID";
    public static final String GRID2 = "GRID2";
    public static final String TABLE = "TABLE";
    private Map<Object, Integer> m_MapValues;
    private Map<Object, Integer> m_MapZones;
    private final IRasterLayer m_Window;
    private final IRasterLayer m_Window2;
    TabulateAreaAlgorithm alg;
    private String tmpTableName = null;

    public TabulateSubArea(TabulateAreaAlgorithm alg, IRasterLayer zonesWindow, IRasterLayer classesWindow) {
        this.m_Window = zonesWindow;
        this.m_Window2 = classesWindow;
        this.alg = alg;
    }

    public SubAreaResult processArea(int minX, int minY, int maxX, int maxY) throws GeoAlgorithmExecutionException {
        SubAreaResult result = new SubAreaResult();
        try {
            int j;
            this.createMaps(minX, minY, maxX, maxY);
            int iZoneCount = this.m_MapZones.size();
            int iValueCount = this.m_MapValues.size();
            if (iZoneCount == 0 || iValueCount == 0) {
                result = null;
                return result;
            }
            int[][] table = new int[iZoneCount][iValueCount];
            for (int i = 0; i < iValueCount; ++i) {
                for (j = 0; j < iZoneCount; ++j) {
                    table[j][i] = 0;
                }
            }
            for (int y = minY; y <= maxY && !this.alg.isCancelled(); ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    int iZone = this.m_Window.getCellValueAsInt(x, y);
                    int iValue = this.m_Window2.getCellValueAsInt(x, y);
                    if (this.m_Window.isNoDataValue((double)iZone) || this.m_Window2.isNoDataValue((double)iValue)) continue;
                    int iZoneIdx = this.m_MapZones.get(new Integer(iZone));
                    int iValueIdx = this.m_MapValues.get(new Integer(iValue));
                    int[] nArray = table[iZoneIdx];
                    int n = iValueIdx;
                    nArray[n] = nArray[n] + 1;
                }
            }
            if (this.alg.isCancelled()) {
                result.setSuccessful(false);
                return result;
            }
            String[] sFields = new String[iZoneCount + 1];
            Class[] types = new Class[iZoneCount + 1];
            sFields[0] = "VALUE";
            types[0] = Integer.class;
            for (Object obj : this.m_MapZones.keySet()) {
                int idx = this.m_MapZones.get(obj);
                sFields[idx + 1] = obj.toString();
                types[idx + 1] = Integer.class;
            }
            ITable tmpTable = this.createTempTable(types, sFields);
            boolean emptyRow = true;
            for (Object obj : this.m_MapValues.keySet()) {
                Integer index = this.m_MapValues.get(obj);
                Object[] values = new Object[iZoneCount + 1];
                values[0] = obj;
                for (j = 1; j <= iZoneCount; ++j) {
                    int value = table[j - 1][index];
                    if (value <= 0) continue;
                    values[j] = new Integer(value);
                    emptyRow = false;
                }
                if (emptyRow) continue;
                tmpTable.addRecord(values);
                emptyRow = true;
            }
            tmpTable.postProcess();
            tmpTable.open();
            if (tmpTable.getRecordCount() == 0L) {
                tmpTable.close();
                File f = new File(this.tmpTableName);
                f.delete();
                result = null;
            } else {
                TempTableReader tmpReader = new TempTableReader(tmpTable);
                tmpReader.init();
                result.setReader(tmpReader);
                result.setSuccessful(!this.alg.isCancelled());
                result.setZones(this.m_MapZones);
            }
            tmpTable = null;
            this.m_MapValues = null;
            this.m_MapZones = null;
            return result;
        }
        catch (IOException e) {
            Sextante.getLogger().addError((Throwable)e);
            result.setSuccessful(false);
            return result;
        }
        catch (Exception e) {
            Sextante.getLogger().addError((Throwable)e);
            result.setSuccessful(false);
            return result;
        }
    }

    private void createMaps(int minX, int minY, int maxX, int maxY) {
        this.m_MapValues = new TreeMap<Object, Integer>();
        this.m_MapZones = new HashMap<Object, Integer>();
        Integer iID = 0;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                int iCellValue = this.m_Window.getCellValueAsInt(x, y);
                Integer iClass = new Integer(iCellValue);
                if (!this.m_Window.isNoDataValue((double)iCellValue) && !this.m_MapZones.containsKey(iClass)) {
                    iID = new Integer(this.m_MapZones.size());
                    this.m_MapZones.put(iClass, iID);
                }
                if (this.m_Window2.isNoDataValue((double)(iCellValue = this.m_Window2.getCellValueAsInt(x, y))) || this.m_MapValues.containsKey(iClass = new Integer(iCellValue))) continue;
                iID = new Integer(this.m_MapValues.size());
                this.m_MapValues.put(iClass, iID);
            }
        }
    }

    private ITable createTempTable(Class[] types, String[] sFields) throws IOException, UnsupportedOutputChannelException {
        OutputFactory factory = this.alg.getOuputFactory();
        this.tmpTableName = factory.getTempTableFilename();
        File f = new File(this.tmpTableName);
        FileOutputChannel channel = new FileOutputChannel(this.tmpTableName);
        return factory.getNewTable(this.tmpTableName, types, sFields, (IOutputChannel)channel);
    }
}

