/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.aggregate;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.HashMap;
import java.util.Set;

public class AggregateAlgorithm
extends GeoAlgorithm {
    public static final String GRID = "GRID";
    public static final String METHOD = "METHOD";
    public static final String SIZE = "SIZE";
    public static final String RESULT = "RESULT";
    public static final int SUM = 0;
    public static final int MAX = 1;
    public static final int MIN = 2;
    public static final int MODE = 3;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Sum"), Sextante.getText((String)"Maximum"), Sextante.getText((String)"Minimum"), Sextante.getText((String)"Moda")};
        this.setName(Sextante.getText((String)"Aggregate"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(GRID, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"M\u00e9todo"), sMethod);
            this.m_Parameters.addNumericalValue(SIZE, Sextante.getText((String)"Aggregation_factor"), 1, 2.0, 2.0, 2.147483647E9);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Aggregated_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        HashMap<Double, Integer> map = new HashMap<Double, Integer>();
        int iSize = this.m_Parameters.getParameterValueAsInt(SIZE);
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        IRasterLayer window = this.m_Parameters.getParameterValueAsRasterLayer(GRID);
        window.setFullExtent();
        AnalysisExtent ge = window.getLayerGridExtent();
        int iNX = (int)Math.floor(window.getNX() / iSize);
        int iNY = (int)Math.floor(window.getNY() / iSize);
        double dCellSize = window.getLayerCellSize() * (double)iSize;
        AnalysisExtent resultExtent = new AnalysisExtent();
        resultExtent.setCellSize(dCellSize);
        resultExtent.setXRange(ge.getXMin(), ge.getXMin() + (double)iNX * dCellSize, true);
        resultExtent.setYRange(ge.getYMin(), ge.getYMin() + (double)iNY * dCellSize, true);
        String sName = window.getName() + Sextante.getText((String)"[aggregated]");
        IRasterLayer result = this.getNewRasterLayer(RESULT, sName, window.getDataType(), resultExtent);
        int y = 0;
        for (int y2 = 0; y2 < iNY && this.setProgress(y, iNY); ++y2) {
            int x = 0;
            for (int x2 = 0; x2 < iNX; ++x2) {
                Integer count;
                double dValue;
                double dMin;
                double dMax = dMin = window.getCellValueAsDouble(x, y);
                double dSum = 0.0;
                for (int i = 0; i < iSize; ++i) {
                    for (int j = 0; j < iSize; ++j) {
                        dValue = window.getCellValueAsDouble(x + i, y + j);
                        if (window.isNoDataValue(dValue)) continue;
                        if (dValue > dMax) {
                            dMax = dValue;
                        }
                        if (dValue < dMin) {
                            dMin = dValue;
                        }
                        dSum += dValue;
                        Double value = new Double(dValue);
                        count = (Integer)map.get(new Double(dValue));
                        count = count != null ? new Integer(count + 1) : new Integer(1);
                        map.put(new Double(dValue), count);
                    }
                }
                int iMaxCount = 0;
                double dMode = window.getNoDataValue();
                Set set = map.keySet();
                for (Double value : set) {
                    int iCount;
                    dValue = value;
                    count = (Integer)map.get(value);
                    if (count == null) {
                        count = new Integer(1);
                    }
                    if ((iCount = count.intValue()) > iMaxCount) {
                        dMode = dValue;
                        iMaxCount = iCount;
                    }
                    map.put(value, new Integer(iCount + 1));
                }
                switch (iMethod) {
                    case 0: {
                        result.setCellValue(x2, y2, dSum);
                        break;
                    }
                    case 2: {
                        result.setCellValue(x2, y2, dMin);
                        break;
                    }
                    case 1: {
                        result.setCellValue(x2, y2, dMax);
                        break;
                    }
                    case 3: {
                        result.setCellValue(x, y, dMode);
                    }
                }
                x += iSize;
            }
            y += iSize;
        }
        return !this.m_Task.isCanceled();
    }
}

