/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.clipBBoxGrid;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.awt.geom.Rectangle2D;

public class clipBBoxGridAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String POLYGONS = "POLYGONS";
    public static final String RESULT = "RESULT";
    private AnalysisExtent m_Extent;
    private int m_iMinX;
    private int m_iMinY;
    private IRasterLayer m_Output;
    private IRasterLayer m_Raster;
    private IVectorLayer m_Polygons;
    private int m_iNX;
    private int m_iNY;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Clip_grid_with_bbox_of_polygons"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer_to_clip"), true);
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons"), 2, true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Clipped_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Raster = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_Polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.clip();
        return !this.m_Task.isCanceled();
    }

    private void clip() throws UnsupportedOutputChannelException, IteratorException {
        this.m_Extent = this.getAdjustedGridExtent();
        if (this.m_Extent != null) {
            this.m_Raster.setWindowExtent(this.m_Extent);
            this.m_Output = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Result"), this.m_Raster.getDataType(), this.m_Extent, this.m_Raster.getBandsCount());
            this.m_Output.setNoDataValue(this.m_Raster.getNoDataValue());
            this.m_Output.assignNoData();
            this.m_iNX = this.m_Extent.getNX();
            this.m_iNY = this.m_Extent.getNY();
            int i = 0;
            IFeatureIterator iter = this.m_Polygons.iterator();
            int iShapeCount = this.m_Polygons.getShapesCount();
            while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                this.doPolygon(geom);
                if (this.m_Task.isCanceled()) {
                    return;
                }
                ++i;
            }
            iter.close();
        }
    }

    private void doPolygon(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part);
        }
    }

    private void doPolygonPart(Geometry geom) {
        int xStop;
        Envelope extent = geom.getEnvelopeInternal();
        int xStart = (int)((extent.getMinX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) - 1;
        if (xStart < 0) {
            xStart = 0;
        }
        if ((xStop = (int)((extent.getMaxX() - this.m_Extent.getXMin()) / this.m_Extent.getCellSize()) + 1) >= this.m_iNX) {
            xStop = this.m_iNX - 1;
        }
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = xStart; x <= xStop; ++x) {
                for (int i = 0; i < this.m_Raster.getBandsCount(); ++i) {
                    this.m_Output.setCellValue(x, y, i, this.m_Raster.getCellValueAsDouble(x, y, i));
                }
            }
        }
    }

    private AnalysisExtent getAdjustedGridExtent() {
        AnalysisExtent ge = new AnalysisExtent();
        Rectangle2D rect = this.m_Polygons.getFullExtent();
        double dMinX = this.m_Raster.getLayerGridExtent().getXMin();
        double dMinY = this.m_Raster.getLayerGridExtent().getYMin();
        double dCellSize = this.m_Raster.getLayerGridExtent().getCellSize();
        this.m_iMinX = (int)Math.floor((rect.getMinX() - dMinX) / dCellSize);
        double iMaxX = Math.ceil((rect.getMaxX() - dMinX) / dCellSize);
        this.m_iMinY = (int)Math.floor((rect.getMinY() - dMinY) / dCellSize);
        double iMaxY = Math.ceil((rect.getMaxY() - dMinY) / dCellSize);
        double dMinX2 = dMinX + (double)this.m_iMinX * dCellSize;
        double dMinY2 = dMinY + (double)this.m_iMinY * dCellSize;
        double dMaxX2 = dMinX + iMaxX * dCellSize;
        double dMaxY2 = dMinY + iMaxY * dCellSize;
        ge.setCellSize(dCellSize);
        ge.setXRange(dMinX2, dMaxX2, true);
        ge.setYRange(dMinY2, dMaxY2, true);
        return ge;
    }
}

